/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.suits;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.pets.PetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.suits.SuitType;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumArmorType;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.GColor;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Rarity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.inventory.ItemStack;

public class SuitEquipmentType {
    private static final List<SuitEquipmentType> VALUES = new ArrayList<SuitEquipmentType>();
    private static final HashMap<EnumSuitType, ArrayList<SuitEquipmentType>> GROUPS = new HashMap();
    public static final SuitEquipmentType FROG_HELMET = new SuitEquipmentType("Frog", "Frog Helmet", "&6Frog Suit Helmet", new GMaterial("head:cc3c601e4ba3064bec98a51552473aa7a5646e60fddc18d187c09b4a351d2"), "gadgetsmenu.suits.frog.helmet", 80, Rarity.LEGENDARY, null, EnumArmorType.HELMET);
    public static final SuitEquipmentType FROG_CHESTPLATE = new SuitEquipmentType("Frog", "Frog Chestplate", "&5Frog Suit Chestplate", new GMaterial(EnumMaterial.LEATHER_CHESTPLATE, new GColor("395E2D")), "gadgetsmenu.suits.frog.chestplate", 32, Rarity.EPIC, null, EnumArmorType.CHESTPLATE);
    public static final SuitEquipmentType FROG_LEGGINGS = new SuitEquipmentType("Frog", "Frog Leggings", "&9Frog Suit Leggings", new GMaterial(EnumMaterial.LEATHER_LEGGINGS, new GColor("395E2D")), "gadgetsmenu.suits.frog.leggings", 18, Rarity.RARE, null, EnumArmorType.LEGGINGS);
    public static final SuitEquipmentType FROG_BOOTS = new SuitEquipmentType("Frog", "Frog Boots", "&aFrog Suit Boots", new GMaterial(EnumMaterial.LEATHER_BOOTS, new GColor("395E2D")), "gadgetsmenu.suits.frog.boots", 7, Rarity.COMMON, null, EnumArmorType.BOOTS);
    public static final SuitEquipmentType NINJA_HELMET = new SuitEquipmentType("Ninja", "Ninja Helmet", "&6Ninja Suit Helmet", new GMaterial("head:e96616bb48ac61a153a9f5c35979f3523c24c366c621d6bacaed10f822b68b"), "gadgetsmenu.suits.ninja.helmet", 80, Rarity.LEGENDARY, null, EnumArmorType.HELMET);
    public static final SuitEquipmentType NINJA_CHESTPLATE = new SuitEquipmentType("Ninja", "Ninja Chestplate", "&5Ninja Suit Chestplate", new GMaterial(EnumMaterial.LEATHER_CHESTPLATE, new GColor("#000000")), "gadgetsmenu.suits.ninja.chestplate", 35, Rarity.EPIC, null, EnumArmorType.CHESTPLATE);
    public static final SuitEquipmentType NINJA_LEGGINGS = new SuitEquipmentType("Ninja", "Ninja Leggings", "&9Ninja Suit Leggings", new GMaterial(EnumMaterial.LEATHER_LEGGINGS, new GColor("#000000")), "gadgetsmenu.suits.ninja.leggings", 20, Rarity.RARE, null, EnumArmorType.LEGGINGS);
    public static final SuitEquipmentType NINJA_BOOTS = new SuitEquipmentType("Ninja", "Ninja Boots", "&aNinja Suit Boots", new GMaterial(EnumMaterial.LEATHER_BOOTS, new GColor("#000000")), "gadgetsmenu.suits.ninja.boots", 10, Rarity.COMMON, null, EnumArmorType.BOOTS);
    public static final SuitEquipmentType SPEEDSTER_HELMET = new SuitEquipmentType("Speedster", "Speedster Helmet", "&6Speedster Suit Helmet", new GMaterial("head:5138ccdee2eb7cf60d5489d388f210629b2e787bb530e65bd1a73126d01067"), "gadgetsmenu.suits.speedster.helmet", 80, Rarity.LEGENDARY, null, EnumArmorType.HELMET);
    public static final SuitEquipmentType SPEEDSTER_CHESTPLATE = new SuitEquipmentType("Speedster", "Speedster Chestplate", "&5Speedster Suit Chestplate", new GMaterial(EnumMaterial.LEATHER_CHESTPLATE, new GColor("#511E1E")), "gadgetsmenu.suits.speedster.chestplate", 25, Rarity.EPIC, null, EnumArmorType.CHESTPLATE);
    public static final SuitEquipmentType SPEEDSTER_LEGGINGS = new SuitEquipmentType("Speedster", "Speedster Leggings", "&9Speedster Suit Leggings", new GMaterial(EnumMaterial.LEATHER_LEGGINGS, new GColor("#511E1E")), "gadgetsmenu.suits.speedster.leggings", 13, Rarity.RARE, null, EnumArmorType.LEGGINGS);
    public static final SuitEquipmentType SPEEDSTER_BOOTS = new SuitEquipmentType("Speedster", "Speedster Boots", "&aSpeedster Suit Boots", new GMaterial(EnumMaterial.GOLDEN_BOOTS), "gadgetsmenu.suits.speedster.boots", 5, Rarity.COMMON, null, EnumArmorType.BOOTS);
    public static final SuitEquipmentType GHOSTLY_HELMET = new SuitEquipmentType("Ghostly", "Ghostly Helmet", "&6Ghostly Skeleton Suit Helmet", new GMaterial(EnumMaterial.SKELETON_SKULL), "gadgetsmenu.suits.ghostly.helmet", 80, Rarity.LEGENDARY, null, EnumArmorType.HELMET);
    public static final SuitEquipmentType GHOSTLY_CHESTPLATE = new SuitEquipmentType("Ghostly", "Ghostly Chestplate", "&5Ghostly Skeleton Suit Chestplate", new GMaterial(EnumMaterial.LEATHER_CHESTPLATE, new GColor("#d4C2C2")), "gadgetsmenu.suits.ghostly.chestplate", 25, Rarity.EPIC, null, EnumArmorType.CHESTPLATE);
    public static final SuitEquipmentType GHOSTLY_LEGGINGS = new SuitEquipmentType("Ghostly", "Ghostly Leggings", "&9Ghostly Skeleton Suit Leggings", new GMaterial(EnumMaterial.LEATHER_LEGGINGS, new GColor("#8C8383")), "gadgetsmenu.suits.ghostly.leggings", 13, Rarity.RARE, null, EnumArmorType.LEGGINGS);
    public static final SuitEquipmentType GHOSTLY_BOOTS = new SuitEquipmentType("Ghostly", "Ghostly Boots", "&aGhostly Skeleton Suit Boots", new GMaterial(EnumMaterial.LEATHER_BOOTS, new GColor("#8C8383")), "gadgetsmenu.suits.ghostly.boots", 5, Rarity.COMMON, null, EnumArmorType.BOOTS);
    public static final SuitEquipmentType DISCO_HELMET = new SuitEquipmentType("Disco", "Disco Helmet", "&6Disco Suit Helmet", new GMaterial(EnumMaterial.LEATHER_HELMET, Color.RED), "gadgetsmenu.suits.disco.helmet", 80, Rarity.LEGENDARY, null, EnumArmorType.HELMET);
    public static final SuitEquipmentType DISCO_CHESTPLATE = new SuitEquipmentType("Disco", "Disco Chestplate", "&5Disco Suit Chestplate", new GMaterial(EnumMaterial.LEATHER_CHESTPLATE, new GColor("#FFFF00")), "gadgetsmenu.suits.disco.chestplate", 25, Rarity.EPIC, null, EnumArmorType.CHESTPLATE);
    public static final SuitEquipmentType DISCO_LEGGINGS = new SuitEquipmentType("Disco", "Disco Leggings", "&9Disco Suit Leggings", new GMaterial(EnumMaterial.LEATHER_LEGGINGS, new GColor("#0000FF")), "gadgetsmenu.suits.disco.leggings", 13, Rarity.RARE, null, EnumArmorType.LEGGINGS);
    public static final SuitEquipmentType DISCO_BOOTS = new SuitEquipmentType("Disco", "Disco Boots", "&aDisco Suit Boots", new GMaterial(EnumMaterial.LEATHER_BOOTS, new GColor("#008000")), "gadgetsmenu.suits.disco.boots", 5, Rarity.COMMON, null, EnumArmorType.BOOTS);
    public static final SuitEquipmentType MERMAID_HELMET = new SuitEquipmentType("Mermaid", "Mermaid Helmet", "&6Mermaid Suit Helmet", new GMaterial("head:aa36d682f9152a98e53cbf3d583b59df8f024e184531c97c2ea25816d1288f"), "gadgetsmenu.suits.mermaid.helmet", 70, Rarity.LEGENDARY, null, EnumArmorType.HELMET);
    public static final SuitEquipmentType MERMAID_CHESTPLATE = new SuitEquipmentType("Mermaid", "Mermaid Chestplate", "&5Mermaid Suit Chestplate", new GMaterial(EnumMaterial.LEATHER_CHESTPLATE, new GColor("#DE9EDE")), "gadgetsmenu.suits.mermaid.chestplate", 30, Rarity.EPIC, null, EnumArmorType.CHESTPLATE);
    public static final SuitEquipmentType MERMAID_LEGGINGS = new SuitEquipmentType("Mermaid", "Mermaid Leggings", "&9Mermaid Suit Leggings", new GMaterial(EnumMaterial.LEATHER_LEGGINGS, new GColor("#2EA195")), "gadgetsmenu.suits.mermaid.leggings", 16, Rarity.RARE, null, EnumArmorType.LEGGINGS);
    public static final SuitEquipmentType MERMAID_BOOTS = new SuitEquipmentType("Mermaid", "Mermaid Boots", "&aMermaid Suit Boots", new GMaterial(EnumMaterial.LEATHER_BOOTS, new GColor("#2EA195")), "gadgetsmenu.suits.mermaid.boots", 6, Rarity.COMMON, null, EnumArmorType.BOOTS);
    public static final SuitEquipmentType SPOODERMAN_HELMET = new SuitEquipmentType("Spooderman", "Spooderman Helmet", "&6Spooderman Suit Helmet", new GMaterial("head:9f2f7ebd9e263c939f54f939c9e2bcb18d4431f5577c389d6cbcf1371b11d"), "gadgetsmenu.suits.spooderman.helmet", 75, Rarity.LEGENDARY, null, EnumArmorType.HELMET);
    public static final SuitEquipmentType SPOODERMAN_CHESTPLATE = new SuitEquipmentType("Spooderman", "Spooderman Chestplate", "&5Spooderman Suit Chestplate", new GMaterial(EnumMaterial.LEATHER_CHESTPLATE, new GColor("#B4281F")), "gadgetsmenu.suits.spooderman.chestplate", 33, Rarity.EPIC, null, EnumArmorType.CHESTPLATE);
    public static final SuitEquipmentType SPOODERMAN_LEGGINGS = new SuitEquipmentType("Spooderman", "Spooderman Leggings", "&9Spooderman Suit Leggings", new GMaterial(EnumMaterial.LEATHER_LEGGINGS, new GColor("#057BBF")), "gadgetsmenu.suits.spooderman.leggings", 17, Rarity.RARE, null, EnumArmorType.LEGGINGS);
    public static final SuitEquipmentType SPOODERMAN_BOOTS = new SuitEquipmentType("Spooderman", "Spooderman Boots", "&aSpooderman Suit Boots", new GMaterial(EnumMaterial.LEATHER_BOOTS, new GColor("#B4281F")), "gadgetsmenu.suits.spooderman.boots", 8, Rarity.COMMON, null, EnumArmorType.BOOTS);
    public static final SuitEquipmentType WARRIOR_HELMET = new SuitEquipmentType("Warrior", "Warrior Helmet", "&6Warrior Suit Helmet", new GMaterial("head:38f56b7f7ac16046a9816e57c2c3296420ccddb7cc51b1c0de8075a816b747d9"), "gadgetsmenu.suits.warrior.helmet", 75, Rarity.LEGENDARY, null, EnumArmorType.HELMET);
    public static final SuitEquipmentType WARRIOR_CHESTPLATE = new SuitEquipmentType("Warrior", "Warrior Chestplate", "&5Warrior Suit Chestplate", new GMaterial(EnumMaterial.LEATHER_CHESTPLATE, new GColor("#993333")), "gadgetsmenu.suits.warrior.chestplate", 30, Rarity.EPIC, null, EnumArmorType.CHESTPLATE);
    public static final SuitEquipmentType WARRIOR_LEGGINGS = new SuitEquipmentType("Warrior", "Warrior Leggings", "&9Warrior Suit Leggings", new GMaterial(EnumMaterial.LEATHER_LEGGINGS, new GColor("#993333")), "gadgetsmenu.suits.warrior.leggings", 16, Rarity.RARE, null, EnumArmorType.LEGGINGS);
    public static final SuitEquipmentType WARRIOR_BOOTS = new SuitEquipmentType("Warrior", "Warrior Boots", "&aWarrior Suit Boots", new GMaterial(EnumMaterial.LEATHER_BOOTS, new GColor("#993333")), "gadgetsmenu.suits.warrior.boots", 6, Rarity.COMMON, null, EnumArmorType.BOOTS);
    public static final SuitEquipmentType NECROMANCER_HELMET = new SuitEquipmentType("Necromancer", "Necromancer Helmet", "&6Necromancer Suit Helmet", new GMaterial("head:9ddbd0bb9622ce124dabb6ba3baa9a9ea71430f870fec15b3ea81f1961a412b2"), "gadgetsmenu.suits.necromancer.helmet", 80, Rarity.LEGENDARY, null, EnumArmorType.HELMET);
    public static final SuitEquipmentType NECROMANCER_CHESTPLATE = new SuitEquipmentType("Necromancer", "Necromancer Chestplate", "&5Necromancer Suit Chestplate", new GMaterial(EnumMaterial.LEATHER_CHESTPLATE, new GColor("#993333")), "gadgetsmenu.suits.necromancer.chestplate", 35, Rarity.EPIC, null, EnumArmorType.CHESTPLATE);
    public static final SuitEquipmentType NECROMANCER_LEGGINGS = new SuitEquipmentType("Necromancer", "Necromancer Leggings", "&9Necromancer Suit Leggings", new GMaterial(EnumMaterial.LEATHER_LEGGINGS, new GColor("#000000")), "gadgetsmenu.suits.necromancer.leggings", 20, Rarity.RARE, null, EnumArmorType.LEGGINGS);
    public static final SuitEquipmentType NECROMANCER_BOOTS = new SuitEquipmentType("Necromancer", "Necromancer Boots", "&aNecromancer Suit Boots", new GMaterial(EnumMaterial.LEATHER_BOOTS, new GColor("#000000")), "gadgetsmenu.suits.necromancer.boots", 10, Rarity.COMMON, null, EnumArmorType.BOOTS);
    public static final SuitEquipmentType THOR_HELMET = new SuitEquipmentType("Thor", "Thor Helmet", "&6Thor Suit Helmet", new GMaterial("head:2a9f83329a2e475a75335b3949aa4d054f9de413bfb28aa60de2e5259ecaad1"), "gadgetsmenu.suits.thor.helmet", 70, Rarity.LEGENDARY, null, EnumArmorType.HELMET);
    public static final SuitEquipmentType THOR_CHESTPLATE = new SuitEquipmentType("Thor", "Thor Chestplate", "&5Thor Suit Chestplate", new GMaterial(EnumMaterial.LEATHER_CHESTPLATE, new GColor("#993333")), "gadgetsmenu.suits.thor.chestplate", 25, Rarity.EPIC, null, EnumArmorType.CHESTPLATE);
    public static final SuitEquipmentType THOR_LEGGINGS = new SuitEquipmentType("Thor", "Thor Leggings", "&9Thor Suit Leggings", new GMaterial(EnumMaterial.LEATHER_LEGGINGS, new GColor("#000000")), "gadgetsmenu.suits.thor.leggings", 13, Rarity.RARE, null, EnumArmorType.LEGGINGS);
    public static final SuitEquipmentType THOR_BOOTS = new SuitEquipmentType("Thor", "Thor Boots", "&aThor Suit Boots", new GMaterial(EnumMaterial.LEATHER_BOOTS, new GColor("#000000")), "gadgetsmenu.suits.thor.boots", 5, Rarity.COMMON, null, EnumArmorType.BOOTS);
    public static final SuitEquipmentType BAKER_HELMET = new SuitEquipmentType("Baker", "Baker Helmet", "&6Baker Suit Helmet", new GMaterial("head:b8dea622fb0fbbd2639384c1604f5f1a3c111aa993447319fbac494bff4477"), "gadgetsmenu.suits.baker.helmet", 70, Rarity.LEGENDARY, null, EnumArmorType.HELMET);
    public static final SuitEquipmentType BAKER_CHESTPLATE = new SuitEquipmentType("Baker", "Baker Chestplate", "&5Baker Suit Chestplate", new GMaterial(EnumMaterial.LEATHER_CHESTPLATE, new GColor("#FFFFFF")), "gadgetsmenu.suits.baker.chestplate", 25, Rarity.EPIC, null, EnumArmorType.CHESTPLATE);
    public static final SuitEquipmentType BAKER_LEGGINGS = new SuitEquipmentType("Baker", "Baker Leggings", "&9Baker Suit Leggings", new GMaterial(EnumMaterial.LEATHER_LEGGINGS, new GColor("#1264CF")), "gadgetsmenu.suits.baker.leggings", 13, Rarity.RARE, null, EnumArmorType.LEGGINGS);
    public static final SuitEquipmentType BAKER_BOOTS = new SuitEquipmentType("Baker", "Baker Boots", "&aBaker Suit Boots", new GMaterial(EnumMaterial.LEATHER_BOOTS, new GColor("#000000")), "gadgetsmenu.suits.baker.boots", 5, Rarity.COMMON, null, EnumArmorType.BOOTS);
    public static final SuitEquipmentType BUMBLEBEE_HELMET = new SuitEquipmentType("Bumblebee", "Bumblebee Helmet", "&6Bumblebee Suit Helmet", new GMaterial("head:bf92d3f385cc16c77675a46de3e833ac17c74ada3e1946ef7021ecdbf9f1ba"), "gadgetsmenu.suits.bumblebee.helmet", 70, Rarity.LEGENDARY, null, EnumArmorType.HELMET);
    public static final SuitEquipmentType BUMBLEBEE_CHESTPLATE = new SuitEquipmentType("Bumblebee", "Bumblebee Chestplate", "&5Bumblebee Suit Chestplate", new GMaterial(EnumMaterial.LEATHER_CHESTPLATE, new GColor("#EEEC37")), "gadgetsmenu.suits.bumblebee.chestplate", 25, Rarity.EPIC, null, EnumArmorType.CHESTPLATE);
    public static final SuitEquipmentType BUMBLEBEE_LEGGINGS = new SuitEquipmentType("Bumblebee", "Bumblebee Leggings", "&9Bumblebee Suit Leggings", new GMaterial(EnumMaterial.LEATHER_LEGGINGS, new GColor("#000000")), "gadgetsmenu.suits.bumblebee.leggings", 13, Rarity.RARE, null, EnumArmorType.LEGGINGS);
    public static final SuitEquipmentType BUMBLEBEE_BOOTS = new SuitEquipmentType("Bumblebee", "Bumblebee Boots", "&aBumblebee Suit Boots", new GMaterial(EnumMaterial.LEATHER_BOOTS, new GColor("#EEEC37")), "gadgetsmenu.suits.bumblebee.boots", 5, Rarity.COMMON, null, EnumArmorType.BOOTS);
    public static final SuitEquipmentType FIREFIGHTER_HELMET = new SuitEquipmentType("Firefighter", "Firefighter Helmet", "&6Firefighter Suit Helmet", new GMaterial("head:7e9b8d13ae2b8e24b8a06fc982b2628a8131d1b16d6deb9cf31fb633f8ca2e"), "gadgetsmenu.suits.firefighter.helmet", 80, Rarity.LEGENDARY, null, EnumArmorType.HELMET);
    public static final SuitEquipmentType FIREFIGHTER_CHESTPLATE = new SuitEquipmentType("Firefighter", "Firefighter Chestplate", "&5Firefighter Suit Chestplate", new GMaterial(EnumMaterial.LEATHER_CHESTPLATE, new GColor("#363636")), "gadgetsmenu.suits.firefighter.chestplate", 34, Rarity.EPIC, null, EnumArmorType.CHESTPLATE);
    public static final SuitEquipmentType FIREFIGHTER_LEGGINGS = new SuitEquipmentType("Firefighter", "Firefighter Leggings", "&9Firefighter Suit Leggings", new GMaterial(EnumMaterial.LEATHER_LEGGINGS, new GColor("#4C4C4C")), "gadgetsmenu.suits.firefighter.leggings", 19, Rarity.RARE, null, EnumArmorType.LEGGINGS);
    public static final SuitEquipmentType FIREFIGHTER_BOOTS = new SuitEquipmentType("Firefighter", "Firefighter Boots", "&aFirefighter Suit Boots", new GMaterial(EnumMaterial.LEATHER_BOOTS, new GColor("#000000")), "gadgetsmenu.suits.firefighter.boots", 9, Rarity.COMMON, null, EnumArmorType.BOOTS);
    public static final SuitEquipmentType PLUMBER_HELMET = new SuitEquipmentType("Plumber", "Plumber Helmet", "&6Plumber Suit Helmet", new GMaterial("head:6f7eb75e5542cc4937aaad5bb8657393eaf0265006eac1dc96691f32e16437"), "gadgetsmenu.suits.plumber.helmet", 73, Rarity.LEGENDARY, null, EnumArmorType.HELMET);
    public static final SuitEquipmentType PLUMBER_CHESTPLATE = new SuitEquipmentType("Plumber", "Plumber Chestplate", "&5Plumber Suit Chestplate", new GMaterial(EnumMaterial.LEATHER_CHESTPLATE, new GColor("#CE1E27")), "gadgetsmenu.suits.plumber.chestplate", 32, Rarity.EPIC, null, EnumArmorType.CHESTPLATE);
    public static final SuitEquipmentType PLUMBER_LEGGINGS = new SuitEquipmentType("Plumber", "Plumber Leggings", "&9Plumber Suit Leggings", new GMaterial(EnumMaterial.LEATHER_LEGGINGS, new GColor("#1264CF")), "gadgetsmenu.suits.plumber.leggings", 18, Rarity.RARE, null, EnumArmorType.LEGGINGS);
    public static final SuitEquipmentType PLUMBER_BOOTS = new SuitEquipmentType("Plumber", "Plumber Boots", "&aPlumber Suit Boots", new GMaterial(EnumMaterial.LEATHER_BOOTS, new GColor("000000")), "gadgetsmenu.suits.plumber.boots", 7, Rarity.COMMON, null, EnumArmorType.BOOTS);
    public static final SuitEquipmentType ICE_WALKER_HELMET = new SuitEquipmentType("Ice Walker", "Ice Walker Helmet", "&6Ice Walker Suit Helmet", new GMaterial("head:371c7c94da4f86a8fe6ea3a5b2f7dad24731ac420ef47ca4c1c766dea60accc"), "gadgetsmenu.suits.icewalker.helmet", 70, Rarity.LEGENDARY, null, EnumArmorType.HELMET);
    public static final SuitEquipmentType ICE_WALKER_CHESTPLATE = new SuitEquipmentType("Ice Walker", "Ice Walker Chestplate", "&5Ice Walker Suit Chestplate", new GMaterial(EnumMaterial.LEATHER_CHESTPLATE, new GColor("#EBEBEB")), "gadgetsmenu.suits.icewalker.chestplate", 25, Rarity.EPIC, null, EnumArmorType.CHESTPLATE);
    public static final SuitEquipmentType ICE_WALKER_LEGGINGS = new SuitEquipmentType("Ice Walker", "Ice Walker Leggings", "&9Ice Walker Suit Leggings", new GMaterial(EnumMaterial.LEATHER_LEGGINGS, new GColor("#EBEBEB")), "gadgetsmenu.suits.icewalker.leggings", 13, Rarity.RARE, null, EnumArmorType.LEGGINGS);
    public static final SuitEquipmentType ICE_WALKER_BOOTS = new SuitEquipmentType("Ice Walker", "Ice Walker Boots", "&aIce Walker Suit Boots", new GMaterial(EnumMaterial.LEATHER_BOOTS, new GColor("C2C2C2")), "gadgetsmenu.suits.icewalker.boots", 5, Rarity.COMMON, null, EnumArmorType.BOOTS);
    public static final SuitEquipmentType VAMPIRE_HELMET = new SuitEquipmentType("Vampire", "Vampire Helmet", "&6Vampire Suit Helmet", new GMaterial("head:8d44756e0b4ece8d746296a3d5e297e1415f4ba17647ffe228385383d161a9"), "gadgetsmenu.suits.vampire.helmet", 74, Rarity.LEGENDARY, null, EnumArmorType.HELMET);
    public static final SuitEquipmentType VAMPIRE_CHESTPLATE = new SuitEquipmentType("Vampire", "Vampire Chestplate", "&5Vampire Suit Chestplate", new GMaterial(EnumMaterial.LEATHER_CHESTPLATE, new GColor("#720A0A")), "gadgetsmenu.suits.vampire.chestplate", 34, Rarity.EPIC, null, EnumArmorType.CHESTPLATE);
    public static final SuitEquipmentType VAMPIRE_LEGGINGS = new SuitEquipmentType("Vampire", "Vampire Leggings", "&9Vampire Suit Leggings", new GMaterial(EnumMaterial.LEATHER_LEGGINGS, new GColor("#000000")), "gadgetsmenu.suits.vampire.leggings", 18, Rarity.RARE, null, EnumArmorType.LEGGINGS);
    public static final SuitEquipmentType VAMPIRE_BOOTS = new SuitEquipmentType("Vampire", "Vampire Boots", "&aVampire Suit Boots", new GMaterial(EnumMaterial.LEATHER_BOOTS, new GColor("000000")), "gadgetsmenu.suits.vampire.boots", 7, Rarity.COMMON, null, EnumArmorType.BOOTS);
    private String group;
    private String name;
    private String displayName;
    private GMaterial material;
    private String permission;
    private int mysteryDust;
    private Rarity rarity;
    private List<String> lore;
    private EnumArmorType armorType;
    private boolean canBeFound;
    private boolean purchasable;
    private ItemStack itemStack;

    private SuitEquipmentType(String group, String name, String displayName, GMaterial material, String permission, int mysteryDust, Rarity rarity, List<String> lore, EnumArmorType armorType) {
        this.group = group;
        this.name = name;
        if (FileManager.getSuitsFile().get("Suits." + this.group + ".Equipments." + this.name + ".Name") == null) {
            this.displayName = displayName;
            FileManager.getSuitsFile().set("Suits." + this.group + ".Equipments." + this.name + ".Name", this.displayName);
        } else {
            this.displayName = FileManager.getSuitsFile().getString("Suits." + this.group + ".Equipments." + this.name + ".Name");
        }
        this.material = material;
        this.permission = permission;
        if (FileManager.getSuitsFile().get("Suits." + this.group + ".Equipments." + this.name + ".Mystery Dust") == null) {
            this.mysteryDust = mysteryDust;
            FileManager.getSuitsFile().set("Suits." + this.group + ".Equipments." + this.name + ".Mystery Dust", this.mysteryDust);
        } else {
            this.mysteryDust = FileManager.getSuitsFile().getInt("Suits." + this.group + ".Equipments." + this.name + ".Mystery Dust");
        }
        if (FileManager.getSuitsFile().get("Suits." + this.group + ".Equipments." + this.name + ".Rarity") == null) {
            this.rarity = rarity;
            FileManager.getSuitsFile().set("Suits." + this.group + ".Equipments." + this.name + ".Rarity", this.rarity.getName());
        } else {
            this.rarity = Rarity.getName(FileManager.getSuitsFile().getString("Suits." + this.group + ".Equipments." + this.name + ".Rarity"));
        }
        if (FileManager.getSuitsFile().get("Suits." + this.group + ".Equipments." + this.name + ".CanBeFound") == null) {
            this.canBeFound = true;
            FileManager.getSuitsFile().set("Suits." + this.group + ".Equipments." + this.name + ".CanBeFound", true);
        } else {
            this.canBeFound = FileManager.getSuitsFile().getBoolean("Suits." + this.group + ".Equipments." + this.name + ".CanBeFound");
        }
        if (FileManager.getSuitsFile().get("Suits." + this.group + ".Equipments." + this.name + ".Purchasable") == null) {
            this.purchasable = true;
            FileManager.getSuitsFile().set("Suits." + this.group + ".Equipments." + this.name + ".Purchasable", true);
        } else {
            this.purchasable = FileManager.getSuitsFile().getBoolean("Suits." + this.group + ".Equipments." + this.name + ".Purchasable");
        }
        if (FileManager.getSuitsFile().get("Suits." + this.group + ".Equipments." + this.name + ".Lore") == null) {
            this.lore = lore;
            if (lore == null) {
                FileManager.getSuitsFile().set("Suits." + this.group + ".Equipments." + this.name + ".Lore", "");
            } else {
                FileManager.getSuitsFile().set("Suits." + this.group + ".Equipments." + this.name + ".Lore", this.lore);
            }
        } else {
            this.lore = FileManager.getSuitsFile().getStringList("Suits." + this.group + ".Equipments." + this.name + ".Lore");
        }
        this.armorType = armorType;
        this.itemStack = ItemUtils.item(this.displayName, this.material);
        this.itemStack = GadgetsMenu.getNMSManager().setNBTTag(this.itemStack, "Cosmetics", "true");
        this.itemStack = GadgetsMenu.getNMSManager().setNBTTag(this.itemStack, "Category", "Suit");
        if (!VALUES.contains(this)) {
            VALUES.add(this);
        }
        if (!GROUPS.containsKey((Object)PetType.EnumPetType.valueOfByName(this.group))) {
            GROUPS.put(EnumSuitType.valueOfByName(this.group), new ArrayList());
        }
    }

    public String getGroup() {
        return this.group;
    }

    public SuitType getType() {
        return SuitType.valueOf(this.group);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return ChatUtil.format(this.displayName);
    }

    public String getDisplayNameStripColor() {
        return ChatUtil.stripColor(this.displayName);
    }

    public GMaterial getMaterial() {
        return this.material;
    }

    public String getPermission() {
        return this.permission;
    }

    public int getMysteryDust() {
        return this.mysteryDust;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public EnumArmorType getArmorType() {
        return this.armorType;
    }

    public boolean canBeFound() {
        return this.canBeFound;
    }

    public boolean isPurchasable() {
        return this.purchasable;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public static List<SuitEquipmentType> values() {
        return VALUES;
    }

    public static Set<EnumSuitType> groups() {
        return GROUPS.keySet();
    }

    public static void checkEnabled() {
        for (SuitEquipmentType type : SuitEquipmentType.values()) {
            EnumSuitType enumSuitType = EnumSuitType.valueOfByName(type.getGroup());
            if (!GROUPS.containsKey((Object)enumSuitType) || GROUPS.get((Object)enumSuitType).contains(type)) continue;
            GROUPS.get((Object)enumSuitType).add(type);
        }
    }

    public static List<SuitEquipmentType> getGroup(String name) {
        if (GROUPS.containsKey((Object)EnumSuitType.valueOfByName(name))) {
            return GROUPS.get((Object)EnumSuitType.valueOfByName(name));
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public static SuitEquipmentType valueOf(String name) throws NullPointerException {
        for (SuitEquipmentType type : SuitEquipmentType.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    public static SuitEquipmentType valueOfDisplayName(String displayName) throws NullPointerException {
        for (SuitEquipmentType type : SuitEquipmentType.values()) {
            if (!type.getDisplayName().equalsIgnoreCase(displayName)) continue;
            return type;
        }
        return null;
    }

    public static enum EnumSuitType {
        FROG_SUIT("Frog"),
        NINJA_SUIT("Ninja"),
        SPEEDSTER_SUIT("Speedster"),
        GHOSTLY_SUIT("Ghostly"),
        DISCO_SUIT("Disco"),
        MERMAID_SUIT("Mermaid"),
        SPOODERMAN_SUIT("Spooderman"),
        WARRIOR_SUIT("Warrior"),
        NECROMANCER_SUIT("Necromancer"),
        THOR_SUIT("Thor"),
        BAKER_SUIT("Baker"),
        BUMBLEBEE_SUIT("Bumblebee"),
        FIREFIGHTER_SUIT("Firefighter"),
        PLUMBER_SUIT("Plumber"),
        ICE_WALKER_SUIT("Ice Walker"),
        VAMPIRE_SUIT("Vampire");

        private String name;

        private EnumSuitType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static EnumSuitType valueOfByName(String name) throws NullPointerException {
            for (EnumSuitType suitType : EnumSuitType.values()) {
                if (!suitType.getName().equalsIgnoreCase(name)) continue;
                return suitType;
            }
            return null;
        }
    }
}

