/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.pets;

import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PetCategoryType {
    private static final List<PetCategoryType> ENABLED = new ArrayList<PetCategoryType>();
    private static final List<PetCategoryType> VALUES = new ArrayList<PetCategoryType>();
    public static final PetCategoryType COW = new PetCategoryType("Cow", "&eCow", new GMaterial(EnumMaterial.LEATHER), Arrays.asList("gadgetsmenu.pets.cow", "gadgetsmenu.pets.babycow", "gadgetsmenu.pets.mushroomcow", "gadgetsmenu.pets.babymushroomcow"), Arrays.asList("&7Click here to see all pets", "&7in the Cow category!"));
    public static final PetCategoryType CHICKEN = new PetCategoryType("Chicken", "&eChicken", new GMaterial(EnumMaterial.EGG), Arrays.asList("gadgetsmenu.pets.chicken", "gadgetsmenu.pets.babychicken"), Arrays.asList("&7Click here to see all pets", "&7in the Chicken category!"));
    public static final PetCategoryType WOLF = new PetCategoryType("Wolf", "&eWolf", new GMaterial(EnumMaterial.BONE), Arrays.asList("gadgetsmenu.pets.wolf", "gadgetsmenu.pets.babywolf"), Arrays.asList("&7Click here to see all pets", "&7in the Wolf category!"));
    public static final PetCategoryType PIG = new PetCategoryType("Pig", "&ePig", new GMaterial(EnumMaterial.PORKCHOP), Arrays.asList("gadgetsmenu.pets.pig", "gadgetsmenu.pets.babypig", "gadgetsmenu.pets.pigzombie", "gadgetsmenu.pets.babypigzombie"), Arrays.asList("&7Click here to see all pets", "&7in the Pig category!"));
    public static final PetCategoryType SILVERFISH = new PetCategoryType("Silverfish", "&eSilverfish", new GMaterial(EnumMaterial.SILVERFISH_SPAWN_EGG), Arrays.asList("gadgetsmenu.pets.silverfish"), Arrays.asList("&7Click here to see all pets", "&7in the Silverfish category!"));
    public static final PetCategoryType ENDERMITE = new PetCategoryType("Endermite", "&eEndermite", new GMaterial(EnumMaterial.ENDERMITE_SPAWN_EGG), Arrays.asList("gadgetsmenu.pets.endermite"), Arrays.asList("&7Click here to see all pets", "&7in the Endermite category!"));
    public static final PetCategoryType ZOMBIE = new PetCategoryType("Zombie", "&eZombie", new GMaterial(EnumMaterial.ZOMBIE_HEAD), Arrays.asList("gadgetsmenu.pets.zombie", "gadgetsmenu.pets.babyzombie", "gadgetsmenu.pets.husk", "gadgetsmenu.pets.babyhusk", "gadgetsmenu.pets.redlittlehelper", "gadgetsmenu.pets.greenlittlehelper"), Arrays.asList("&7Click here to see all pets", "&7in the Zombie category!"));
    public static final PetCategoryType CAT = new PetCategoryType("Cat", "&eCat", new GMaterial(EnumMaterial.COD), Arrays.asList("gadgetsmenu.pets.blackcat", "gadgetsmenu.pets.babyblackcat", "gadgetsmenu.pets.redcat", "gadgetsmenu.pets.babyredcat", "gadgetsmenu.pets.siamesecat", "gadgetsmenu.pets.babysiamesecat", "gadgetsmenu.pets.wildocelot", "gadgetsmenu.pets.babywildocelot"), Arrays.asList("&7Click here to see all pets", "&7in the Cat category!"));
    public static final PetCategoryType RABBIT = new PetCategoryType("Rabbit", "&eRabbit", new GMaterial(EnumMaterial.CARROT), Arrays.asList("gadgetsmenu.pets.blackrabbit", "gadgetsmenu.pets.babyblackrabbit", "gadgetsmenu.pets.blackandwhiterabbit", "gadgetsmenu.pets.babyblackandwhiterabbit", "gadgetsmenu.pets.brownrabbit", "gadgetsmenu.pets.babybrownrabbit", "gadgetsmenu.pets.goldrabbit", "gadgetsmenu.pets.babygoldrabbit", "gadgetsmenu.pets.saltandpepperrabbit", "gadgetsmenu.pets.babysaltandpepperrabbit", "gadgetsmenu.pets.whiterabbit", "gadgetsmenu.pets.babywhiterabbit"), Arrays.asList("&7Click here to see all pets", "&7in the Rabbit category!"));
    public static final PetCategoryType SHEEP = new PetCategoryType("Sheep", "&eSheep", new GMaterial(EnumMaterial.WHITE_WOOL), Arrays.asList("gadgetsmenu.pets.blacksheep", "gadgetsmenu.pets.babyblacksheep", "gadgetsmenu.pets.bluesheep", "gadgetsmenu.pets.babybluesheep", "gadgetsmenu.pets.brownsheep", "gadgetsmenu.pets.babybrownsheep", "gadgetsmenu.pets.cyansheep", "gadgetsmenu.pets.babycyansheep", "gadgetsmenu.pets.graysheep", "gadgetsmenu.pets.babygraysheep", "gadgetsmenu.pets.greensheep", "gadgetsmenu.pets.babygreensheep", "gadgetsmenu.pets.lightbluesheep", "gadgetsmenu.pets.babylightbluesheep", "gadgetsmenu.pets.limesheep", "gadgetsmenu.pets.babylimesheep", "gadgetsmenu.pets.magentasheep", "gadgetsmenu.pets.babymagentasheep", "gadgetsmenu.pets.orangesheep", "gadgetsmenu.pets.babyorangesheep", "gadgetsmenu.pets.pinksheep", "gadgetsmenu.pets.babypinksheep", "gadgetsmenu.pets.purplesheep", "gadgetsmenu.pets.babypurplesheep", "gadgetsmenu.pets.redsheep", "gadgetsmenu.pets.babyredsheep", "gadgetsmenu.pets.silversheep", "gadgetsmenu.pets.babysilversheep", "gadgetsmenu.pets.whitesheep", "gadgetsmenu.pets.babywhitesheep", "gadgetsmenu.pets.yellowsheep", "gadgetsmenu.pets.babyyellowsheep"), Arrays.asList("&7Click here to see all pets", "&7in the Sheep category!"));
    public static final PetCategoryType HORSE = new PetCategoryType("Horse", "&eHorse", new GMaterial(EnumMaterial.SADDLE), Arrays.asList("gadgetsmenu.pets.blackhorse", "gadgetsmenu.pets.babyblackhorse", "gadgetsmenu.pets.brownhorse", "gadgetsmenu.pets.babybrownhorse", "gadgetsmenu.pets.chestnuthorse", "gadgetsmenu.pets.babychestnuthorse", "gadgetsmenu.pets.creamyhorse", "gadgetsmenu.pets.babycreamyhorse", "gadgetsmenu.pets.darkbrownhorse", "gadgetsmenu.pets.babydarkbrownhorse", "gadgetsmenu.pets.grayhorse", "gadgetsmenu.pets.babygrayhorse", "gadgetsmenu.pets.whitehorse", "gadgetsmenu.pets.babywhitehorse", "gadgetsmenu.pets.donkey", "gadgetsmenu.pets.babydonkey", "gadgetsmenu.pets.mule", "gadgetsmenu.pets.babymule", "gadgetsmenu.pets.skeletonhorse", "gadgetsmenu.pets.babyskeletonhorse", "gadgetsmenu.pets.undeadhorse", "gadgetsmenu.pets.babyundeadhorse"), Arrays.asList("&7Click here to see all pets", "&7in the Horse category!"));
    public static final PetCategoryType VILLAGER = new PetCategoryType("Villager", "&eVillager", new GMaterial(EnumMaterial.EMERALD), Arrays.asList("gadgetsmenu.pets.blacksmithvillager", "gadgetsmenu.pets.babyblacksmithvillager", "gadgetsmenu.pets.butchervillager", "gadgetsmenu.pets.babybutchervillager", "gadgetsmenu.pets.farmervillager", "gadgetsmenu.pets.babyfarmervillager", "gadgetsmenu.pets.librarianvillager", "gadgetsmenu.pets.babylibrarianvillager", "gadgetsmenu.pets.priestvillager", "gadgetsmenu.pets.babypriestvillager", "gadgetsmenu.pets.zombievillager", "gadgetsmenu.pets.babyzombievillager", "gadgetsmenu.pets.witch", "gadgetsmenu.pets.evoker", "gadgetsmenu.pets.vindicator", "gadgetsmenu.pets.illusioner"), Arrays.asList("&7Click here to see all pets", "&7in the Villager category!"));
    public static final PetCategoryType SPIDER = new PetCategoryType("Spider", "&eSpider", new GMaterial(EnumMaterial.STRING), Arrays.asList("gadgetsmenu.pets.spider", "gadgetsmenu.pets.cavespider"), Arrays.asList("&7Click here to see all pets", "&7in the Spider category!"));
    public static final PetCategoryType SKELETON = new PetCategoryType("Skeleton", "&eSkeleton", new GMaterial(EnumMaterial.BOW), Arrays.asList("gadgetsmenu.pets.skeleton", "gadgetsmenu.pets.witherskeleton", "gadgetsmenu.pets.strayskeleton"), Arrays.asList("&7Click here to see all pets", "&7in the Skeleton category!"));
    public static final PetCategoryType BLAZE = new PetCategoryType("Blaze", "&eBlaze", new GMaterial(EnumMaterial.BLAZE_ROD), Arrays.asList("gadgetsmenu.pets.blaze"), Arrays.asList("&7Click here to see all pets", "&7in the Blaze category!"));
    public static final PetCategoryType CREEPER = new PetCategoryType("Creeper", "&eCreeper", new GMaterial(EnumMaterial.CREEPER_HEAD), Arrays.asList("gadgetsmenu.pets.creeper", "gadgetsmenu.pets.poweredcreeper"), Arrays.asList("&7Click here to see all pets", "&7in the Creeper category!"));
    public static final PetCategoryType GOLEM = new PetCategoryType("Golem", "&eGolem", new GMaterial("head:89091d79ea0f59ef7ef94d7bba6e5f17f2f7d4572c44f90f76c4819a714"), Arrays.asList("gadgetsmenu.pets.golem"), Arrays.asList("&7Click here to see all pets", "&7in the Golem category!"));
    public static final PetCategoryType SNOWMAN = new PetCategoryType("Snowman", "&eSnowman", new GMaterial(EnumMaterial.SNOWBALL), Arrays.asList("gadgetsmenu.pets.snowman"), Arrays.asList("&7Click here to see all pets", "&7in the Snowman category!"));
    public static final PetCategoryType POLAR_BEAR = new PetCategoryType("Polar Bear", "&ePolar Bear", new GMaterial("head:bab178f5cdd750f0e356860aa5539153eb2abec1e146ca57c65d25a5df8fdfe"), Arrays.asList("gadgetsmenu.pets.polarbear", "gadgetsmenu.pets.babypolarbear"), Arrays.asList("&7Click here to see all pets", "&7in the Polar Bear category!"));
    public static final PetCategoryType LLAMA = new PetCategoryType("Llama", "&eLlama", new GMaterial("head:83d9b5915912ffc2b85761d6adcb428a812f9b83ff634e331162ce46c99e9"), Arrays.asList("gadgetsmenu.pets.brownllama", "gadgetsmenu.pets.babybrownllama", "gadgetsmenu.pets.creamyllama", "gadgetsmenu.pets.babycreamyllama", "gadgetsmenu.pets.grayllama", "gadgetsmenu.pets.babygrayllama", "gadgetsmenu.pets.whitellama", "gadgetsmenu.pets.babywhitellama"), Arrays.asList("&7Click here to see all pets", "&7in the Llama category!"));
    public static final PetCategoryType PANDA = new PetCategoryType("Panda", "&ePanda", new GMaterial("head:dca096eea506301bea6d4b17ee1605625a6f5082c71f74a639cc940439f47166"), Arrays.asList("gadgetsmenu.pets.normalpanda", "gadgetsmenu.pets.babynormalpanda", "gadgetsmenu.pets.lazypanda", "gadgetsmenu.pets.babylazypanda", "gadgetsmenu.pets.worriedpanda", "gadgetsmenu.pets.babyworriedpanda", "gadgetsmenu.pets.playfulpanda", "gadgetsmenu.pets.babyplayfulpanda", "gadgetsmenu.pets.brownpanda", "gadgetsmenu.pets.babybrownpanda", "gadgetsmenu.pets.weakpanda", "gadgetsmenu.pets.babyweakpanda", "gadgetsmenu.pets.aggressivepanda", "gadgetsmenu.pets.babyaggressivepanda"), Arrays.asList("&7Click here to see all pets", "&7in the Panda category!"));
    private String name;
    private String displayName;
    private GMaterial material;
    private List<String> permission;
    private List<String> lore;
    private boolean isEnable;

    private PetCategoryType(String name, String displayName, GMaterial material, List<String> permission, List<String> lore) {
        this.name = name;
        if (FileManager.getPetsFile().get("Pets." + this.name + ".Name") == null) {
            this.displayName = displayName;
            FileManager.getPetsFile().set("Pets." + this.name + ".Name", this.displayName);
        } else {
            this.displayName = FileManager.getPetsFile().getString("Pets." + this.name + ".Name");
        }
        if (FileManager.getPetsFile().get("Pets." + this.name + ".Material") == null) {
            this.material = material;
            FileManager.getPetsFile().set("Pets." + this.name + ".Material", material.getCombinedMaterial());
        } else {
            GMaterial gMaterial;
            this.material = gMaterial = new GMaterial(FileManager.getPetsFile().getString("Pets." + this.name + ".Material"));
        }
        this.permission = permission;
        if (FileManager.getPetsFile().get("Pets." + this.name + ".Enabled") == null) {
            this.isEnable = true;
            FileManager.getPetsFile().set("Pets." + this.name + ".Enabled", true);
        } else {
            this.isEnable = FileManager.getPetsFile().getBoolean("Pets." + this.name + ".Enabled");
        }
        if (FileManager.getPetsFile().get("Pets." + this.name + ".Lore") == null) {
            this.lore = lore;
            if (lore == null) {
                FileManager.getPetsFile().set("Pets." + this.name + ".Lore", "");
            } else {
                FileManager.getPetsFile().set("Pets." + this.name + ".Lore", this.lore);
            }
        } else {
            this.lore = FileManager.getPetsFile().getStringList("Pets." + this.name + ".Lore");
        }
        if (!VALUES.contains(this)) {
            VALUES.add(this);
        }
        if (this.name == "Polar Bear" && !VersionManager.is1_10OrAbove() && VALUES.contains(this)) {
            VALUES.remove(this);
        }
        if (this.name == "Llama" && !VersionManager.is1_11OrAbove() && VALUES.contains(this)) {
            VALUES.remove(this);
        }
        if (this.name == "Panda" && !VersionManager.is1_14OrAbove() && VALUES.contains(this)) {
            VALUES.remove(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return ChatUtil.format(this.displayName);
    }

    public String getDisplayNameStripColor() {
        return ChatUtil.stripColor(this.displayName);
    }

    public GMaterial getMaterial() {
        return this.material;
    }

    public List<String> getPermission() {
        return this.permission;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public boolean isEnabled() {
        return this.isEnable;
    }

    public static List<PetCategoryType> enabled() {
        return ENABLED;
    }

    public static List<PetCategoryType> values() {
        return VALUES;
    }

    public static void checkEnabled() {
        for (PetCategoryType type : PetCategoryType.values()) {
            if (!type.isEnabled() || ENABLED.contains(type)) continue;
            ENABLED.add(type);
        }
    }

    public String toString() {
        return this.name;
    }

    public static PetCategoryType valueOf(String name) throws NullPointerException {
        for (PetCategoryType petType : PetCategoryType.values()) {
            if (!petType.getName().equalsIgnoreCase(name)) continue;
            return petType;
        }
        return null;
    }
}

