/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.particles;

import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Rarity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ParticleType {
    private static final List<ParticleType> ENABLED = new ArrayList<ParticleType>();
    private static final List<ParticleType> VALUES = new ArrayList<ParticleType>();
    public static final ParticleType WATER_SPLASH = new ParticleType("Water Splash", "&aWater Splash Particle", new GMaterial(EnumMaterial.NETHER_STAR), "gadgetsmenu.particles.watersplash", 15, Rarity.COMMON, Arrays.asList("&7Display a custom Water", "&7Splash particles around", "&7you in lobby."), ParticleEffect.WATER_SPLASH);
    public static final ParticleType DRIP_WATER = new ParticleType("Drip Water", "&9Drip Water Particle", new GMaterial(EnumMaterial.WATER_BUCKET), "gadgetsmenu.particles.dripwater", 25, Rarity.RARE, Arrays.asList("&7Display a custom Drip", "&7Water particles around", "&7you in lobby."), ParticleEffect.DRIP_WATER);
    public static final ParticleType DRIP_LAVA = new ParticleType("Drip Lava", "&9Drip Lava Particle", new GMaterial(EnumMaterial.LAVA_BUCKET), "gadgetsmenu.particles.driplava", 25, Rarity.RARE, Arrays.asList("&7Display a custom Drip", "&7Lava particles around", "&7you in lobby."), ParticleEffect.DRIP_LAVA);
    public static final ParticleType CRIT = new ParticleType("Crit", "&9Crit Particle", new GMaterial(EnumMaterial.STONE_SWORD), "gadgetsmenu.particles.crit", 22, Rarity.RARE, Arrays.asList("&7Display a custom Crit", "&7particles around you", "&7in lobby."), ParticleEffect.CRIT);
    public static final ParticleType CRIT_MAGIC = new ParticleType("Magic Crit", "&9Magic Crit Particle", new GMaterial(VersionManager.is1_8Version() ? EnumMaterial.POTION : EnumMaterial.SPLASH_POTION, 8204), "gadgetsmenu.particles.magiccrit", 20, Rarity.RARE, Arrays.asList("&7Display a custom Magic", "&7Crit particles around", "&7you in lobby."), ParticleEffect.CRIT_MAGIC);
    public static final ParticleType SPELL = new ParticleType("Spell", "&5Spell Particle", new GMaterial(EnumMaterial.ENDER_CHEST), "gadgetsmenu.particles.spell", 30, Rarity.EPIC, Arrays.asList("&7Display a custom Spell", "&7particles around you", "&7in lobby."), ParticleEffect.SPELL);
    public static final ParticleType SPELL_INSTANT = new ParticleType("Instant Spell", "&5Instant Spell Particle", new GMaterial(EnumMaterial.GHAST_TEAR), "gadgetsmenu.particles.instantspell", 32, Rarity.EPIC, Arrays.asList("&7Display a custom Instant", "&7Spell particles around", "&7you in lobby."), ParticleEffect.SPELL_INSTANT);
    public static final ParticleType SPELL_MOB = new ParticleType("Mob Spell", "&5Mob Spell Particle", new GMaterial(EnumMaterial.EXPERIENCE_BOTTLE), "gadgetsmenu.particles.mobspell", 35, Rarity.EPIC, Arrays.asList("&7Display a custom Mob", "&7Spell particles around", "&7you in lobby."), ParticleEffect.SPELL_MOB);
    public static final ParticleType SPELL_WITCH = new ParticleType("Witch Spell", "&6Witch Spell Particle", new GMaterial(EnumMaterial.POTION, 8260), "gadgetsmenu.particles.witchspell", 40, Rarity.LEGENDARY, Arrays.asList("&7Display a custom Witch", "&7Spell particles around", "&7you in lobby."), ParticleEffect.SPELL_WITCH);
    public static final ParticleType VILLAGER_ANGRY = new ParticleType("Angry Villager", "&5Angry Villager Particle", new GMaterial(EnumMaterial.FIRE_CHARGE), "gadgetsmenu.particles.angryvillager", 32, Rarity.EPIC, Arrays.asList("&7Display a custom Angry", "&7Villager particles around", "&7you in lobby."), ParticleEffect.VILLAGER_ANGRY);
    public static final ParticleType VILLAGER_HAPPY = new ParticleType("Happy Villager", "&5Happy Villager Particle", new GMaterial(EnumMaterial.EMERALD), "gadgetsmenu.particles.happyvillager", 35, Rarity.EPIC, Arrays.asList("&7Display a custom Happy", "&7Villager particles around", "&7you in lobby."), ParticleEffect.VILLAGER_HAPPY);
    public static final ParticleType TOWN_AURA = new ParticleType("Town Aura", "&aTown Aura Particle", new GMaterial(EnumMaterial.MYCELIUM), "gadgetsmenu.particles.townaura", 18, Rarity.COMMON, Arrays.asList("&7Display a custom Town", "&7Aura particles around", "&7you in lobby."), ParticleEffect.TOWN_AURA);
    public static final ParticleType NOTE = new ParticleType("Note", "&5Note Particle", new GMaterial(EnumMaterial.NOTE_BLOCK), "gadgetsmenu.particles.note", 35, Rarity.EPIC, Arrays.asList("&7Display a custom Note", "&7particles around you", "&7in lobby."), ParticleEffect.NOTE);
    public static final ParticleType PORTAL = new ParticleType("Portal", "&aPortal Particle", new GMaterial(EnumMaterial.ENDER_PEARL), "gadgetsmenu.particles.portal", 18, Rarity.COMMON, Arrays.asList("&7Display a custom Portal", "&7particles around you", "&7in lobby."), ParticleEffect.PORTAL);
    public static final ParticleType ENCHANTMENT_TABLE = new ParticleType("Enchantment Table", "&9Enchantment Table Particle", new GMaterial(EnumMaterial.ENCHANTING_TABLE), "gadgetsmenu.particles.enchantment", 28, Rarity.RARE, Arrays.asList("&7Display a custom Enchantment", "&7Table particles around", "&7you in lobby."), ParticleEffect.ENCHANTMENT_TABLE);
    public static final ParticleType FLAME = new ParticleType("Flame", "&6Flame Particle", new GMaterial(EnumMaterial.GOLD_NUGGET), "gadgetsmenu.particles.flame", 45, Rarity.LEGENDARY, Arrays.asList("&7Display a custom Flame", "&7particles around you", "&7in lobby."), ParticleEffect.FLAME);
    public static final ParticleType REDSTONE = new ParticleType("Redstone", "&6Redstone Particle", new GMaterial(EnumMaterial.REDSTONE), "gadgetsmenu.particles.redstone", 48, Rarity.LEGENDARY, Arrays.asList("&7Display a custom Redstone", "&7particles around you", "&7in lobby."), ParticleEffect.REDSTONE);
    public static final ParticleType HEART = new ParticleType("Heart", "&9Heart Particle", new GMaterial(EnumMaterial.POPPY), "gadgetsmenu.particles.heart", 28, Rarity.RARE, Arrays.asList("&7Display a custom Heart", "&7particles around you", "&7in lobby."), ParticleEffect.HEART);
    public static final ParticleType FIREWORKS_SPARK = new ParticleType("Fireworks Spark", "&6Fireworks Spark Particle", new GMaterial(EnumMaterial.FIREWORK_ROCKET), "gadgetsmenu.particles.fireworkspark", 52, Rarity.LEGENDARY, Arrays.asList("&7Display a custom Fireworks", "&7Spark particles around", "&7you in lobby."), ParticleEffect.FIREWORKS_SPARK);
    public static final ParticleType SMOKE_NORMAL = new ParticleType("Smoke", "&aSmoke Particle", new GMaterial(EnumMaterial.FIREWORK_STAR), "gadgetsmenu.particles.smoke", 18, Rarity.COMMON, Arrays.asList("&7Display a custom Smoke", "&7particles around you", "&7in lobby."), ParticleEffect.SMOKE_NORMAL);
    public static final ParticleType SLIME = new ParticleType("Slime", "&aSlime Particle", new GMaterial(EnumMaterial.SLIME_BALL), "gadgetsmenu.particles.slime", 22, Rarity.COMMON, Arrays.asList("&7Display a custom slime", "&7particles around you", "&7in lobby."), ParticleEffect.SLIME);
    private String name;
    private String displayName;
    private GMaterial material;
    private String permission;
    private int mysteryDust;
    private Rarity rarity;
    private List<String> lore;
    private ParticleEffect particleEffect;
    private boolean isEnable;
    private boolean canBeFound;
    private boolean purchasable;

    private ParticleType(String name, String displayName, GMaterial material, String permission, int mysteryDust, Rarity rarity, List<String> lore, ParticleEffect particleEffect) {
        this.name = name;
        if (FileManager.getParticlesFile().get("Particles." + this.name + ".Name") == null) {
            this.displayName = displayName;
            FileManager.getParticlesFile().set("Particles." + this.name + ".Name", this.displayName);
        } else {
            this.displayName = FileManager.getParticlesFile().getString("Particles." + this.name + ".Name");
        }
        if (FileManager.getParticlesFile().get("Particles." + this.name + ".Material") == null) {
            this.material = material;
            FileManager.getParticlesFile().set("Particles." + this.name + ".Material", this.material.getCombinedMaterial());
        } else {
            GMaterial gMaterial;
            this.material = gMaterial = new GMaterial(FileManager.getParticlesFile().getString("Particles." + this.name + ".Material"));
        }
        this.permission = permission;
        if (FileManager.getParticlesFile().get("Particles." + this.name + ".Mystery Dust") == null) {
            this.mysteryDust = mysteryDust;
            FileManager.getParticlesFile().set("Particles." + this.name + ".Mystery Dust", this.mysteryDust);
        } else {
            this.mysteryDust = FileManager.getParticlesFile().getInt("Particles." + this.name + ".Mystery Dust");
        }
        if (FileManager.getParticlesFile().get("Particles." + this.name + ".Rarity") == null) {
            this.rarity = rarity;
            FileManager.getParticlesFile().set("Particles." + this.name + ".Rarity", this.rarity.getName());
        } else {
            this.rarity = Rarity.getName(FileManager.getParticlesFile().getString("Particles." + this.name + ".Rarity"));
        }
        if (FileManager.getParticlesFile().get("Particles." + this.name + ".Enabled") == null) {
            this.isEnable = true;
            FileManager.getParticlesFile().set("Particles." + this.name + ".Enabled", true);
        } else {
            this.isEnable = FileManager.getParticlesFile().getBoolean("Particles." + this.name + ".Enabled");
        }
        if (FileManager.getParticlesFile().get("Particles." + this.name + ".CanBeFound") == null) {
            this.canBeFound = true;
            FileManager.getParticlesFile().set("Particles." + this.name + ".CanBeFound", true);
        } else {
            this.canBeFound = FileManager.getParticlesFile().getBoolean("Particles." + this.name + ".CanBeFound");
        }
        if (FileManager.getParticlesFile().get("Particles." + this.name + ".Purchasable") == null) {
            this.purchasable = true;
            FileManager.getParticlesFile().set("Particles." + this.name + ".Purchasable", true);
        } else {
            this.purchasable = FileManager.getParticlesFile().getBoolean("Particles." + this.name + ".Purchasable");
        }
        if (FileManager.getParticlesFile().get("Particles." + this.name + ".Lore") == null) {
            this.lore = lore;
            if (lore == null) {
                FileManager.getParticlesFile().set("Particles." + this.name + ".Lore", "");
            } else {
                FileManager.getParticlesFile().set("Particles." + this.name + ".Lore", this.lore);
            }
        } else {
            this.lore = FileManager.getParticlesFile().getStringList("Particles." + this.name + ".Lore");
        }
        this.particleEffect = particleEffect;
        if (!VALUES.contains(this)) {
            VALUES.add(this);
        }
    }

    public ParticleType(String name, String displayName, GMaterial material, String permission, int mysteryDust, Rarity rarity, List<String> lore, ParticleEffect particleEffect, boolean isEnable, boolean canBeFound, boolean purchasable) {
        this.name = name;
        this.displayName = displayName;
        this.material = material;
        this.permission = permission;
        this.mysteryDust = mysteryDust;
        this.rarity = rarity;
        this.lore = lore;
        this.particleEffect = particleEffect;
        this.isEnable = isEnable;
        this.canBeFound = canBeFound;
        this.purchasable = purchasable;
        if (!VALUES.contains(this)) {
            VALUES.add(this);
        }
        if (isEnable && !ENABLED.contains(this)) {
            ENABLED.add(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return ChatUtil.format(this.displayName);
    }

    public String getDisplayNameStripColor() {
        return ChatUtil.stripColor(this.displayName);
    }

    public GMaterial getMaterial() {
        return this.material;
    }

    public String getPermission() {
        return this.permission;
    }

    public int getMysteryDust() {
        return this.mysteryDust;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public ParticleEffect getParticleEffect() {
        return this.particleEffect;
    }

    public boolean isEnabled() {
        return this.isEnable;
    }

    public boolean canBeFound() {
        return this.canBeFound;
    }

    public boolean isPurchasable() {
        return this.purchasable;
    }

    public static List<ParticleType> enabled() {
        return ENABLED;
    }

    public static List<ParticleType> values() {
        return VALUES;
    }

    public static void checkEnabled() {
        for (ParticleType type : ParticleType.values()) {
            if (!type.isEnabled() || ENABLED.contains(type)) continue;
            ENABLED.add(type);
        }
    }

    public String toString() {
        return this.name;
    }

    public static ParticleType valueOf(String name) throws NullPointerException {
        for (ParticleType type : ParticleType.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }
}

