/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.particles;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.particles.ParticleType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class ParticleManager {
    public static void equipParticle(final Player player, final ParticleType type) {
        if (!type.isEnabled() || !Category.PARTICLES.isEnabled()) {
            return;
        }
        if (player == null) {
            return;
        }
        final PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        if (pManager.getSelectedParticle() != null) {
            pManager.unequipParticle();
        }
        BukkitRunnable runnable = new BukkitRunnable(){
            int step;
            boolean showToEveryone = GadgetsMenu.getGadgetsMenuData().showParticleEffectToEveryone();
            boolean hideParticleEffectForVanishedPlayer = GadgetsMenu.getGadgetsMenuData().hideParticleEffectForVanishedPlayer();
            boolean isVolatileParticle = ParticleManager.isVolatileParticleEffect(type.getParticleEffect());

            public void run() {
                if (pManager.getSelectedParticle() == null || pManager.getSelectedParticle() != type) {
                    this.cancel();
                    return;
                }
                if (this.step >= Integer.MAX_VALUE) {
                    this.step = 0;
                }
                double inc = 0.07853981633974483;
                double angle = (double)this.step * inc;
                Vector v = new Vector();
                v.setX(Math.cos(angle) * 0.43);
                v.setZ(Math.sin(angle) * 0.43);
                if (this.isVolatileParticle) {
                    if (this.showToEveryone) {
                        type.getParticleEffect().display(player.getLocation().add(v).add(0.0, 2.0, 0.0), this.hideParticleEffectForVanishedPlayer, player, 0.0f, 1);
                    } else {
                        type.getParticleEffect().display(player.getLocation().add(v).add(0.0, 2.0, 0.0), player, 0.0f, 1);
                    }
                } else if (this.showToEveryone) {
                    if (type.getParticleEffect() == ParticleEffect.SLIME) {
                        type.getParticleEffect().display(player.getLocation().add(v).add(0.0, 2.0, 0.0), this.hideParticleEffectForVanishedPlayer, player, 5.0f, 5);
                    } else {
                        type.getParticleEffect().display(player.getLocation().add(v).add(0.0, 2.0, 0.0), this.hideParticleEffectForVanishedPlayer, player, 5.0f, 1);
                    }
                } else if (type.getParticleEffect() == ParticleEffect.SLIME) {
                    type.getParticleEffect().display(player.getLocation().add(v).add(0.0, 2.0, 0.0), player, 5.0f, 5);
                } else {
                    type.getParticleEffect().display(player.getLocation().add(v).add(0.0, 2.0, 0.0), player, 5.0f, 1);
                }
                this.step += 4;
            }
        };
        runnable.runTaskTimerAsynchronously((Plugin)GadgetsMenu.getInstance(), 0L, 2L);
        pManager.setSelectedParticle(type);
    }

    public static void unequipParticle(Player player) {
        if (player == null) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        if (pManager.getSelectedParticle() != null) {
            if (pManager.getParticleRunnableTask() != null) {
                pManager.getParticleRunnableTask().cancel();
                pManager.setParticleRunnableTask(null);
            }
            pManager.setSelectedParticle(null);
        }
    }

    public static boolean isVolatileParticleEffect(ParticleEffect effect) {
        return effect == ParticleEffect.BLOCK_DUST || effect == ParticleEffect.CAMPFIRE_COSY_SMOKE || effect == ParticleEffect.CAMPFIRE_SIGNAL_SMOKE || effect == ParticleEffect.CLOUD || effect == ParticleEffect.CRIT || effect == ParticleEffect.CRIMSON_SPORE || effect == ParticleEffect.CRIT_MAGIC || effect == ParticleEffect.DAMAGE_INDICATOR || effect == ParticleEffect.DRAGON_BREATH || effect == ParticleEffect.ELECTRIC_SPARK || effect == ParticleEffect.ENCHANTMENT_TABLE || effect == ParticleEffect.END_ROD || effect == ParticleEffect.FIREWORKS_SPARK || effect == ParticleEffect.FLAME || effect == ParticleEffect.FLASH || effect == ParticleEffect.GLOW || effect == ParticleEffect.GLOW_SQUID_INK || effect == ParticleEffect.ITEM_CRACK || effect == ParticleEffect.PORTAL || effect == ParticleEffect.SCRAPE || effect == ParticleEffect.SCULK_CHARGE || effect == ParticleEffect.SCULK_CHARGE_POP || effect == ParticleEffect.SCULK_SOUL || effect == ParticleEffect.SMALL_FLAME || effect == ParticleEffect.SMOKE_NORMAL || effect == ParticleEffect.SMOKE_LARGE || effect == ParticleEffect.SNEEZE || effect == ParticleEffect.SNOWFLAKE || effect == ParticleEffect.SNOW_SHOVEL || effect == ParticleEffect.SOUL || effect == ParticleEffect.SOUL_FIRE_FLAME || effect == ParticleEffect.SPIT || effect == ParticleEffect.SPORE_BLOSSOM_AIR || effect == ParticleEffect.SWEEP_ATTACK || effect == ParticleEffect.TOTEM || effect == ParticleEffect.WARPED_SPORE || effect == ParticleEffect.WATER_WAKE || effect == ParticleEffect.WAX_OFF || effect == ParticleEffect.WAX_ON || effect == ParticleEffect.WHITE_ASH;
    }

    public static boolean checkRequirement(Player player, ParticleType type) {
        if (!type.isEnabled() || !Category.PARTICLES.isEnabled()) {
            return false;
        }
        return player != null && GadgetsMenu.getPlayerManager(player) != null;
    }
}

