/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphType;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.Morph;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.morphs.GDisguiseType;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MorphZombie
extends Morph {
    private boolean activated = false;
    private ArrayList<Entity> players = new ArrayList();

    public MorphZombie(UUID uuid) {
        super(uuid, MorphType.ZOMBIE);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.MORPH_SKILL_IS_ACTIVATED.getFormatMessage().replace("{MORPH}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.activated = true;
        SoundEffect.ENTITY_ZOMBIE_AMBIENT.playSound(this.getPlayer());
        if (this.getPlayer().getNearbyEntities(5.0, 3.0, 5.0).size() <= 0) {
            this.getPlayer().sendMessage(MessageType.NO_PLAYER_NEARBY.getFormatMessage());
            this.clearAll();
        } else {
            for (Entity entity : this.getPlayer().getNearbyEntities(5.0, 3.0, 5.0)) {
                if (entity instanceof Player && !entity.hasMetadata("NPC")) {
                    if (GadgetsMenu.getGDisguise().isDisguised((Player)entity)) continue;
                    GadgetsMenu.getGDisguise().disguise((Player)entity, GDisguiseType.ZOMBIE);
                    this.players.add(entity);
                    continue;
                }
                this.getPlayer().sendMessage(MessageType.NO_PLAYER_NEARBY.getFormatMessage());
                this.clearAll();
                return;
            }
            new BukkitRunnable(){

                public void run() {
                    SoundEffect.ENTITY_ZOMBIE_DEATH.playSound(MorphZombie.this.getPlayer().getLocation());
                    MorphZombie.this.clearAll();
                }
            }.runTaskLater((Plugin)GadgetsMenu.getInstance(), 80L);
        }
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Entity player : this.players) {
            if (!(player instanceof Player) || !GadgetsMenu.getGDisguise().isDisguised((Player)player)) continue;
            GadgetsMenu.getGDisguise().undisguise((Player)player);
        }
        this.players.clear();
        this.activated = false;
    }
}

