/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphType;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.Morph;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class MorphSnowman
extends Morph {
    private HashMap<Location, String> snowBlocks = new HashMap();

    public MorphSnowman(UUID uuid) {
        super(uuid, MorphType.SNOWMAN);
    }

    @Override
    public void onClick() {
        final Snowball snowball = (Snowball)this.getPlayer().launchProjectile(Snowball.class, this.getPlayer().getEyeLocation().getDirection().multiply(1.25).add(new Vector(0.0, 0.1, 0.0)));
        snowball.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        SoundEffect.ENTITY_SNOWBALL_THROW.playSound(snowball.getLocation());
        new BukkitRunnable(){
            int step = 0;

            public void run() {
                ++this.step;
                if (this.step >= 100) {
                    this.cancel();
                }
                if (snowball.isDead()) {
                    for (int i = 1; i <= 15; ++i) {
                        EnumMaterial m = EnumMaterial.valueOf(351, GadgetsMenu.random().nextInt(15));
                        ParticleEffect.ITEM_CRACK.display(new ParticleEffect.ItemData(m, m.getData()), snowball.getLocation().add(0.0, 0.7, 0.0), 0.5f, 0.5f, 0.5f);
                    }
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 1L, 5L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        this.forceRestore();
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent e) {
        if (e.getPlayer() == this.getPlayer()) {
            Block block = this.getPlayer().getLocation().getBlock();
            Block downBlock = this.getPlayer().getLocation().add(0.0, -1.0, 0.0).getBlock();
            if (block.isEmpty() && !downBlock.isEmpty() && !downBlock.isLiquid() && this.getPlayer().isOnGround()) {
                this.setToRestore(this.getPlayer(), block, EnumMaterial.SNOW, (byte)0, 60);
            }
        }
    }

    private void setToRestore(final Player player, final Block block, EnumMaterial material, byte data, int tickDelay) {
        if (this.snowBlocks.containsKey(block.getLocation())) {
            return;
        }
        if (!(block.getType().toString().toLowerCase().contains("banner") || block.getType() == EnumMaterial.BARRIER.getType() || block.getType().toString().toLowerCase().contains("bed") || block.getType() == EnumMaterial.BREWING_STAND.getType() || block.getType() == EnumMaterial.BROWN_MUSHROOM.getType() || block.getType() == EnumMaterial.CACTUS.getType() || block.getType() == EnumMaterial.CAKE.getType() || block.getType().toString().toLowerCase().contains("cake_block") || block.getType() == EnumMaterial.CARROT.getType() || block.getType() == EnumMaterial.CARROTS.getType() || block.getType().toString().toLowerCase().contains("carpet") || block.getType() == EnumMaterial.COBWEB.getType() || block.getType() == EnumMaterial.COCOA.getType() || block.getType().toString().toLowerCase().contains("crops") || block.getType() == EnumMaterial.DANDELION.getType() || block.getType() == EnumMaterial.DEAD_BUSH.getType() || block.getType().toString().toLowerCase().contains("double_plant") || block.getType() == EnumMaterial.DRAGON_EGG.getType() || block.getType() == EnumMaterial.END_PORTAL.getType() || block.getType() == EnumMaterial.END_PORTAL_FRAME.getType() || block.getType() == EnumMaterial.FARMLAND.getType() || block.getType() == EnumMaterial.FERN.getType() || block.getType() == EnumMaterial.FIRE.getType() || block.getType() == EnumMaterial.FLOWER_POT.getType() || block.getType().toString().toLowerCase().contains("flower_pot") || block.getType() == EnumMaterial.GRASS.getType() || block.getType().toString().toLowerCase().contains("head") || block.getType() == EnumMaterial.LADDER.getType() || block.getType() == EnumMaterial.LARGE_FERN.getType() || block.getType().toString().toLowerCase().endsWith("lava") || block.getType() == EnumMaterial.LEVER.getType() || block.getType() == EnumMaterial.LILY_PAD.getType() || block.getType() == EnumMaterial.LILAC.getType() || block.getType().toString().toLowerCase().contains("long_grass") || block.getType() == EnumMaterial.MELON_STEM.getType() || block.getType() == EnumMaterial.MUSHROOM_STEM.getType() || block.getType() == EnumMaterial.NETHER_PORTAL.getType() || block.getType() == EnumMaterial.NETHER_WART.getType() || block.getType() == EnumMaterial.PEONY.getType() || block.getType().toString().toLowerCase().contains("piston_") || block.getType() == EnumMaterial.POTATO.getType() || block.getType() == EnumMaterial.POTATOES.getType() || block.getType().toString().toLowerCase().contains("potted_") || block.getType() == EnumMaterial.PUMPKIN_STEM.getType() || block.getType() == EnumMaterial.RED_MUSHROOM.getType() || block.getType().toString().toLowerCase().contains("redstone_lamp") || block.getType().toString().toLowerCase().contains("redstone_torch") || block.getType().toString().toLowerCase().contains("red_rose") || block.getType() == EnumMaterial.REDSTONE_WIRE.getType() || block.getType() == EnumMaterial.ROSE_BUSH.getType() || block.getType().toString().toLowerCase().contains("sapling") || block.getType().toString().toLowerCase().contains("seeds") || block.getType().toString().toLowerCase().contains("sign") || block.getType().toString().toLowerCase().contains("skull") || block.getType() == EnumMaterial.SNOW.getType() || block.getType() == EnumMaterial.SUGAR_CANE.getType() || block.getType().toString().toLowerCase().contains("sugar_cane_block") || block.getType() == EnumMaterial.SUNFLOWER.getType() || block.getType() == EnumMaterial.TALL_GRASS.getType() || block.getType() == EnumMaterial.TORCH.getType() || block.getType() == EnumMaterial.TRIPWIRE.getType() || block.getType() == EnumMaterial.TRIPWIRE_HOOK.getType() || block.getType().toString().toLowerCase().contains("tulip") || block.getType() == EnumMaterial.VINE.getType() || block.getType().toString().toLowerCase().endsWith("water") || block.getType() == EnumMaterial.WHEAT.getType() || block.getType().toString().toLowerCase().contains("_button") || block.getType().toString().toLowerCase().contains("_plate") || BlockUtil.isPortalBlock(block) || BlockUtil.isCocoaBlock(block) || BlockUtil.isChorusPlant(block) || block.hasMetadata(GadgetsMenu.getInstance().getPluginName()) || block.isLiquid() || this.snowBlocks.containsKey(block.getLocation()))) {
            if (VersionManager.is1_13OrAbove()) {
                try {
                    this.snowBlocks.put(block.getLocation(), block.getBlockData().getAsString());
                }
                catch (NoSuchMethodError noSuchMethodError) {}
            } else {
                try {
                    this.snowBlocks.put(block.getLocation(), block.getType().toString() + "," + block.getData());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
            block.setType(material.getType());
            ReflectionUtils.setData(block, data);
            block.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
            Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                @Override
                public void run() {
                    MorphSnowman.this.restoreBlock(player, block.getLocation());
                }
            }, (long)tickDelay);
        }
    }

    private void forceRestore() {
        if (this.snowBlocks.isEmpty()) {
            return;
        }
        for (Location loc : this.snowBlocks.keySet()) {
            Block b = loc.getBlock();
            if (VersionManager.is1_13OrAbove()) {
                try {
                    BlockData blockData = Bukkit.getServer().createBlockData(this.snowBlocks.get(loc));
                    b.setBlockData(blockData);
                }
                catch (Exception blockData) {}
            } else {
                String s = this.snowBlocks.get(loc);
                Material m = Material.valueOf((String)s.split(",")[0]);
                byte d = Byte.valueOf(s.split(",")[1]);
                b.setType(m);
                ReflectionUtils.setData(b, d);
            }
            b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        }
        this.snowBlocks.clear();
    }

    private void restoreBlock(Player player, Location location) {
        if (!this.snowBlocks.containsKey(location)) {
            return;
        }
        Block b = location.getBlock();
        if (VersionManager.is1_13OrAbove()) {
            try {
                BlockData blockData = Bukkit.getServer().createBlockData(this.snowBlocks.get(location));
                b.setBlockData(blockData);
            }
            catch (Exception blockData) {}
        } else {
            String s = this.snowBlocks.get(location);
            Material m = Material.valueOf((String)s.split(",")[0]);
            byte d = Byte.valueOf(s.split(",")[1]);
            b.setType(m);
            ReflectionUtils.setData(b, d);
        }
        b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        this.snowBlocks.remove(location);
    }
}

