/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.MorphType;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.Morph;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import java.util.UUID;
import org.bukkit.entity.Fireball;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MorphBlaze
extends Morph {
    private Fireball fireball;
    private boolean activated = false;

    public MorphBlaze(UUID uuid) {
        super(uuid, MorphType.BLAZE);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.MORPH_SKILL_IS_ACTIVATED.getFormatMessage().replace("{MORPH}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.activated = true;
        final Fireball fireball = (Fireball)this.getPlayer().launchProjectile(Fireball.class);
        fireball.setIsIncendiary(false);
        fireball.setYield(0.0f);
        fireball.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        this.fireball = fireball;
        new BukkitRunnable(){
            int time = 0;

            public void run() {
                ++this.time;
                if (fireball.isDead() || this.time >= 100) {
                    MorphBlaze.this.clearAll();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 1L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        if (this.fireball != null && this.fireball.isValid()) {
            SoundEffect.ENTITY_DRAGON_FIREBALL_EXPLODE.playSound(this.fireball.getLocation());
            this.fireball.remove();
        }
        this.fireball = null;
        this.activated = false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemFrameBreak(HangingBreakEvent event) {
        if (this.fireball == null) {
            return;
        }
        if (event.getCause() == HangingBreakEvent.RemoveCause.ENTITY && this.fireball.getWorld() == event.getEntity().getWorld()) {
            if (this.fireball.getLocation().distance(event.getEntity().getLocation()) > 15.0) {
                return;
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onVehicleDestroy(VehicleDestroyEvent event) {
        if (this.fireball == null) {
            return;
        }
        if (this.fireball.getWorld() == event.getVehicle().getWorld() && this.fireball.getLocation().distance(event.getVehicle().getLocation()) > 10.0) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onFireballHit(ProjectileHitEvent event) {
        if (this.fireball == null) {
            return;
        }
        if (!(event.getEntity() instanceof Fireball)) {
            return;
        }
        if (this.fireball.getWorld() != event.getEntity().getWorld()) {
            return;
        }
        if (event.getEntity().hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
            SoundEffect.ENTITY_DRAGON_FIREBALL_EXPLODE.playSound(this.fireball.getLocation());
        }
    }
}

