/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.morphs;

import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.Morph;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.MorphBlaze;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.MorphChicken;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.MorphCow;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.MorphCreeper;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.MorphEnderman;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.MorphGuardian;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.MorphIronGolem;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.MorphPig;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.MorphSheep;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.MorphSkeleton;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.MorphSnowman;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.MorphSpider;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.MorphWitch;
import com.yapzhenyie.GadgetsMenu.cosmetics.morphs.types.MorphZombie;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import com.yapzhenyie.GadgetsMenu.utils.cosmetics.morphs.GDisguiseType;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Rarity;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;

public class MorphType {
    private static final List<MorphType> ENABLED = new ArrayList<MorphType>();
    private static final List<MorphType> VALUES = new ArrayList<MorphType>();
    public static final MorphType PIG = new MorphType("Pig", "&9Pig Morph", new GMaterial(EnumMaterial.COOKED_PORKCHOP), "gadgetsmenu.morphs.pig", 10, 25, Rarity.RARE, Arrays.asList("&7Transform into a Pig. While", "&7transformed, you can squeal", "&7by right-clicking the Slimeball", "&7item in your hotbar."), GDisguiseType.PIG, MorphPig.class);
    public static final MorphType COW = new MorphType("Cow", "&9Cow Morph", new GMaterial(EnumMaterial.COOKED_BEEF), "gadgetsmenu.morphs.cow", 10, 20, Rarity.RARE, Arrays.asList("&7Transform into a Cow. While", "&7transformed, you can moo", "&7by right-clicking the Slimeball", "&7item in your hotbar."), GDisguiseType.COW, MorphCow.class);
    public static final MorphType ENDERMAN = new MorphType("Enderman", "&5Enderman Morph", new GMaterial(EnumMaterial.ENDER_PEARL), "gadgetsmenu.morphs.enderman", 10, 60, Rarity.EPIC, Arrays.asList("&7Transform into a Enderman. While", "&7transformed, you can teleport", "&7randomly by right-clicking the", "&7Slimeball item in your hotbar."), GDisguiseType.ENDERMAN, MorphEnderman.class);
    public static final MorphType CHICKEN = new MorphType("Chicken", "&5Chicken Morph", new GMaterial(EnumMaterial.EGG), "gadgetsmenu.morphs.chicken", 10, 35, Rarity.EPIC, Arrays.asList("&7Transform into a Chicken. While", "&7transformed, you can lay eggs", "&7by right-clicking the Slimeball", "&7item in your hotbar."), GDisguiseType.CHICKEN, MorphChicken.class);
    public static final MorphType SPIDER = new MorphType("Spider", "&5Spider Morph", new GMaterial(EnumMaterial.COBWEB), "gadgetsmenu.morphs.spider", 10, 50, Rarity.EPIC, Arrays.asList("&7Transform into a Spider. While", "&7transformed, you can shoot webs", "&7all around you by right-clicking", "&7the Slimeball item in your", "&7hotbar."), GDisguiseType.SPIDER, MorphSpider.class);
    public static final MorphType SHEEP = new MorphType("Sheep", "&5Sheep Morph", new GMaterial(EnumMaterial.WHITE_WOOL), "gadgetsmenu.morphs.sheep", 10, 50, Rarity.EPIC, Arrays.asList("&7Transform into a Sheep. While", "&7transformed, you can activate", "&7Rainbow Sheep Mode by", "&7right-clicking the Slimeball item", "&7in your hotbar."), GDisguiseType.SHEEP, MorphSheep.class);
    public static final MorphType SKELETON = new MorphType("Skeleton", "&5Skeleton Morph", new GMaterial(EnumMaterial.BOW), "gadgetsmenu.morphs.skeleton", 10, 70, Rarity.EPIC, Arrays.asList("&7Transform into a Skeleton. While", "&7transformed, you can shoot arrows", "&7by right-clicking the Slimeball", "&7item in your hotbar."), GDisguiseType.SKELETON, MorphSkeleton.class);
    public static final MorphType CREEPER = new MorphType("Creeper", "&6Creeper Morph", new GMaterial(EnumMaterial.TNT), "gadgetsmenu.morphs.creeper", 10, 95, Rarity.LEGENDARY, Arrays.asList("&7Transform into a Creeper. While", "&7transformed, you can explode to", "&7knock nearby players aways by", "&7right-clicking the Slimeball", "&7item in your hotbar."), GDisguiseType.CREEPER, MorphCreeper.class);
    public static final MorphType BLAZE = new MorphType("Blaze", "&6Blaze Morph", new GMaterial(EnumMaterial.BLAZE_POWDER), "gadgetsmenu.morphs.blaze", 10, 125, Rarity.LEGENDARY, Arrays.asList("&7Transform into a Blaze. While", "&7transformed, you can shoot", "&7fireballs by right-clicking the", "&7Slimeball item in your hotbar."), GDisguiseType.BLAZE, MorphBlaze.class);
    public static final MorphType ZOMBIE = new MorphType("Zombie", "&6Zombie Morph", new GMaterial(EnumMaterial.ROTTEN_FLESH), "gadgetsmenu.morphs.zombie", 10, 105, Rarity.LEGENDARY, Arrays.asList("&7Transform into a Zombie. While", "&7transformed, you can infect other", "&7players and turn them into a", "&7zombie by right-clicking with", "&7the Slimeball item in your hotbar."), GDisguiseType.ZOMBIE, MorphZombie.class);
    public static final MorphType IRON_GOLEM = new MorphType("Iron Golem", "&6Iron Golem Morph", new GMaterial(EnumMaterial.IRON_BLOCK), "gadgetsmenu.morphs.irongolem", 10, 120, Rarity.LEGENDARY, Arrays.asList("&7Transform into a Iron Golem.", "&7While transformed, you can vigorously", "&7hit the ground by", "&7right-clicking with the Slimeball", "&7item in your hotbar."), GDisguiseType.IRON_GOLEM, MorphIronGolem.class);
    public static final MorphType WITCH = new MorphType("Witch", "&6Witch Morph", new GMaterial(EnumMaterial.POTION, 8196), "gadgetsmenu.morphs.witch", 10, 110, Rarity.LEGENDARY, Arrays.asList("&7Transform into a Witch. While", "&7transformed, you can throw special", "&7potions by right-clicking with the", "&7Slimeball item in your hotbar."), GDisguiseType.WITCH, MorphWitch.class);
    public static final MorphType SNOWMAN = new MorphType("Snowman", "&6Snowman Morph", new GMaterial(EnumMaterial.SNOWBALL), "gadgetsmenu.morphs.snowman", 10, 125, Rarity.LEGENDARY, Arrays.asList("&7Transform into a Snowman. While", "&7transformed, you can throw", "&7snowballs by right-clicking with", "&7the Slimeball item in your", "&7hotbar."), GDisguiseType.SNOWMAN, MorphSnowman.class);
    public static final MorphType GUARDIAN = new MorphType("Guardian", "&6Guardian Morph", new GMaterial(EnumMaterial.PRISMARINE_SHARD), "gadgetsmenu.morphs.guardian", 10, 130, Rarity.LEGENDARY, Arrays.asList("&7Transform into a Guardian.", "&7While transformed, you can shoot", "&7lasers by right-clicking with", "&7the Slimeball item in your", "&7hotbar."), GDisguiseType.GUARDIAN, MorphGuardian.class);
    private String name;
    private String displayName;
    private GMaterial material;
    private String permission;
    private int cooldown;
    private int mysteryDust;
    private Rarity rarity;
    private List<String> lore;
    private GDisguiseType disguiseType;
    private Class<? extends Morph> clazz;
    private boolean isEnable;
    private boolean canBeFound;
    private boolean purchasable;
    private boolean isAbilityEnable;

    private MorphType(String name, String displayName, GMaterial material, String permission, int cooldown, int mysteryDust, Rarity rarity, List<String> lore, GDisguiseType disguiseType, Class<? extends Morph> clazz) {
        this.name = name;
        if (FileManager.getMorphsFile().get("Morphs." + this.name + ".Name") == null) {
            this.displayName = displayName;
            FileManager.getMorphsFile().set("Morphs." + this.name + ".Name", this.displayName);
        } else {
            this.displayName = FileManager.getMorphsFile().getString("Morphs." + this.name + ".Name");
        }
        if (FileManager.getMorphsFile().get("Morphs." + this.name + ".Material") == null) {
            this.material = material;
            FileManager.getMorphsFile().set("Morphs." + this.name + ".Material", this.material.getCombinedMaterial());
        } else {
            GMaterial gMaterial;
            this.material = gMaterial = new GMaterial(FileManager.getMorphsFile().getString("Morphs." + this.name + ".Material"));
        }
        this.permission = permission;
        if (FileManager.getMorphsFile().get("Morphs." + this.name + ".Cooldown") == null) {
            this.cooldown = cooldown;
            FileManager.getMorphsFile().set("Morphs." + this.name + ".Cooldown", this.cooldown);
        } else {
            this.cooldown = FileManager.getMorphsFile().getInt("Morphs." + this.name + ".Cooldown");
        }
        if (FileManager.getMorphsFile().get("Morphs." + this.name + ".Mystery Dust") == null) {
            this.mysteryDust = mysteryDust;
            FileManager.getMorphsFile().set("Morphs." + this.name + ".Mystery Dust", this.mysteryDust);
        } else {
            this.mysteryDust = FileManager.getMorphsFile().getInt("Morphs." + this.name + ".Mystery Dust");
        }
        if (FileManager.getMorphsFile().get("Morphs." + this.name + ".Rarity") == null) {
            this.rarity = rarity;
            FileManager.getMorphsFile().set("Morphs." + this.name + ".Rarity", this.rarity.getName());
        } else {
            this.rarity = Rarity.getName(FileManager.getMorphsFile().getString("Morphs." + this.name + ".Rarity"));
        }
        if (FileManager.getMorphsFile().get("Morphs." + this.name + ".Enabled") == null) {
            this.isEnable = true;
            FileManager.getMorphsFile().set("Morphs." + this.name + ".Enabled", true);
        } else {
            this.isEnable = FileManager.getMorphsFile().getBoolean("Morphs." + this.name + ".Enabled");
        }
        if (FileManager.getMorphsFile().get("Morphs." + this.name + ".CanBeFound") == null) {
            this.canBeFound = true;
            FileManager.getMorphsFile().set("Morphs." + this.name + ".CanBeFound", true);
        } else {
            this.canBeFound = FileManager.getMorphsFile().getBoolean("Morphs." + this.name + ".CanBeFound");
        }
        if (FileManager.getMorphsFile().get("Morphs." + this.name + ".Purchasable") == null) {
            this.purchasable = true;
            FileManager.getMorphsFile().set("Morphs." + this.name + ".Purchasable", true);
        } else {
            this.purchasable = FileManager.getMorphsFile().getBoolean("Morphs." + this.name + ".Purchasable");
        }
        if (FileManager.getMorphsFile().get("Morphs." + this.name + ".Ability Enabled") != null) {
            this.isAbilityEnable = FileManager.getMorphsFile().getBoolean("Morphs." + this.name + ".Ability Enabled");
            FileManager.getMorphsFile().set("Morphs." + this.name + ".Enabled-Ability", this.isAbilityEnable);
            FileManager.getMorphsFile().set("Morphs." + this.name + ".Ability Enabled", null);
        }
        if (FileManager.getMorphsFile().get("Morphs." + this.name + ".Enabled-Ability") == null) {
            this.isAbilityEnable = true;
            FileManager.getMorphsFile().set("Morphs." + this.name + ".Enabled-Ability", true);
        } else {
            this.isAbilityEnable = FileManager.getMorphsFile().getBoolean("Morphs." + this.name + ".Enabled-Ability");
        }
        if (FileManager.getMorphsFile().get("Morphs." + this.name + ".Lore") == null) {
            this.lore = lore;
            if (lore == null) {
                FileManager.getMorphsFile().set("Morphs." + this.name + ".Lore", "");
            } else {
                FileManager.getMorphsFile().set("Morphs." + this.name + ".Lore", this.lore);
            }
        } else {
            this.lore = FileManager.getMorphsFile().getStringList("Morphs." + this.name + ".Lore");
        }
        this.disguiseType = disguiseType;
        this.clazz = clazz;
        if (!VALUES.contains(this)) {
            VALUES.add(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return ChatUtil.format(this.displayName);
    }

    public String getDisplayNameStripColor() {
        return ChatUtil.stripColor(this.displayName);
    }

    public GMaterial getMaterial() {
        return this.material;
    }

    public String getPermission() {
        return this.permission;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getMysteryDust() {
        return this.mysteryDust;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public GDisguiseType getDisguiseType() {
        return this.disguiseType;
    }

    public Class<? extends Morph> getClazz() {
        return this.clazz;
    }

    public boolean isEnabled() {
        return this.isEnable;
    }

    public boolean canBeFound() {
        return this.canBeFound;
    }

    public boolean isPurchasable() {
        return this.purchasable;
    }

    public boolean isAbilityEnabled() {
        return this.isAbilityEnable;
    }

    public static List<MorphType> enabled() {
        return ENABLED;
    }

    public static List<MorphType> values() {
        return VALUES;
    }

    public static void checkEnabled() {
        for (MorphType type : MorphType.values()) {
            if (!type.isEnabled() || ENABLED.contains(type)) continue;
            ENABLED.add(type);
        }
    }

    public Morph equip(Player player) {
        Morph morph = null;
        try {
            morph = this.clazz.getDeclaredConstructor(UUID.class).newInstance(player == null ? null : player.getUniqueId());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return morph;
    }

    public String toString() {
        return this.name;
    }

    public static MorphType valueOf(String name) throws NullPointerException {
        for (MorphType type : MorphType.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }
}

