/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.FireworkUtils;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Pig;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetWhenPigsFly
extends Gadget {
    private boolean activated = false;
    private ArrayList<Item> items = new ArrayList();
    private Pig pig;
    private Bat bat;

    public GadgetWhenPigsFly(UUID uuid) {
        super(uuid, GadgetType.WHEN_PIGS_FLY);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.activated = true;
        Location location = this.getPlayer().getLocation();
        this.pig = (Pig)this.getPlayer().getWorld().spawn(location, Pig.class);
        this.pig.setSaddle(true);
        this.pig.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        this.pig.setPassenger((Entity)this.getPlayer());
        this.bat = (Bat)this.getPlayer().getWorld().spawn(location, Bat.class);
        this.bat.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        this.bat.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 250, 0));
        this.bat.setPassenger((Entity)this.pig);
        if (VersionManager.is1_9OrAbove()) {
            this.bat.setSilent(true);
        }
        GadgetsMenu.getPlayerManager(this.getPlayer()).disableFallDamage();
        new BukkitRunnable(){

            public void run() {
                if (!GadgetWhenPigsFly.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetWhenPigsFly.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetWhenPigsFly.this.getPlayer()).getCurrentGadget().getType() != GadgetWhenPigsFly.this.getType() || !GadgetWhenPigsFly.this.activated) {
                    GadgetWhenPigsFly.this.onClear();
                    this.cancel();
                    return;
                }
                FireworkUtils.displayFirework(GadgetWhenPigsFly.this.pig.getLocation(), FireworkEffect.Type.BURST, false, false, Arrays.asList(Color.RED), Arrays.asList(Color.RED));
                EnumMaterial[] materials = new EnumMaterial[]{EnumMaterial.BONE, EnumMaterial.GUNPOWDER, EnumMaterial.PORKCHOP};
                for (int i = 0; i <= 25; ++i) {
                    Item item = GadgetWhenPigsFly.this.getPlayer().getWorld().dropItem(GadgetWhenPigsFly.this.pig.getLocation(), ItemUtils.item(UUID.randomUUID().toString(), materials[GadgetsMenu.random().nextInt(materials.length)], 0));
                    item.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    item.setPickupDelay(Integer.MAX_VALUE);
                    item.setVelocity(new Vector((GadgetsMenu.random().nextDouble() - 0.5) / 1.7, 0.4, (GadgetsMenu.random().nextDouble() - 0.5) / 1.7));
                    GadgetWhenPigsFly.this.items.add(item);
                }
                SoundEffect.BLOCK_STONE_STEP.playSound(GadgetWhenPigsFly.this.pig.getLocation());
                if (GadgetWhenPigsFly.this.pig != null) {
                    GadgetWhenPigsFly.this.pig.remove();
                }
                if (GadgetWhenPigsFly.this.bat != null) {
                    GadgetWhenPigsFly.this.bat.remove();
                }
                if (GadgetWhenPigsFly.this.getPlayer().isOnGround()) {
                    GadgetsMenu.getPlayerManager(GadgetWhenPigsFly.this.getPlayer()).enableFallDamage();
                }
                new BukkitRunnable(){

                    public void run() {
                        GadgetWhenPigsFly.this.clearAll();
                    }
                }.runTaskLater((Plugin)GadgetsMenu.getInstance(), 60L);
            }
        }.runTaskLater((Plugin)GadgetsMenu.getInstance(), 200L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        if (!this.items.isEmpty()) {
            for (Item item : this.items) {
                item.remove();
            }
            this.items.clear();
        }
        if (this.pig != null) {
            this.pig.remove();
        }
        this.pig = null;
        if (this.bat != null) {
            this.bat.remove();
        }
        this.bat = null;
        if (this.getPlayer().isOnGround()) {
            GadgetsMenu.getPlayerManager(this.getPlayer()).enableFallDamage();
        }
        this.activated = false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerToggleSneak(PlayerToggleSneakEvent e) {
        if (e.getPlayer() == this.getPlayer() && this.activated) {
            this.clearAll();
        }
    }
}

