/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetTNTFountain
extends Gadget {
    private boolean activated = false;
    private ArrayList<Entity> tnt = new ArrayList();

    public GadgetTNTFountain(UUID uuid) {
        super(uuid, GadgetType.TNT_FOUNTAIN);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        Block b = BlockUtil.getTargetBlock(this.getPlayer(), 6);
        if (b.isEmpty() || b.getType().equals((Object)Material.AIR)) {
            this.getPlayer().sendMessage(MessageType.NOT_ON_GROUND.getFormatMessage());
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.activated = true;
        final Block b = BlockUtil.getTargetBlock(this.getPlayer(), 6);
        new BukkitRunnable(){
            int step = 0;

            public void run() {
                ++this.step;
                if (!GadgetTNTFountain.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetTNTFountain.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetTNTFountain.this.getPlayer()).getCurrentGadget().getType() != GadgetTNTFountain.this.getType()) {
                    this.step = 26;
                    GadgetTNTFountain.this.onClear();
                    this.cancel();
                    return;
                }
                if (this.step <= 25) {
                    TNTPrimed entityTnt = (TNTPrimed)b.getLocation().getWorld().spawn(b.getLocation().add(0.0, 0.25, 0.0), TNTPrimed.class);
                    entityTnt.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    GadgetsMenu.getInstance();
                    GadgetsMenu.getInstance();
                    entityTnt.setVelocity(new Vector((GadgetsMenu.random().nextDouble() - 0.5) * 0.7, 1.25, (GadgetsMenu.random().nextDouble() - 0.5) * 0.7));
                    GadgetTNTFountain.this.tnt.add(entityTnt);
                } else {
                    GadgetTNTFountain.this.clearAll();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 8L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Entity entity : this.tnt) {
            entity.remove();
        }
        this.tnt.clear();
        this.activated = false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemFrameBreak(HangingBreakEvent e) {
        if (e.getCause() == HangingBreakEvent.RemoveCause.EXPLOSION) {
            for (Entity ent : this.tnt) {
                if (ent.getWorld() != e.getEntity().getWorld()) continue;
                if (ent.getLocation().distance(e.getEntity().getLocation()) > 15.0) {
                    return;
                }
                e.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onVehicleDestroy(VehicleDestroyEvent e) {
        for (Entity tnt : this.tnt) {
            if (tnt.getWorld() == e.getVehicle().getWorld() && tnt.getLocation().distance(e.getVehicle().getLocation()) > 10.0) {
                return;
            }
            e.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityExplode(EntityExplodeEvent e) {
        if (this.tnt.contains(e.getEntity())) {
            e.setCancelled(true);
            ParticleEffect.EXPLOSION_LARGE.display(e.getEntity().getLocation());
            ParticleEffect.SMOKE_LARGE.display(e.getEntity().getLocation(), 2.0f, 2.0f, 2.0f, 0.0f, 5);
            SoundEffect.ENTITY_GENERIC_EXPLODE.playSound(e.getEntity());
            this.tnt.remove(e.getEntity());
        }
    }
}

