/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.CuboID;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetRocket
extends Gadget {
    private boolean activated = false;
    private ArrayList<Block> blocks = new ArrayList();
    private ArrayList<FallingBlock> fallingBlocks = new ArrayList();
    private ArmorStand armorStand;
    private boolean launching = false;
    private boolean enableFlyByDefault = false;

    public GadgetRocket(UUID uuid) {
        super(uuid, GadgetType.ROCKET);
    }

    @Override
    protected boolean checkRequirements() {
        Location loc2;
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        if (!this.getPlayer().isOnGround()) {
            this.getPlayer().sendMessage(MessageType.NOT_ON_GROUND.getFormatMessage());
            return false;
        }
        Location loc1 = this.getPlayer().getLocation().clone().add(1.0, 0.0, 1.0);
        CuboID checkCuboid = new CuboID(loc1, loc2 = this.getPlayer().getLocation().clone().add(-1.0, 150.0, -1.0));
        if (!checkCuboid.isEmpty() || this.getPlayer().getLocation().clone().add(0.0, 150.0, 0.0).getBlockY() >= 256) {
            this.getPlayer().sendMessage(MessageType.NOT_ENOUGH_SPACE.getFormatMessage());
            return false;
        }
        return super.checkRequirements();
    }

    @Override
    public void onClick() {
        this.activated = true;
        this.getPlayer().setVelocity(new Vector(0, 1, 0));
        final Location loc = this.getPlayer().getLocation().clone();
        loc.setX((double)loc.getBlockX() + 0.5);
        loc.setY((double)loc.getBlockY());
        loc.setZ((double)loc.getBlockZ() + 0.5);
        if (!this.getPlayer().getAllowFlight()) {
            this.getPlayer().setAllowFlight(true);
        } else {
            this.enableFlyByDefault = true;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), new Runnable(){

            @Override
            public void run() {
                int i;
                for (i = 0; i <= 1; ++i) {
                    Block f1 = loc.clone().add(1.0, (double)i, 0.0).getBlock();
                    Block f2 = loc.clone().add(-1.0, (double)i, 0.0).getBlock();
                    Block f3 = loc.clone().add(0.0, (double)i, 1.0).getBlock();
                    Block f4 = loc.clone().add(0.0, (double)i, -1.0).getBlock();
                    f1.setType(EnumMaterial.OAK_FENCE.getType());
                    f2.setType(EnumMaterial.OAK_FENCE.getType());
                    f3.setType(EnumMaterial.OAK_FENCE.getType());
                    f4.setType(EnumMaterial.OAK_FENCE.getType());
                    f1.setMetadata("GadgetsMenu-Rocket", (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    f2.setMetadata("GadgetsMenu-Rocket", (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    f3.setMetadata("GadgetsMenu-Rocket", (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    f4.setMetadata("GadgetsMenu-Rocket", (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    f1.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    f2.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    f3.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    f4.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    GadgetRocket.this.blocks.add(f1);
                    GadgetRocket.this.blocks.add(f2);
                    GadgetRocket.this.blocks.add(f3);
                    GadgetRocket.this.blocks.add(f4);
                }
                for (i = 1; i <= 3; ++i) {
                    Block block = loc.clone().add(0.0, (double)i, 0.0).getBlock();
                    block.setType(Material.QUARTZ_BLOCK);
                    block.setMetadata("GadgetsMenu-Rocket", (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    block.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    GadgetRocket.this.blocks.add(block);
                }
                ArmorStand as = (ArmorStand)loc.getWorld().spawn(loc.add(0.0, 2.5, 0.0), ArmorStand.class);
                as.setVisible(false);
                as.setGravity(false);
                GadgetRocket.this.armorStand = as;
            }
        }, 10L);
        Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), () -> {
            this.armorStand.setPassenger((Entity)this.getPlayer());
            BukkitRunnable runnable = new BukkitRunnable(){
                int i = 5;

                public void run() {
                    if (!GadgetRocket.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetRocket.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetRocket.this.getPlayer()).getCurrentGadget().getType() != GadgetRocket.this.getType()) {
                        GadgetRocket.this.onClear();
                        this.cancel();
                        return;
                    }
                    if (this.i > 0) {
                        if (this.i > 1) {
                            GadgetRocket.this.getPlayer().sendMessage(ChatUtil.format(MessageType.ROCKET_COUNTDOWN.getFormatMessage().replace("{TIMER}", String.valueOf(this.i)).replace("{SECOND}", MessageType.SECONDS.getFormatMessage())));
                        } else {
                            GadgetRocket.this.getPlayer().sendMessage(ChatUtil.format(MessageType.ROCKET_COUNTDOWN.getFormatMessage().replace("{TIMER}", String.valueOf(this.i)).replace("{SECOND}", MessageType.SECOND.getFormatMessage())));
                        }
                        --this.i;
                    } else {
                        GadgetRocket.this.getPlayer().sendMessage(ChatUtil.format(MessageType.ROCKET_LIFT_OFF.getFormatMessage()));
                        SoundEffect.ENTITY_GENERIC_EXPLODE.playSound(GadgetRocket.this.getPlayer().getLocation());
                        if (GadgetRocket.this.armorStand != null) {
                            GadgetRocket.this.armorStand.remove();
                            GadgetRocket.this.armorStand = null;
                        }
                        for (Block block : GadgetRocket.this.blocks) {
                            block.setType(Material.AIR);
                        }
                        FallingBlock top = GadgetRocket.this.getPlayer().getWorld().spawnFallingBlock(GadgetRocket.this.getPlayer().getLocation().add(0.0, 4.0, 0.0), Material.QUARTZ_BLOCK, (byte)0);
                        FallingBlock middle = GadgetRocket.this.getPlayer().getWorld().spawnFallingBlock(GadgetRocket.this.getPlayer().getLocation().add(0.0, 3.0, 0.0), Material.QUARTZ_BLOCK, (byte)0);
                        FallingBlock base = GadgetRocket.this.getPlayer().getWorld().spawnFallingBlock(GadgetRocket.this.getPlayer().getLocation().add(0.0, 2.0, 0.0), Material.QUARTZ_BLOCK, (byte)0);
                        top.setMetadata("GadgetsMenu-Rocket", (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                        middle.setMetadata("GadgetsMenu-Rocket", (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                        base.setMetadata("GadgetsMenu-Rocket", (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                        top.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                        middle.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                        base.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                        for (int i = 0; i < 2; ++i) {
                            FallingBlock fence1 = GadgetRocket.this.getPlayer().getWorld().spawnFallingBlock(GadgetRocket.this.getPlayer().getLocation().add(0.0, (double)(1 + i), 1.0), EnumMaterial.OAK_FENCE.getType(), (byte)0);
                            FallingBlock fence2 = GadgetRocket.this.getPlayer().getWorld().spawnFallingBlock(GadgetRocket.this.getPlayer().getLocation().add(0.0, (double)(1 + i), -1.0), EnumMaterial.OAK_FENCE.getType(), (byte)0);
                            FallingBlock fence3 = GadgetRocket.this.getPlayer().getWorld().spawnFallingBlock(GadgetRocket.this.getPlayer().getLocation().add(1.0, (double)(1 + i), 0.0), EnumMaterial.OAK_FENCE.getType(), (byte)0);
                            FallingBlock fence4 = GadgetRocket.this.getPlayer().getWorld().spawnFallingBlock(GadgetRocket.this.getPlayer().getLocation().add(-1.0, (double)(1 + i), 0.0), EnumMaterial.OAK_FENCE.getType(), (byte)0);
                            GadgetRocket.this.fallingBlocks.add(fence1);
                            GadgetRocket.this.fallingBlocks.add(fence2);
                            GadgetRocket.this.fallingBlocks.add(fence3);
                            GadgetRocket.this.fallingBlocks.add(fence4);
                            fence1.setMetadata("GadgetsMenu-Rocket", (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                            fence2.setMetadata("GadgetsMenu-Rocket", (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                            fence3.setMetadata("GadgetsMenu-Rocket", (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                            fence4.setMetadata("GadgetsMenu-Rocket", (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                            fence1.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                            fence2.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                            fence3.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                            fence4.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                        }
                        GadgetRocket.this.fallingBlocks.add(top);
                        GadgetRocket.this.fallingBlocks.add(middle);
                        GadgetRocket.this.fallingBlocks.add(base);
                        if (((FallingBlock)GadgetRocket.this.fallingBlocks.get(8)).getPassenger() == null) {
                            ((FallingBlock)GadgetRocket.this.fallingBlocks.get(8)).setPassenger((Entity)GadgetRocket.this.getPlayer());
                        }
                        top.setPassenger((Entity)GadgetRocket.this.getPlayer());
                        GadgetRocket.this.launching = true;
                        Bukkit.getScheduler().runTaskLater((Plugin)GadgetsMenu.getInstance(), () -> {
                            if (GadgetRocket.this.activated) {
                                SoundEffect.ENTITY_GENERIC_EXPLODE.playSound(GadgetRocket.this.getPlayer().getLocation());
                                ParticleEffect.EXPLOSION_HUGE.display(GadgetRocket.this.getPlayer().getLocation());
                            }
                            GadgetRocket.this.clearAll();
                        }, 160L);
                        this.cancel();
                    }
                }
            };
            runnable.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 20L);
        }, 12L);
        new BukkitRunnable(){

            public void run() {
                if (!GadgetRocket.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetRocket.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetRocket.this.getPlayer()).getCurrentGadget().getType() != GadgetRocket.this.getType()) {
                    GadgetRocket.this.onClear();
                    this.cancel();
                    return;
                }
                if (!GadgetRocket.this.activated) {
                    this.cancel();
                    return;
                }
                if (GadgetRocket.this.getPlayer().isFlying()) {
                    GadgetRocket.this.getPlayer().setFlying(false);
                }
                if (GadgetRocket.this.armorStand != null) {
                    if (GadgetRocket.this.armorStand.getPassenger() == null) {
                        GadgetRocket.this.armorStand.setPassenger((Entity)GadgetRocket.this.getPlayer());
                    }
                    ParticleEffect.CLOUD.display(GadgetRocket.this.armorStand.getLocation().add(0.0, -3.0, 0.0), 0.3f, 0.2f, 0.3f, 0.2f, 7);
                    ParticleEffect.SMOKE_LARGE.display(GadgetRocket.this.armorStand.getLocation().add(0.0, -3.0, 0.0), 0.3f, 0.2f, 0.3f, 0.2f, 3);
                    SoundEffect.BLOCK_LAVA_EXTINGUISH.playSound(GadgetRocket.this.armorStand.getLocation().add(0.0, -3.0, 0.0), 0.2f, 1.0f);
                }
                for (FallingBlock fallingBlock : GadgetRocket.this.fallingBlocks) {
                    fallingBlock.setVelocity(new Vector(0.0, 0.8, 0.0));
                }
                if (GadgetRocket.this.activated) {
                    if (GadgetRocket.this.launching) {
                        if (!GadgetRocket.this.fallingBlocks.isEmpty() && ((FallingBlock)GadgetRocket.this.fallingBlocks.get(8)).getPassenger() == null) {
                            ((FallingBlock)GadgetRocket.this.fallingBlocks.get(8)).setPassenger((Entity)GadgetRocket.this.getPlayer());
                        }
                        ParticleEffect.FLAME.display(GadgetRocket.this.getPlayer().getLocation().add(0.0, -3.0, 0.0), 0.3f, 0.2f, 0.3f, 8);
                        ParticleEffect.LAVA.display(GadgetRocket.this.getPlayer().getLocation().add(0.0, -3.0, 0.0), 0.3f, 0.2f, 0.3f, 8);
                        ParticleEffect.SMOKE_LARGE.display(GadgetRocket.this.getPlayer().getLocation().add(0.0, -3.0, 0.0), 0.3f, 0.2f, 0.3f, 0.2f, 8);
                        SoundEffect.ENTITY_BAT_LOOP.playSound(GadgetRocket.this.getPlayer().getLocation().add(0.0, -3.0, 0.0), 1.0f, 1.0f);
                        SoundEffect.BLOCK_LAVA_EXTINGUISH.playSound(GadgetRocket.this.getPlayer().getLocation().add(0.0, -3.0, 0.0), 0.025f, 1.0f);
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 1L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Block block : this.blocks) {
            block.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
            block.setType(Material.AIR);
        }
        this.blocks.clear();
        for (FallingBlock fallingBlock : this.fallingBlocks) {
            fallingBlock.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
            fallingBlock.remove();
        }
        this.fallingBlocks.clear();
        if (this.armorStand != null) {
            this.armorStand.remove();
            this.armorStand.setPassenger(null);
        }
        this.armorStand = null;
        GadgetsMenu.getPlayerManager(this.getPlayer()).disableFallDamage();
        if (!this.enableFlyByDefault && this.activated) {
            Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                this.getPlayer().setAllowFlight(false);
                if (this.getPlayer().isFlying()) {
                    this.getPlayer().setFlying(false);
                }
            });
        }
        this.activated = false;
        this.launching = false;
        this.enableFlyByDefault = false;
    }
}

