/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.entity.Item;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetGoldFountain
extends Gadget {
    private boolean activated = false;
    private ArrayList<Item> items = new ArrayList();

    public GadgetGoldFountain(UUID uuid) {
        super(uuid, GadgetType.GOLD_FOUNTAIN);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        SoundEffect.ENTITY_HORSE_ARMOR.playSound(this.getPlayer().getLocation());
        this.activated = true;
        final EnumMaterial[] materials = new EnumMaterial[]{EnumMaterial.GOLD_INGOT, EnumMaterial.GOLD_BLOCK, EnumMaterial.GOLDEN_CHESTPLATE, EnumMaterial.GOLDEN_PICKAXE, EnumMaterial.GOLD_ORE, EnumMaterial.GOLDEN_APPLE, EnumMaterial.GOLDEN_SWORD};
        new BukkitRunnable(){
            int step = 0;

            public void run() {
                ++this.step;
                if (!GadgetGoldFountain.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetGoldFountain.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetGoldFountain.this.getPlayer()).getCurrentGadget().getType() != GadgetGoldFountain.this.getType()) {
                    this.step = 50;
                    GadgetGoldFountain.this.onClear();
                    this.cancel();
                    return;
                }
                for (Item item : GadgetGoldFountain.this.items) {
                    if (item.getTicksLived() <= 10) continue;
                    item.remove();
                }
                if (this.step <= 50) {
                    Item item = GadgetGoldFountain.this.getPlayer().getWorld().dropItem(GadgetGoldFountain.this.getPlayer().getEyeLocation(), ItemUtils.item(UUID.randomUUID().toString(), materials[GadgetsMenu.random().nextInt(materials.length)], 0));
                    item.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    item.setPickupDelay(Integer.MAX_VALUE);
                    item.setVelocity(new Vector((GadgetsMenu.random().nextDouble() - 0.5) / 5.0, 0.3, (GadgetsMenu.random().nextDouble() - 0.5) / 5.0));
                    GadgetGoldFountain.this.items.add(item);
                } else {
                    GadgetGoldFountain.this.clearAll();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 4L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Item item : this.items) {
            item.remove();
        }
        this.items.clear();
        this.activated = false;
    }
}

