/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Entity;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class GadgetGhosts
extends Gadget {
    private boolean activated = false;
    private HashMap<Bat, ArmorStand> ghosts = new HashMap();

    public GadgetGhosts(UUID uuid) {
        super(uuid, GadgetType.GHOSTS);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.activated = true;
        for (int i = 0; i < 8; ++i) {
            Bat bat = (Bat)this.getPlayer().getWorld().spawn(this.getPlayer().getLocation().add(0.0, 1.0, 0.0), Bat.class);
            ArmorStand ghost = (ArmorStand)bat.getWorld().spawn(bat.getLocation(), ArmorStand.class);
            ghost.setSmall(true);
            ghost.setGravity(false);
            ghost.setVisible(false);
            ghost.setHelmet(new ItemStack(EnumMaterial.WITHER_SKELETON_SKULL.getType(), 1, 1));
            ghost.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
            bat.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
            bat.setPassenger((Entity)ghost);
            bat.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 240, 1));
            this.ghosts.put(bat, ghost);
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)GadgetsMenu.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (!GadgetGhosts.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetGhosts.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetGhosts.this.getPlayer()).getCurrentGadget().getType() != GadgetGhosts.this.getType()) {
                    GadgetGhosts.this.onClear();
                    return;
                }
                GadgetGhosts.this.clearAll();
            }
        }, 220L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Bat bat : this.ghosts.keySet()) {
            bat.remove();
        }
        for (ArmorStand armorStand : this.ghosts.values()) {
            armorStand.remove();
        }
        this.ghosts.clear();
        this.activated = false;
    }
}

