/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import java.text.DecimalFormat;
import java.util.UUID;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Sheep;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GadgetExplodingSheep
extends Gadget {
    private boolean activated = false;
    private Sheep sheep;

    public GadgetExplodingSheep(UUID uuid) {
        super(uuid, GadgetType.EXPLODING_SHEEP);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.activated = true;
        Location loc = this.getPlayer().getLocation().add(this.getPlayer().getLocation().getDirection().multiply(0.5));
        loc.setY(this.getPlayer().getLocation().getY() + 1.0);
        final Sheep entitySheep = (Sheep)this.getPlayer().getWorld().spawn(loc, Sheep.class);
        entitySheep.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        entitySheep.setAgeLock(true);
        entitySheep.setCustomNameVisible(true);
        entitySheep.setCustomName(ChatUtil.format("&c&l3.0s"));
        GadgetsMenu.getNMSManager().removePathfinders((Entity)entitySheep);
        this.sheep = entitySheep;
        new BukkitRunnable(){
            int step = 0;

            public void run() {
                ++this.step;
                if (!GadgetExplodingSheep.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetExplodingSheep.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetExplodingSheep.this.getPlayer()).getCurrentGadget().getType() != GadgetExplodingSheep.this.getType() || GadgetExplodingSheep.this.sheep == null) {
                    this.step = 15;
                    GadgetExplodingSheep.this.onClear();
                    return;
                }
                DecimalFormat decimalFormat = new DecimalFormat("0.0");
                GadgetExplodingSheep.this.sheep.setCustomName(ChatUtil.format("&c&l" + decimalFormat.format(3.0 - (double)this.step * 4.0 / 20.0) + "s"));
                if (this.step <= 14) {
                    SoundEffect.UI_BUTTON_CLICK.playSound((Entity)entitySheep);
                    if (entitySheep.getColor() == DyeColor.RED) {
                        entitySheep.setColor(DyeColor.WHITE);
                    } else {
                        entitySheep.setColor(DyeColor.RED);
                    }
                } else {
                    ParticleEffect.EXPLOSION_LARGE.display(entitySheep.getLocation().add(0.0, 1.0, 0.0), 0.5f, 5);
                    SoundEffect.ENTITY_GENERIC_EXPLODE.playSound((Entity)entitySheep);
                    GadgetExplodingSheep.this.clearAll();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 4L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        if (this.sheep != null) {
            this.sheep.remove();
        }
        this.sheep = null;
        this.activated = false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerShearSheep(PlayerShearEntityEvent event) {
        if (GadgetsMenu.getNMSManager().hasNBTTag(event.getPlayer().getItemInHand(), "Cosmetics")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerShearBlock(BlockBreakEvent event) {
        if (GadgetsMenu.getNMSManager().hasNBTTag(event.getPlayer().getItemInHand(), "Cosmetics")) {
            event.setCancelled(true);
        }
    }
}

