/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.CuboID;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MathUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.PlayerUtils;
import com.yapzhenyie.GadgetsMenu.utils.ReflectionUtils;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetDivingBoard
extends Gadget {
    private boolean activated = false;
    private Location location;
    private HashMap<Location, String> blocks = new HashMap();
    private HashMap<Location, String> waterGroundBlocks = new HashMap();
    private static List<String> messages = FileManager.getGadgetsFile().getStringList("Gadgets.Fun And Games.Types.Diving Board.Messages");

    public GadgetDivingBoard(UUID uuid) {
        super(uuid, GadgetType.DIVING_BOARD);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        if (!this.getPlayer().isOnGround()) {
            this.getPlayer().sendMessage(MessageType.NOT_ON_GROUND.getFormatMessage());
            return false;
        }
        Location loc1 = this.getPlayer().getLocation().clone().add(-1.0, 0.0, -2.0);
        Location loc2 = this.getPlayer().getLocation().clone().add(7.0, 8.0, 2.0);
        Location waterGroundLoc1 = this.getPlayer().getLocation().clone().add(4.0, -1.0, -1.0);
        Location waterGroundLoc2 = this.getPlayer().getLocation().clone().add(6.0, -1.0, 1.0);
        CuboID cuboid = new CuboID(loc1, loc2);
        CuboID cuboid2 = new CuboID(waterGroundLoc1, waterGroundLoc2);
        if (!cuboid.isEmpty()) {
            this.getPlayer().sendMessage(MessageType.NOT_ENOUGH_SPACE.getFormatMessage());
            return false;
        }
        for (Block block : cuboid2.getBlocks()) {
            if (block.hasMetadata(GadgetsMenu.getInstance().getPluginName())) {
                this.getPlayer().sendMessage(MessageType.GADGET_ACTIVATED_IN_SAME_AREA.getFormatMessage());
                return false;
            }
            if (!block.isLiquid() && !block.isEmpty() && !block.getType().toString().toLowerCase().contains("sapling") && block.getType() != EnumMaterial.TORCH.getType() && block.getType() != EnumMaterial.FIRE.getType() && block.getType() != EnumMaterial.LEVER.getType() && !block.getType().toString().toLowerCase().contains("plate") && !block.getType().toString().toLowerCase().contains("redstone_torch") && !block.getType().toString().toLowerCase().contains("_button") && block.getType() != EnumMaterial.SNOW.getType() && block.getType() != EnumMaterial.CACTUS.getType() && block.getType() != EnumMaterial.SUGAR_CANE.getType() && !block.getType().toString().toLowerCase().contains("sugar_cane_block") && !block.getType().toString().toLowerCase().contains("cake_block") && block.getType() != EnumMaterial.CAKE.getType() && block.getType() != EnumMaterial.PUMPKIN_STEM.getType() && block.getType() != EnumMaterial.MELON_STEM.getType() && block.getType() != EnumMaterial.MUSHROOM_STEM.getType() && block.getType() != EnumMaterial.VINE.getType() && !block.getType().toString().toLowerCase().contains("carpet") && !block.getType().toString().toLowerCase().contains("double_plant") && block.getType() != EnumMaterial.LILY_PAD.getType() && block.getType() != EnumMaterial.LILAC.getType() && block.getType() != EnumMaterial.PEONY.getType() && block.getType() != EnumMaterial.ROSE_BUSH.getType() && block.getType() != EnumMaterial.TALL_GRASS.getType() && block.getType() != EnumMaterial.LARGE_FERN.getType() && block.getType() != EnumMaterial.SUNFLOWER.getType() && block.getType() != EnumMaterial.NETHER_WART.getType() && !block.getType().toString().toLowerCase().contains("long_grass") && block.getType() != EnumMaterial.GRASS.getType() && block.getType() != EnumMaterial.FERN.getType() && block.getType() != EnumMaterial.DEAD_BUSH.getType() && block.getType() != EnumMaterial.DANDELION.getType() && !block.getType().toString().toLowerCase().contains("tulip") && !block.getType().toString().toLowerCase().contains("red_rose") && block.getType() != EnumMaterial.RED_MUSHROOM.getType() && block.getType() != EnumMaterial.BROWN_MUSHROOM.getType() && block.getType() != EnumMaterial.FLOWER_POT.getType() && !block.getType().toString().toLowerCase().contains("flower_pot_item") && !block.getType().toString().toLowerCase().contains("potted_") && block.getType() != EnumMaterial.CARROT.getType() && block.getType() != EnumMaterial.CARROTS.getType() && block.getType() != EnumMaterial.POTATO.getType() && block.getType() != EnumMaterial.POTATOES.getType() && block.getType() != EnumMaterial.TRIPWIRE_HOOK.getType() && block.getType() != EnumMaterial.TRIPWIRE.getType() && block.getType() != EnumMaterial.REDSTONE_WIRE.getType() && block.getType() != EnumMaterial.WHEAT.getType() && !block.getType().toString().toLowerCase().contains("skull") && !block.getType().toString().toLowerCase().contains("head") && block.getType() != EnumMaterial.LADDER.getType() && block.getType() != EnumMaterial.FARMLAND.getType() && block.getType() != EnumMaterial.COBWEB.getType() && !BlockUtil.isItemFrame(block) && !BlockUtil.isCocoaBlock(block)) continue;
            this.getPlayer().sendMessage(MessageType.NOT_ON_FLAT_GROUND.getFormatMessage());
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        this.location = this.getPlayer().getLocation().clone();
        Location teleportLoc = this.getPlayer().getLocation().getBlock().getLocation().clone().add(0.5, 5.0, 0.5);
        teleportLoc.setYaw(-90.0f);
        this.getPlayer().teleport(teleportLoc);
        this.generateDivingBoard();
        new BukkitRunnable(){

            public void run() {
                if (!GadgetDivingBoard.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetDivingBoard.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetDivingBoard.this.getPlayer()).getCurrentGadget().getType() != GadgetDivingBoard.this.getType() || !GadgetDivingBoard.this.activated) {
                    return;
                }
                GadgetDivingBoard.this.clearAll();
            }
        }.runTaskLater((Plugin)GadgetsMenu.getInstance(), 800L);
        this.activated = true;
    }

    @Override
    public void onUpdate() {
        if (this.activated) {
            Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                @Override
                public void run() {
                    for (Player player : PlayerUtils.getNearbyPlayers(GadgetDivingBoard.this.getLocation(2, 4, 0).getLocation(), 2.0)) {
                        Block b = player.getLocation().getBlock().getRelative(BlockFace.DOWN);
                        if (b.getType() != EnumMaterial.STONE_SLAB.getType() || b.getData() != 0) continue;
                        MathUtil.applyVelocity((Entity)player, new Vector(0.3, 1.8, 0.0));
                        SoundEffect.BLOCK_WOODEN_TRAPDOOR_OPEN.playSound(b.getLocation());
                        if (!GadgetsMenu.random().nextBoolean()) continue;
                        player.sendMessage(ChatUtil.format((String)messages.get(GadgetsMenu.random().nextInt(messages.size()))));
                    }
                }
            });
        }
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        Block b;
        if (this.location != null) {
            this.getLocation(-1, 3, 0).setType(Material.AIR);
            this.getLocation(-1, 2, 0).setType(Material.AIR);
            this.getLocation(-1, 1, 0).setType(Material.AIR);
            this.getLocation(-1, 0, 0).setType(Material.AIR);
        }
        for (Location location : this.blocks.keySet()) {
            b = location.clone().getBlock();
            b.setType(Material.AIR);
            b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        }
        this.blocks.clear();
        for (Location location : this.waterGroundBlocks.keySet()) {
            b = location.clone().getBlock();
            if (VersionManager.is1_13OrAbove()) {
                try {
                    BlockData blockData = Bukkit.getServer().createBlockData(this.waterGroundBlocks.get(location));
                    b.setBlockData(blockData);
                }
                catch (Exception blockData) {}
            } else {
                String s = this.waterGroundBlocks.get(location);
                Material m = Material.valueOf((String)s.split(",")[0]);
                byte d = Byte.valueOf(s.split(",")[1]);
                b.setType(m);
                ReflectionUtils.setData(b, d);
            }
            b.removeMetadata(GadgetsMenu.getInstance().getPluginName(), (Plugin)GadgetsMenu.getInstance());
        }
        this.waterGroundBlocks.clear();
        this.activated = false;
    }

    private void generateDivingBoard() {
        this.saveWaterGroundBlock(this.getLocation(4, -1, -1));
        this.saveWaterGroundBlock(this.getLocation(4, -1, 0));
        this.saveWaterGroundBlock(this.getLocation(4, -1, 1));
        this.saveWaterGroundBlock(this.getLocation(5, -1, -1));
        this.saveWaterGroundBlock(this.getLocation(5, -1, 0));
        this.saveWaterGroundBlock(this.getLocation(5, -1, 1));
        this.saveWaterGroundBlock(this.getLocation(6, -1, -1));
        this.saveWaterGroundBlock(this.getLocation(6, -1, 0));
        this.saveWaterGroundBlock(this.getLocation(6, -1, 1));
        this.setBlock(this.getLocation(3, 0, 0), EnumMaterial.SMOOTH_STONE_SLAB, false, (byte)0);
        this.setBlock(this.getLocation(3, 0, -1), EnumMaterial.SMOOTH_STONE_SLAB, false, (byte)0);
        this.setBlock(this.getLocation(3, 0, -2), EnumMaterial.SMOOTH_STONE_SLAB, false, (byte)0);
        this.setBlock(this.getLocation(4, 0, -2), EnumMaterial.SMOOTH_STONE_SLAB, false, (byte)0);
        this.setBlock(this.getLocation(5, 0, -2), EnumMaterial.SMOOTH_STONE_SLAB, false, (byte)0);
        this.setBlock(this.getLocation(6, 0, -2), EnumMaterial.SMOOTH_STONE_SLAB, false, (byte)0);
        this.setBlock(this.getLocation(7, 0, -2), EnumMaterial.SMOOTH_STONE_SLAB, false, (byte)0);
        this.setBlock(this.getLocation(7, 0, -1), EnumMaterial.SMOOTH_STONE_SLAB, false, (byte)0);
        this.setBlock(this.getLocation(7, 0, 0), EnumMaterial.SMOOTH_STONE_SLAB, false, (byte)0);
        this.setBlock(this.getLocation(7, 0, 1), EnumMaterial.SMOOTH_STONE_SLAB, false, (byte)0);
        this.setBlock(this.getLocation(7, 0, 2), EnumMaterial.SMOOTH_STONE_SLAB, false, (byte)0);
        this.setBlock(this.getLocation(3, 0, 1), EnumMaterial.SMOOTH_STONE_SLAB, false, (byte)0);
        this.setBlock(this.getLocation(3, 0, 2), EnumMaterial.SMOOTH_STONE_SLAB, false, (byte)0);
        this.setBlock(this.getLocation(4, 0, 2), EnumMaterial.SMOOTH_STONE_SLAB, false, (byte)0);
        this.setBlock(this.getLocation(5, 0, 2), EnumMaterial.SMOOTH_STONE_SLAB, false, (byte)0);
        this.setBlock(this.getLocation(6, 0, 2), EnumMaterial.SMOOTH_STONE_SLAB, false, (byte)0);
        this.setBlock(this.getLocation(4, 0, 0), EnumMaterial.WATER, false, (byte)0);
        this.setBlock(this.getLocation(4, 0, -1), EnumMaterial.WATER, false, (byte)0);
        this.setBlock(this.getLocation(4, 0, 1), EnumMaterial.WATER, false, (byte)0);
        this.setBlock(this.getLocation(5, 0, 0), EnumMaterial.WATER, false, (byte)0);
        this.setBlock(this.getLocation(5, 0, -1), EnumMaterial.WATER, false, (byte)0);
        this.setBlock(this.getLocation(5, 0, 1), EnumMaterial.WATER, false, (byte)0);
        this.setBlock(this.getLocation(6, 0, 0), EnumMaterial.WATER, false, (byte)0);
        this.setBlock(this.getLocation(6, 0, -1), EnumMaterial.WATER, false, (byte)0);
        this.setBlock(this.getLocation(6, 0, 1), EnumMaterial.WATER, false, (byte)0);
        this.setBlock(this.getLocation(1, 3, 0), EnumMaterial.SMOOTH_STONE_SLAB, false, (byte)0);
        this.setBlock(this.getLocation(2, 3, 0), EnumMaterial.SMOOTH_STONE_SLAB, false, (byte)0);
        this.setBlock(this.getLocation(0, 3, 0), EnumMaterial.IRON_BLOCK, false, (byte)0);
        this.setBlock(this.getLocation(0, 2, 0), EnumMaterial.IRON_BLOCK, false, (byte)0);
        this.setBlock(this.getLocation(0, 1, 0), EnumMaterial.IRON_BLOCK, false, (byte)0);
        this.setBlock(this.getLocation(0, 0, 0), EnumMaterial.IRON_BLOCK, false, (byte)0);
        this.setBlock(this.getLocation(-1, 3, 0), EnumMaterial.LADDER, true, (byte)4);
        this.setBlock(this.getLocation(-1, 2, 0), EnumMaterial.LADDER, true, (byte)4);
        this.setBlock(this.getLocation(-1, 1, 0), EnumMaterial.LADDER, true, (byte)4);
        this.setBlock(this.getLocation(-1, 0, 0), EnumMaterial.LADDER, true, (byte)4);
    }

    private void setBlock(Block block, EnumMaterial material, boolean changeFacing, byte facing) {
        if (!this.blocks.containsKey(block.getLocation())) {
            if (VersionManager.is1_13OrAbove()) {
                try {
                    this.blocks.put(block.getLocation(), block.getBlockData().getAsString());
                }
                catch (NoSuchMethodError noSuchMethodError) {}
            } else {
                try {
                    this.blocks.put(block.getLocation(), block.getType().toString() + "," + block.getData());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
        }
        block.setType(material.getType());
        if (VersionManager.is1_13OrAbove()) {
            if (changeFacing) {
                BlockData blockData = block.getBlockData();
                ((Directional)blockData).setFacing(BlockUtil.getBlockFace(facing));
                block.setBlockData(blockData);
            }
        } else {
            ReflectionUtils.setData(block, changeFacing ? facing : material.getData());
        }
        block.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
    }

    private void saveWaterGroundBlock(Block block) {
        if (!this.waterGroundBlocks.containsKey(block.getLocation())) {
            if (VersionManager.is1_13OrAbove()) {
                try {
                    this.waterGroundBlocks.put(block.getLocation(), block.getBlockData().getAsString());
                }
                catch (NoSuchMethodError noSuchMethodError) {}
            } else {
                try {
                    this.waterGroundBlocks.put(block.getLocation(), block.getType().toString() + "," + block.getData());
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
        }
        block.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
    }

    private Block getLocation(int x, int y, int z) {
        return this.location.getBlock().getRelative(x, y, z);
    }
}

