/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.GadgetDJBooth;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EntityUtils;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.EnumPermission;
import com.yapzhenyie.GadgetsMenu.utils.MathUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.PermissionUtils;
import com.yapzhenyie.GadgetsMenu.utils.VersionManager;
import depend.xxmicloxx.NoteBlockAPI.model.Song;
import depend.xxmicloxx.NoteBlockAPI.songplayer.PositionSongPlayer;
import depend.xxmicloxx.NoteBlockAPI.utils.NBSDecoder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetDiscoBall
extends Gadget {
    private static int duration = FileManager.getGadgetsFile().get("Gadgets.Musical.Types.Disco Ball.Duration-Seconds") == null ? 60 : FileManager.getGadgetsFile().getInt("Gadgets.Musical.Types.Disco Ball.Duration-Seconds");
    public static HashMap<GadgetDiscoBall, Location> DISCO_BALLS = new HashMap();
    private boolean activated = false;
    private ArmorStand armorStand;
    private PositionSongPlayer positionSongPlayer;
    private static File files = new File(GadgetsMenu.getInstance().getDataFolder().getPath() + "/songs/DiscoBallGadget/");
    private static List<File> songs = new ArrayList<File>();
    private ArrayList<Player> hideCBar = new ArrayList();

    public GadgetDiscoBall(UUID uuid) {
        super(uuid, GadgetType.DISCO_BALL);
        if (songs.isEmpty()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), new Runnable(){

                @Override
                public void run() {
                    if (files.exists() && files.listFiles().length > 0) {
                        for (File f : files.listFiles()) {
                            if (!f.getName().contains(".nbs") || songs.contains(f)) continue;
                            songs.add(f);
                        }
                    }
                }
            });
        }
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        for (Location loc : DISCO_BALLS.values()) {
            if (!loc.getWorld().equals(this.getPlayer().getWorld())) continue;
            this.getPlayer().sendMessage(MessageType.SAME_TYPE_GADGET_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        for (Location loc : GadgetDJBooth.DJ_BOOTH.values()) {
            if (!loc.getWorld().equals(this.getPlayer().getWorld()) || !(loc.distanceSquared(this.getPlayer().getLocation()) <= 625.0)) continue;
            this.getPlayer().sendMessage(MessageType.SAME_TYPE_GADGET_ACTIVATED.getFormatMessage().replace("{GADGET}", GadgetType.DJ_BOOTH.getDisplayNameStripColor()));
            return false;
        }
        if (this.getPlayer().getLocation().add(0.0, 4.0, 0.0).getBlock() != null && this.getPlayer().getLocation().add(0.0, 4.0, 0.0).getBlock().getType() != Material.AIR) {
            this.getPlayer().sendMessage(MessageType.NOT_ENOUGH_SPACE.getFormatMessage());
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        ArmorStand as = (ArmorStand)this.getPlayer().getWorld().spawnEntity(this.getPlayer().getLocation().add(0.0, 3.0, 0.0), EntityType.ARMOR_STAND);
        as.setVisible(false);
        as.setGravity(false);
        as.setSmall(false);
        try {
            if (VersionManager.is1_9OrAbove()) {
                as.setSilent(true);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        as.setHelmet(new ItemStack(EnumMaterial.LIGHT_BLUE_STAINED_GLASS.getType(), 1, 3));
        as.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        this.armorStand = as;
        if (!DISCO_BALLS.containsKey(this)) {
            DISCO_BALLS.put(this, as.getLocation());
        }
        final File song = songs.get(new Random().nextInt(songs.size()));
        Song s = NBSDecoder.parse(song);
        this.positionSongPlayer = new PositionSongPlayer(s);
        this.positionSongPlayer.setTargetLocation(this.armorStand.getEyeLocation().add(-0.5, -0.5, -0.5));
        this.positionSongPlayer.setPlaying(true);
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p.getWorld() != this.armorStand.getWorld() || !p.isOnline()) continue;
            this.positionSongPlayer.addPlayer(p);
        }
        this.positionSongPlayer.setVolume((byte)100);
        this.positionSongPlayer.getFadeIn().setFadeStart((byte)25);
        this.positionSongPlayer.getFadeOut().setFadeStart((byte)25);
        new BukkitRunnable(){
            int step = 0;

            public void run() {
                ++this.step;
                if (!GadgetDiscoBall.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetDiscoBall.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetDiscoBall.this.getPlayer()).getCurrentGadget().getType() != GadgetDiscoBall.this.getType() || GadgetDiscoBall.this.armorStand == null || GadgetDiscoBall.this.getPlayer().getLocation().distance(GadgetDiscoBall.this.armorStand.getLocation()) > 256.0) {
                    this.step = duration * 20 + 1;
                    GadgetDiscoBall.this.onClear();
                    this.cancel();
                    return;
                }
                if (this.step >= GadgetDiscoBall.this.positionSongPlayer.getSong().getLength()) {
                    this.step = duration * 20 + 1;
                    GadgetDiscoBall.this.onClear();
                    this.cancel();
                    return;
                }
                if (this.step <= duration * 20 || !PermissionUtils.noPermission(GadgetDiscoBall.this.getPlayer(), EnumPermission.BYPASS_DISCOBALL_DURATION.getPermission(), false)) {
                    GadgetDiscoBall.this.armorStand.setHeadPose(GadgetDiscoBall.this.armorStand.getHeadPose().add(0.0, 0.2, 0.0));
                    int glassData = GadgetsMenu.random().nextInt(16);
                    Material glass = EnumMaterial.valueOf(95, glassData).getType();
                    GadgetDiscoBall.this.armorStand.setHelmet(new ItemStack(glass, 1, (short)glassData));
                    Location loc = GadgetDiscoBall.this.armorStand.getEyeLocation().add(MathUtil.randomDouble(-4.0, 4.0), MathUtil.randomDouble(-3.0, 3.0), MathUtil.randomDouble(-4.0, 4.0));
                    ParticleEffect.NOTE.display(loc, 1.0f, 5);
                    ParticleEffect.SPELL_INSTANT.display(GadgetDiscoBall.this.armorStand.getLocation(), 2.0f, 2.0f, 2.0f, 1.0f, 5);
                    for (Entity ent : EntityUtils.getNearbyEntities(GadgetDiscoBall.this.armorStand.getEyeLocation().add(-0.5, -0.5, -0.5), 7.5)) {
                        if (!ent.isOnGround()) continue;
                        MathUtil.applyVelocity(ent, new Vector(0.0, 0.3, 0.0));
                    }
                } else {
                    if (GadgetDiscoBall.this.positionSongPlayer.isPlaying()) {
                        GadgetDiscoBall.this.positionSongPlayer.setPlaying(false);
                    }
                    GadgetDiscoBall.this.clearAll();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 1L);
        BukkitRunnable runnable = new BukkitRunnable(){
            int times = 0;

            public void run() {
                if (!GadgetDiscoBall.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetDiscoBall.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetDiscoBall.this.getPlayer()).getCurrentGadget().getType() != GadgetDiscoBall.this.getType()) {
                    GadgetDiscoBall.this.showCooldownBar = true;
                    for (Player p : GadgetDiscoBall.this.hideCBar) {
                        if (!Gadget.hideCooldownBar.contains(p)) continue;
                        Gadget.hideCooldownBar.remove(p);
                    }
                    this.cancel();
                    return;
                }
                if (this.times > 5) {
                    GadgetDiscoBall.this.showCooldownBar = true;
                    for (Player p : GadgetDiscoBall.this.hideCBar) {
                        if (!Gadget.hideCooldownBar.contains(p)) continue;
                        Gadget.hideCooldownBar.remove(p);
                    }
                    this.cancel();
                    return;
                }
                GadgetDiscoBall.this.showCooldownBar = false;
                for (Entity ent : EntityUtils.getNearbyEntities(GadgetDiscoBall.this.armorStand.getEyeLocation().add(-0.5, -0.5, -0.5), 7.5)) {
                    if (!(ent instanceof Player) || ent.hasMetadata("NPC")) continue;
                    GadgetsMenu.getPlayerManager((Player)ent).sendActionMessage(MessageType.PLAYING_SONG.getFormatMessage().replace("{RANDOM_COLOR}", ChatUtil.getRandomColor()).replace("{SONG}", song.getName().replace(".nbs", "")));
                    if (!Gadget.hideCooldownBar.contains((Player)ent)) {
                        Gadget.hideCooldownBar.add((Player)ent);
                    }
                    if (GadgetDiscoBall.this.hideCBar.contains((Player)ent)) continue;
                    GadgetDiscoBall.this.hideCBar.add((Player)ent);
                }
                ++this.times;
            }
        };
        runnable.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 10L);
        this.activated = true;
    }

    @Override
    public void onUpdate() {
        if (this.activated) {
            Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                if (!this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(this.getPlayer()).getCurrentGadget().getType() != this.getType() || !this.activated) {
                    return;
                }
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (this.armorStand == null) break;
                    if (!p.isOnline() || p.getWorld() != this.armorStand.getWorld() || this.positionSongPlayer.getPlayerList().contains(p)) continue;
                    this.positionSongPlayer.addPlayer(p);
                }
            });
        }
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        if (this.armorStand != null) {
            this.armorStand.remove();
        }
        this.armorStand = null;
        if (this.positionSongPlayer != null && this.positionSongPlayer.isPlaying()) {
            this.positionSongPlayer.setPlaying(false);
        }
        this.positionSongPlayer = null;
        if (DISCO_BALLS.containsKey(this)) {
            DISCO_BALLS.remove(this);
        }
        this.activated = false;
    }
}

