/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.entity.Item;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetDiamondShower
extends Gadget {
    private boolean activated = false;
    private ArrayList<Item> items = new ArrayList();

    public GadgetDiamondShower(UUID uuid) {
        super(uuid, GadgetType.DIAMOND_SHOWER);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        SoundEffect.ENTITY_HORSE_ARMOR.playSound(this.getPlayer());
        this.activated = true;
        final EnumMaterial[] materials = new EnumMaterial[]{EnumMaterial.DIAMOND, EnumMaterial.DIAMOND_BLOCK, EnumMaterial.DIAMOND_CHESTPLATE, EnumMaterial.DIAMOND_PICKAXE, EnumMaterial.DIAMOND_ORE, EnumMaterial.DIAMOND_SWORD};
        new BukkitRunnable(){
            int step = 0;

            public void run() {
                ++this.step;
                if (!GadgetDiamondShower.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetDiamondShower.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetDiamondShower.this.getPlayer()).getCurrentGadget().getType() != GadgetDiamondShower.this.getType()) {
                    this.step = 50;
                    GadgetDiamondShower.this.onClear();
                    this.cancel();
                    return;
                }
                for (Item item : GadgetDiamondShower.this.items) {
                    if (item.getTicksLived() <= 10) continue;
                    item.remove();
                }
                if (this.step <= 50) {
                    Item item = GadgetDiamondShower.this.getPlayer().getWorld().dropItem(GadgetDiamondShower.this.getPlayer().getEyeLocation(), ItemUtils.item(UUID.randomUUID().toString(), materials[GadgetsMenu.random().nextInt(materials.length)], 0));
                    item.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                    item.setVelocity(new Vector((GadgetsMenu.random().nextDouble() - 0.5) / 5.0, 0.3, (GadgetsMenu.random().nextDouble() - 0.5) / 5.0));
                    item.setPickupDelay(Integer.MAX_VALUE);
                    GadgetDiamondShower.this.items.add(item);
                } else {
                    GadgetDiamondShower.this.clearAll();
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 0L, 3L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        for (Item item : this.items) {
            item.remove();
        }
        this.items.clear();
        this.activated = false;
    }
}

