/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.GadgetType;
import com.yapzhenyie.GadgetsMenu.cosmetics.gadgets.types.Gadget;
import com.yapzhenyie.GadgetsMenu.utils.BlockUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.FireworkUtils;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.SoundEffect;
import com.yapzhenyie.GadgetsMenu.utils.items.ItemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Item;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class GadgetCreeperAstronaut
extends Gadget {
    private boolean activated = false;
    private Creeper creeper;
    private ArrayList<Item> items = new ArrayList();

    public GadgetCreeperAstronaut(UUID uuid) {
        super(uuid, GadgetType.CREEPER_ASTRONAUT);
    }

    @Override
    protected boolean checkRequirements() {
        if (this.activated) {
            this.getPlayer().sendMessage(MessageType.GADGET_IS_ACTIVATED.getFormatMessage().replace("{GADGET}", this.getType().getDisplayNameStripColor()));
            return false;
        }
        Block getblock = BlockUtil.getTargetBlock(this.getPlayer(), 5);
        if (getblock.isEmpty() || getblock.getType().equals((Object)Material.AIR)) {
            this.getPlayer().sendMessage(MessageType.TARGET_A_BLOCK.getFormatMessage());
            return false;
        }
        return true;
    }

    @Override
    public void onClick() {
        final Block getblock = BlockUtil.getTargetBlock(this.getPlayer(), 5);
        this.activated = true;
        final Creeper entityCreeper = (Creeper)getblock.getLocation().getWorld().spawn(getblock.getLocation().add(0.5, 2.0, 0.5), Creeper.class);
        entityCreeper.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
        this.creeper = entityCreeper;
        new BukkitRunnable(){
            int step = 0;

            public void run() {
                ++this.step;
                if (!GadgetCreeperAstronaut.this.getPlayer().isOnline() || GadgetsMenu.getPlayerManager(GadgetCreeperAstronaut.this.getPlayer()).getCurrentGadget() == null || GadgetsMenu.getPlayerManager(GadgetCreeperAstronaut.this.getPlayer()).getCurrentGadget().getType() != GadgetCreeperAstronaut.this.getType()) {
                    this.step = 10;
                    GadgetCreeperAstronaut.this.onClear();
                    this.cancel();
                    return;
                }
                if (this.step <= 9) {
                    ParticleEffect.SMOKE_LARGE.display(entityCreeper.getLocation(), 0.3f, 10);
                    SoundEffect.ENTITY_GENERIC_EXPLODE.playSound(getblock.getLocation());
                    entityCreeper.setVelocity(new Vector(0.0, 0.7, 0.0));
                } else {
                    FireworkUtils.displayFirework(entityCreeper.getLocation(), FireworkEffect.Type.BURST, false, false, Arrays.asList(Color.RED), Arrays.asList(Color.YELLOW));
                    EnumMaterial[] materials = new EnumMaterial[]{EnumMaterial.BONE, EnumMaterial.GUNPOWDER, EnumMaterial.TNT};
                    for (int i = 0; i <= 25; ++i) {
                        Item item = GadgetCreeperAstronaut.this.getPlayer().getWorld().dropItem(entityCreeper.getLocation(), ItemUtils.item(UUID.randomUUID().toString(), materials[GadgetsMenu.random().nextInt(materials.length)], 0));
                        item.setMetadata(GadgetsMenu.getInstance().getPluginName(), (MetadataValue)new FixedMetadataValue((Plugin)GadgetsMenu.getInstance(), (Object)true));
                        item.setVelocity(new Vector((GadgetsMenu.random().nextDouble() - 0.5) / 1.7, 0.4, (GadgetsMenu.random().nextDouble() - 0.5) / 1.7));
                        GadgetCreeperAstronaut.this.items.add(item);
                    }
                    GadgetCreeperAstronaut.this.displayStepSound(entityCreeper.getLocation(), Material.REDSTONE_BLOCK, 5);
                    if (GadgetCreeperAstronaut.this.creeper != null) {
                        GadgetCreeperAstronaut.this.creeper.remove();
                    }
                    this.cancel();
                    new BukkitRunnable(){

                        public void run() {
                            GadgetCreeperAstronaut.this.clearAll();
                        }
                    }.runTaskLater((Plugin)GadgetsMenu.getInstance(), 70L);
                }
            }
        }.runTaskTimer((Plugin)GadgetsMenu.getInstance(), 10L, 5L);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onClear() {
        this.clearAll();
        HandlerList.unregisterAll((Listener)this);
    }

    private void clearAll() {
        if (!this.items.isEmpty()) {
            for (Item item : this.items) {
                item.remove();
            }
            this.items.clear();
        }
        if (this.creeper != null) {
            this.creeper.remove();
        }
        this.creeper = null;
        this.activated = false;
    }

    private void displayStepSound(Location loc, Material material, int times) {
        for (int i = 0; i < times; ++i) {
            loc.getWorld().playEffect(loc, Effect.STEP_SOUND, (Object)material);
        }
    }
}

