/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.cloaks;

import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.types.Cloak;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.types.Firerings;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.types.Firewings;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.types.Frosty;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.types.Icewings;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.types.Mystical;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.types.Scanner;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.types.Shaman;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.types.Superhero;
import com.yapzhenyie.GadgetsMenu.cosmetics.cloaks.types.VampireWings;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.EnumMaterial;
import com.yapzhenyie.GadgetsMenu.utils.GMaterial;
import com.yapzhenyie.GadgetsMenu.utils.ParticleEffect;
import com.yapzhenyie.GadgetsMenu.utils.mysteryboxes.utils.Rarity;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.entity.Player;

public class CloakType {
    private static final List<CloakType> ENABLED = new ArrayList<CloakType>();
    private static final List<CloakType> VALUES = new ArrayList<CloakType>();
    public static final CloakType SUPERHERO = new CloakType("Superhero", "&6Superhero Cloak", new GMaterial(EnumMaterial.RED_DYE), "gadgetsmenu.cloaks.superhero", 65, Rarity.LEGENDARY, Arrays.asList("&7Straight from the comic", "&7books comes that signature", "&7red cloak!"), ParticleEffect.REDSTONE, 5L, Superhero.class);
    public static final CloakType MYSTICAL = new CloakType("Mystical", "&6Mystical Cloak", new GMaterial(EnumMaterial.BOOK), "gadgetsmenu.cloaks.mystical", 85, Rarity.LEGENDARY, Arrays.asList("&7Shrouded in mystery, this", "&7cloak is the center of", "&7numerous legends concerning", "&7its powers."), ParticleEffect.SPELL_WITCH, 2L, Mystical.class);
    public static final CloakType FIREWINGS = new CloakType("Firewings", "&6Firewings Cloak", new GMaterial(EnumMaterial.BLAZE_POWDER), "gadgetsmenu.cloaks.firewings", 72, Rarity.LEGENDARY, Arrays.asList("&7Rise from the ashes like a", "&7phoenix in this display of", "&7flames!"), ParticleEffect.FLAME, 10L, Firewings.class);
    public static final CloakType VAMPIRE_WINGS = new CloakType("Vampire Wings", "&6Vampire Wings Cloak", new GMaterial(EnumMaterial.REDSTONE), "gadgetsmenu.cloaks.vampirewings", 78, Rarity.LEGENDARY, Arrays.asList("&7Giant black and red wings", "&7extend from your back to", "&7form menacing vampire", "&7wings!"), ParticleEffect.SMOKE_NORMAL, 7L, VampireWings.class);
    public static final CloakType FROSTY = new CloakType("Frosty", "&6Frosty Cloak", new GMaterial(EnumMaterial.SNOWBALL), "gadgetsmenu.cloaks.frosty", 78, Rarity.LEGENDARY, Arrays.asList("&7The cold never bothered me", "&7anyway!"), ParticleEffect.CRIT, 2L, Frosty.class);
    public static final CloakType ICEWINGS = new CloakType("Icewings", "&6Icewings Cloak", new GMaterial(EnumMaterial.ICE), "gadgetsmenu.cloaks.icewings", 72, Rarity.LEGENDARY, Arrays.asList("&7Is it just me or is it cold", "&7here?"), ParticleEffect.REDSTONE, 7L, Icewings.class);
    public static final CloakType SHAMAN = new CloakType("Shaman", "&6Shaman Cloak", new GMaterial(EnumMaterial.BONE), "gadgetsmenu.cloaks.shaman", 85, Rarity.LEGENDARY, Arrays.asList("&7Be surrounded by a tornado,", "&7similar to Shaman's Tornado"), ParticleEffect.FIREWORKS_SPARK, 2L, Shaman.class);
    public static final CloakType FIRERINGS = new CloakType("Firerings", "&6Firerings Cloak", new GMaterial(EnumMaterial.BLAZE_ROD), "gadgetsmenu.cloaks.firerings", 50, Rarity.LEGENDARY, Arrays.asList("&7Be surrounded by flames, ", "&7maybe the way you walk is", "&7burnt to ashes."), ParticleEffect.FLAME, 1L, Firerings.class);
    public static final CloakType SCANNER = new CloakType("Scanner", "&6Scanner Cloak", new GMaterial(EnumMaterial.BEACON), "gadgetsmenu.cloaks.scanner", 65, Rarity.LEGENDARY, Arrays.asList("&7Bleep Bloop!"), ParticleEffect.CRIT_MAGIC, 1L, Scanner.class);
    private String name;
    private String displayName;
    private GMaterial material;
    private String permission;
    private int mysteryDust;
    private Rarity rarity;
    private List<String> lore;
    private ParticleEffect effect;
    private long repeatDelay;
    private Class<? extends Cloak> clazz;
    private boolean isEnable;
    private boolean canBeFound;
    private boolean purchasable;

    private CloakType(String name, String displayName, GMaterial material, String permission, int mysteryDust, Rarity rarity, List<String> lore, ParticleEffect effect, long repeatDelay, Class<? extends Cloak> clazz) {
        this.name = name;
        if (FileManager.getCloaksFile().get("Cloaks." + this.name + ".Name") == null) {
            this.displayName = displayName;
            FileManager.getCloaksFile().set("Cloaks." + this.name + ".Name", this.displayName);
        } else {
            this.displayName = FileManager.getCloaksFile().getString("Cloaks." + this.name + ".Name");
        }
        if (FileManager.getCloaksFile().get("Cloaks." + this.name + ".Material") == null) {
            this.material = material;
            FileManager.getCloaksFile().set("Cloaks." + this.name + ".Material", this.material.getCombinedMaterial());
        } else {
            this.material = new GMaterial(FileManager.getCloaksFile().getString("Cloaks." + this.name + ".Material"));
        }
        this.permission = permission;
        if (FileManager.getCloaksFile().get("Cloaks." + this.name + ".Mystery Dust") == null) {
            this.mysteryDust = mysteryDust;
            FileManager.getCloaksFile().set("Cloaks." + this.name + ".Mystery Dust", this.mysteryDust);
        } else {
            this.mysteryDust = FileManager.getCloaksFile().getInt("Cloaks." + this.name + ".Mystery Dust");
        }
        if (FileManager.getCloaksFile().get("Cloaks." + this.name + ".Rarity") == null) {
            this.rarity = rarity;
            FileManager.getCloaksFile().set("Cloaks." + this.name + ".Rarity", this.rarity.getName());
        } else {
            this.rarity = Rarity.getName(FileManager.getCloaksFile().getString("Cloaks." + this.name + ".Rarity"));
        }
        if (FileManager.getCloaksFile().get("Cloaks." + this.name + ".Enabled") == null) {
            this.isEnable = true;
            FileManager.getCloaksFile().set("Cloaks." + this.name + ".Enabled", true);
        } else {
            this.isEnable = FileManager.getCloaksFile().getBoolean("Cloaks." + this.name + ".Enabled");
        }
        if (FileManager.getCloaksFile().get("Cloaks." + this.name + ".CanBeFound") == null) {
            this.canBeFound = true;
            FileManager.getCloaksFile().set("Cloaks." + this.name + ".CanBeFound", true);
        } else {
            this.canBeFound = FileManager.getCloaksFile().getBoolean("Cloaks." + this.name + ".CanBeFound");
        }
        if (FileManager.getCloaksFile().get("Cloaks." + this.name + ".Purchasable") == null) {
            this.purchasable = true;
            FileManager.getCloaksFile().set("Cloaks." + this.name + ".Purchasable", true);
        } else {
            this.purchasable = FileManager.getCloaksFile().getBoolean("Cloaks." + this.name + ".Purchasable");
        }
        if (FileManager.getCloaksFile().get("Cloaks." + this.name + ".Lore") == null) {
            this.lore = lore;
            if (lore == null) {
                FileManager.getCloaksFile().set("Cloaks." + this.name + ".Lore", "");
            } else {
                FileManager.getCloaksFile().set("Cloaks." + this.name + ".Lore", this.lore);
            }
        } else {
            this.lore = FileManager.getCloaksFile().getStringList("Cloaks." + this.name + ".Lore");
        }
        this.effect = effect;
        this.repeatDelay = repeatDelay;
        this.clazz = clazz;
        if (!VALUES.contains(this)) {
            VALUES.add(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return ChatUtil.format(this.displayName);
    }

    public String getDisplayNameStripColor() {
        return ChatUtil.stripColor(this.displayName);
    }

    public GMaterial getMaterial() {
        return this.material;
    }

    public String getPermission() {
        return this.permission;
    }

    public int getMysteryDust() {
        return this.mysteryDust;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public ParticleEffect getEffect() {
        return this.effect;
    }

    public long getRepeatDelay() {
        return this.repeatDelay;
    }

    public Class<? extends Cloak> getClazz() {
        return this.clazz;
    }

    public boolean isEnabled() {
        return this.isEnable;
    }

    public boolean canBeFound() {
        return this.canBeFound;
    }

    public boolean isPurchasable() {
        return this.purchasable;
    }

    public static List<CloakType> enabled() {
        return ENABLED;
    }

    public static List<CloakType> values() {
        return VALUES;
    }

    public static void checkEnabled() {
        for (CloakType type : CloakType.values()) {
            if (!type.isEnabled() || ENABLED.contains(type)) continue;
            ENABLED.add(type);
        }
    }

    public Cloak equip(Player player) {
        Cloak effect = null;
        try {
            effect = this.clazz.getDeclaredConstructor(UUID.class).newInstance(player == null ? null : player.getUniqueId());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return effect;
    }

    public String toString() {
        return this.name;
    }

    public static CloakType valueOf(String name) throws NullPointerException {
        for (CloakType type : CloakType.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }
}

