/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics.banners;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.cosmetics.Category;
import com.yapzhenyie.GadgetsMenu.cosmetics.CategoryManager;
import com.yapzhenyie.GadgetsMenu.cosmetics.banners.BannerType;
import com.yapzhenyie.GadgetsMenu.player.PlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.EnumEquipType;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BannerManager {
    public static void equipBanner(Player player, BannerType type) {
        if (!type.isEnabled() || !Category.BANNERS.isEnabled()) {
            return;
        }
        if (player == null) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        if (player.getInventory().getHelmet() != null) {
            CategoryManager.removeHelmetCosmetic(player);
            if (player.getInventory().getHelmet() != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_HELMET_TO_EQUIP_BANNER.getFormatMessage())) {
                    return;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getHelmet().clone());
                        player.getInventory().setHelmet(null);
                        player.updateInventory();
                    });
                }
            }
        }
        if (pManager.getSelectedMorph() != null) {
            pManager.unequipMorph();
        }
        player.getInventory().setHelmet(type.getItemStack());
        player.updateInventory();
        pManager.setSelectedBanner(type);
    }

    public static void unequipBanner(Player player) {
        if (player == null) {
            return;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return;
        }
        if (player.getInventory().getHelmet() != null || pManager.getSelectedBanner() != null) {
            if (player.getInventory().getHelmet() != null && player.getInventory().getHelmet().getItemMeta() != null && GadgetsMenu.getNMSManager().isNBTTagEqual(player.getInventory().getHelmet(), "Category", "Banner")) {
                player.getInventory().setHelmet(null);
                player.updateInventory();
            }
            if (pManager.getSelectedBanner() != null) {
                pManager.setSelectedBanner(null);
            }
        }
    }

    public static boolean checkRequirement(Player player, BannerType type) {
        if (!type.isEnabled() || !Category.BANNERS.isEnabled()) {
            return false;
        }
        if (player == null) {
            return false;
        }
        PlayerManager pManager = GadgetsMenu.getPlayerManager(player);
        if (pManager == null) {
            return false;
        }
        if (player.getInventory().getHelmet() != null) {
            CategoryManager.removeHelmetCosmetic(player);
            if (player.getInventory().getHelmet() != null) {
                if (CategoryManager.checkEquipRequirement(player, MessageType.REMOVE_HELMET_TO_EQUIP_BANNER.getFormatMessage())) {
                    return false;
                }
                if (GadgetsMenu.getGadgetsMenuData().getEquipCosmeticItemToSlotAction() == EnumEquipType.DROP) {
                    Bukkit.getScheduler().runTask((Plugin)GadgetsMenu.getInstance(), () -> {
                        player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getHelmet().clone());
                        player.getInventory().setHelmet(null);
                        player.updateInventory();
                    });
                }
            }
        }
        return true;
    }
}

