/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.cosmetics;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.FileManager;
import com.yapzhenyie.GadgetsMenu.menu.menus.AnimatedHatsMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.BannersMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.CloaksMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.EmotesMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.GadgetCategoriesMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.HatsMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.MorphsMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.ParticlesMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.PetCategoriesMenu;
import com.yapzhenyie.GadgetsMenu.menu.menus.SuitsMenu;
import com.yapzhenyie.GadgetsMenu.utils.ChatUtil;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.Player;

public enum Category {
    HATS("Hats", "Hats", Arrays.asList("Selected_Hat"), MessageType.HATS_ARE_DISABLED, HatsMenu.class),
    ANIMATED_HATS("Animated Hats", "Animated Hats", Arrays.asList("Selected_Animated_Hat"), MessageType.ANIMATED_HATS_ARE_DISABLED, AnimatedHatsMenu.class),
    PARTICLES("Particles", "Particles", Arrays.asList("Selected_Particle"), MessageType.PARTICLES_ARE_DISABLED, ParticlesMenu.class),
    SUITS("Suits", "Suits", Arrays.asList("Selected_Suit_Helmet", "Selected_Suit_Chestplate", "Selected_Suit_Leggings", "Selected_Suit_Boots"), MessageType.SUITS_ARE_DISABLED, SuitsMenu.class),
    GADGETS("Gadgets", "Gadgets", Arrays.asList("Selected_Gadget"), MessageType.GADGETS_ARE_DISABLED, GadgetCategoriesMenu.class),
    PETS("Pets", "Pets", Arrays.asList("Selected_Pet"), MessageType.PETS_ARE_DISABLED, PetCategoriesMenu.class),
    MORPHS("Morphs", "Morphs", Arrays.asList("Selected_Morph"), MessageType.MORPHS_ARE_DISABLED, MorphsMenu.class),
    BANNERS("Banners", "Banners", Arrays.asList("Selected_Banner"), MessageType.BANNERS_ARE_DISABLED, BannersMenu.class),
    EMOTES("Emotes", "Emotes", Arrays.asList("Selected_Emote"), MessageType.EMOTES_ARE_DISABLED, EmotesMenu.class),
    CLOAKS("Cloaks", "Cloaks", Arrays.asList("Selected_Cloak"), MessageType.CLOAKS_ARE_DISABLED, CloaksMenu.class);

    private String name;
    private String guiName;
    private List<String> mysqlIndex;
    private boolean isEnabled;
    private boolean isPurchasable;
    private boolean canBeFound;
    private MessageType disabledMessage;
    private Class<?> clazz;

    private Category(String name, String guiName, List<String> mysqlIndex, MessageType disabledMessage, Class<?> clazz) {
        this.name = name;
        this.guiName = guiName;
        if (FileManager.getMessagesFile().get("GUI-Menus." + this.name) == null) {
            this.guiName = guiName;
            FileManager.getMessagesFile().addDefault("GUI-Menus." + this.name, guiName);
        } else {
            this.guiName = FileManager.getMessagesFile().getString("GUI-Menus." + this.name);
        }
        this.mysqlIndex = mysqlIndex;
        if (FileManager.getConfigFile().get("Disabled-Cosmetics." + this.name) == null) {
            this.isEnabled = true;
            FileManager.getConfigFile().addDefault("Disabled-Cosmetics." + this.name, false);
        } else {
            boolean bl = this.isEnabled = !FileManager.getConfigFile().getBoolean("Disabled-Cosmetics." + this.name);
        }
        if (!GadgetsMenu.getGadgetsMenuData().isCosmeticItemPurchasable()) {
            this.isPurchasable = false;
        } else if (FileManager.getConfigFile().get("Cosmetic-Item-Purchase.Enabled-Cosmetics." + this.name) == null) {
            this.isPurchasable = true;
            FileManager.getConfigFile().addDefault("Cosmetic-Item-Purchase.Enabled-Cosmetics." + this.name, true);
        } else {
            this.isPurchasable = FileManager.getConfigFile().getBoolean("Cosmetic-Item-Purchase.Enabled-Cosmetics." + this.name);
        }
        if (!GadgetsMenu.getGadgetsMenuData().isMysteryBoxesEnabled()) {
            this.canBeFound = false;
        } else if (FileManager.getMysteryBoxesFile().get("Mystery-Boxes.Loots-Can-Be-Found." + this.name) == null) {
            this.canBeFound = true;
            FileManager.getMysteryBoxesFile().addDefault("Mystery-Boxes.Loots-Can-Be-Found." + this.name, true);
        } else {
            this.canBeFound = FileManager.getMysteryBoxesFile().getBoolean("Mystery-Boxes.Loots-Can-Be-Found." + this.name);
        }
        this.disabledMessage = disabledMessage;
        this.clazz = clazz;
        if (this.name.equals("Morphs") && !GadgetsMenu.getGadgetsMenuData().isLibsDisguiseEnabled() && !GadgetsMenu.getGadgetsMenuData().isIDisguiseEnabled()) {
            this.isEnabled = false;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getGUIName() {
        return ChatUtil.format(this.guiName);
    }

    public List<String> getMySQLIndex() {
        return this.mysqlIndex;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean isPurchasable() {
        return this.isPurchasable;
    }

    public boolean canBeFound() {
        return this.canBeFound;
    }

    public void openMenu(Player player, int page) {
        if (player == null) {
            return;
        }
        try {
            if (this == SUITS || this == MORPHS || this == CLOAKS) {
                this.clazz.getMethod("open" + this.name + "Menu", Player.class).invoke(this.clazz, player);
            } else if (this == GADGETS || this == PETS) {
                this.clazz.getMethod("openCategory" + this.name + "Menu", Player.class).invoke(this.clazz, player);
            } else {
                this.clazz.getMethod("open" + this.name.replace(" ", "") + "Menu", Player.class, Integer.TYPE).invoke(this.clazz, player, page);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    public MessageType getDisabledMessage() {
        return this.disabledMessage;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String toString() {
        return this.getName();
    }

    public static Category valueOfByName(String name) throws NullPointerException {
        for (Category type : Category.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    public static List<String> getMySQLIndexes() {
        ArrayList<String> indexes = new ArrayList<String>();
        for (Category c : Category.values()) {
            indexes.addAll(c.getMySQLIndex());
        }
        return indexes;
    }
}

