/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.configuration;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.configuration.CustomConfiguration;
import com.yapzhenyie.GadgetsMenu.log.LoggerManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class FileManager {
    public File file = null;
    public FileConfiguration fileConfiguration;
    private static FileManager messages = new FileManager("messages");
    private static FileManager mainMenu = new FileManager("/categories/mainmenu");
    private static FileManager hats = new FileManager("/categories/hats");
    private static FileManager animatedHats = new FileManager("/categories/animated hats");
    private static FileManager particles = new FileManager("/categories/particles");
    private static FileManager suits = new FileManager("/categories/suits");
    private static FileManager gadgets = new FileManager("/categories/gadgets");
    private static FileManager pets = new FileManager("/categories/pets");
    private static FileManager morphs = new FileManager("/categories/morphs");
    private static FileManager banners = new FileManager("/categories/banners");
    private static FileManager emotes = new FileManager("/categories/emotes");
    private static FileManager cloaks = new FileManager("/categories/cloaks");
    private static FileManager customHats = new FileManager("/custom cosmetics/custom hats");
    private static FileManager customAnimatedHats = new FileManager("/custom cosmetics/custom animated hats");
    private static FileManager customParticles = new FileManager("/custom cosmetics/custom particles");
    private static FileManager customBanners = new FileManager("/custom cosmetics/custom banners");
    private static FileManager customEmotes = new FileManager("/custom cosmetics/custom emotes");
    private static FileManager mysteryBoxes = new FileManager("mystery boxes/mystery boxes");
    private static FileManager animations = new FileManager("mystery boxes/animations");
    private static FileManager mysteryVault = new FileManager("/mystery vaults");

    private FileManager(String fileName) {
        File mysteryboxes;
        File customCosmetics;
        File cosmetics;
        if (!GadgetsMenu.getInstance().getDataFolder().exists()) {
            GadgetsMenu.getInstance().getDataFolder().mkdir();
        }
        if (!(cosmetics = new File(GadgetsMenu.getInstance().getDataFolder(), "/categories")).exists()) {
            cosmetics.mkdirs();
        }
        if (!(customCosmetics = new File(GadgetsMenu.getInstance().getDataFolder(), "/custom cosmetics")).exists()) {
            customCosmetics.mkdirs();
        }
        if (!(mysteryboxes = new File(GadgetsMenu.getInstance().getDataFolder(), "/mystery boxes")).exists()) {
            mysteryboxes.mkdirs();
        }
        this.file = new File(GadgetsMenu.getInstance().getDataFolder(), fileName + ".yml");
        this.fileConfiguration = FileManager.loadConfiguration(this.file);
    }

    public static CustomConfiguration getConfigFile() {
        return GadgetsMenu.getInstance().getConfig();
    }

    public static FileManager getMessagesFile() {
        return messages;
    }

    public static FileManager getMainMenuFile() {
        return mainMenu;
    }

    public static FileManager getHatsFile() {
        return hats;
    }

    public static FileManager getAnimatedHatsFile() {
        return animatedHats;
    }

    public static FileManager getParticlesFile() {
        return particles;
    }

    public static FileManager getSuitsFile() {
        return suits;
    }

    public static FileManager getGadgetsFile() {
        return gadgets;
    }

    public static FileManager getPetsFile() {
        return pets;
    }

    public static FileManager getMorphsFile() {
        return morphs;
    }

    public static FileManager getBannersFile() {
        return banners;
    }

    public static FileManager getEmotesFile() {
        return emotes;
    }

    public static FileManager getCloaksFile() {
        return cloaks;
    }

    public static FileManager getCustomHatsFile() {
        return customHats;
    }

    public static FileManager getCustomAnimatedHatsFile() {
        return customAnimatedHats;
    }

    public static FileManager getCustomParticlesFile() {
        return customParticles;
    }

    public static FileManager getCustomBannersFile() {
        return customBanners;
    }

    public static FileManager getCustomEmotesFile() {
        return customEmotes;
    }

    public static FileManager getMysteryBoxesFile() {
        return mysteryBoxes;
    }

    public static FileManager getAnimationsFile() {
        return animations;
    }

    public static FileManager getMysteryVaultFile() {
        return mysteryVault;
    }

    public void set(String path, Object value) {
        this.createFile();
        if (path == null) {
            return;
        }
        this.fileConfiguration.set(path, value);
        try {
            this.createFile();
            this.fileConfiguration.save(this.file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addDefault(String path, Object value) {
        this.createFile();
        if (path == null) {
            return;
        }
        if (!this.fileConfiguration.contains(path)) {
            this.set(path, value);
        }
    }

    public boolean contains(String value) {
        this.createFile();
        return this.fileConfiguration.contains(value);
    }

    public <T> T get(String path) {
        this.createFile();
        return (T)this.fileConfiguration.get(path);
    }

    public Object get(String path, Object value) {
        this.createFile();
        return this.fileConfiguration.get(path, value);
    }

    public FileConfiguration getFile() {
        this.createFile();
        return this.fileConfiguration;
    }

    public String getString(String path) {
        this.createFile();
        return this.fileConfiguration.getString(path);
    }

    public List<String> getStringList(String path) {
        this.createFile();
        return this.fileConfiguration.getStringList(path);
    }

    public int getInt(String path) {
        this.createFile();
        return this.fileConfiguration.getInt(path);
    }

    public boolean getBoolean(String path) {
        this.createFile();
        return this.fileConfiguration.getBoolean(path);
    }

    public double getDouble(String path) {
        this.createFile();
        return this.fileConfiguration.getDouble(path);
    }

    public Set<String> getKeys(boolean arg0) {
        this.createFile();
        return this.fileConfiguration.getKeys(arg0);
    }

    public ConfigurationSection getConfigurationSection(String arg0) {
        this.createFile();
        return this.fileConfiguration.getConfigurationSection(arg0);
    }

    public ConfigurationSection createSection(String arg0) {
        this.createFile();
        ConfigurationSection section = this.fileConfiguration.createSection(arg0);
        this.save();
        return section;
    }

    public void save() {
        try {
            this.createFile();
            this.fileConfiguration.save(this.file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reload() {
        try {
            this.createFile();
            this.fileConfiguration = FileManager.loadConfiguration(this.file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createFile() {
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void deleteFile() {
        if (this.file.exists()) {
            try {
                this.file.delete();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static FileConfiguration loadConfiguration(File file) {
        Validate.notNull((Object)file, (String)"File cannot be null");
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            LoggerManager.printLog(LoggerManager.LogLevel.SEVERE, "Cannot load " + file, e);
            return null;
        }
        catch (InvalidConfigurationException e) {
            File broken = new File(file.getAbsolutePath().replace(".yml", "") + ".broken." + System.currentTimeMillis() + ".yml");
            file.renameTo(broken);
            LoggerManager.printLog(LoggerManager.LogLevel.SEVERE, "The file " + file.getName() + " is broken, it has been renamed to " + broken.getName(), e.getCause());
            return null;
        }
        return config;
    }
}

