/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.command.mysterydust.subcommands;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.command.mysterydust.CommandManager;
import com.yapzhenyie.GadgetsMenu.command.mysterydust.SubCommand;
import com.yapzhenyie.GadgetsMenu.player.OfflinePlayerManager;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CommandAddMysteryDust
extends SubCommand {
    public CommandAddMysteryDust() {
        super("/mysterydust add <all|player> <amount>", "Add mystery dust to a player.", "Add mystery dust to a player.\n\n&7End with the command 'msg=false', won't send\n&7message to the player when they receive\n&7mystery dust.", "gadgetsmenu.mysterydust.add", new String[]{"add", "give"}, true);
    }

    @Override
    protected void onCommandPlayer(Player sender, String[] args) {
        this.onCommand((CommandSender)sender, args);
    }

    @Override
    protected void onOtherCommandSender(CommandSender sender, String[] args) {
        this.onCommand(sender, args);
    }

    private void onCommand(CommandSender sender, String[] args) {
        if (args.length != 3 && args.length != 4) {
            CommandManager.printMessage(sender, this);
            return;
        }
        Player target = sender.getServer().getPlayer(args[1]);
        if (args[1].equalsIgnoreCase("all")) {
            target = null;
        }
        if (target == null && !args[1].equalsIgnoreCase("all")) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)GadgetsMenu.getInstance(), () -> this.offlinePlayerCommand(sender, args));
        } else {
            try {
                Integer.parseInt(args[2]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(MessageType.REQUIRED_NUMBER_FORMAT.getFormatMessage());
                return;
            }
            int mysteryDust = Integer.parseInt(args[2]);
            if (mysteryDust <= 0) {
                sender.sendMessage(MessageType.REQUIRED_POSITIVE_NUMBER.getFormatMessage());
                return;
            }
            if (target == null) {
                int size = 0;
                for (Player players : Bukkit.getOnlinePlayers()) {
                    if (!players.isOnline()) continue;
                    GadgetsMenu.getPlayerManager(players).addMysteryDust(mysteryDust);
                    if (args.length == 4) {
                        if (!args[3].equalsIgnoreCase("msg=false")) {
                            players.sendMessage(MessageType.PLAYER_RECEIVED_MYSTERY_DUST.getFormatMessage().replace("{MYSTERY_DUST}", String.valueOf(mysteryDust)).replace("{PLAYER}", sender.getName()));
                        }
                    } else {
                        players.sendMessage(MessageType.PLAYER_RECEIVED_MYSTERY_DUST.getFormatMessage().replace("{MYSTERY_DUST}", String.valueOf(mysteryDust)).replace("{PLAYER}", sender.getName()));
                    }
                    ++size;
                }
                sender.sendMessage(MessageType.PLAYER_ADDED_MYSTERY_DUST_TO_ONLINE_PLAYERS.getFormatMessage().replace("{MYSTERY_DUST}", String.valueOf(mysteryDust)).replace("{ONLINE}", String.valueOf(size)));
            } else {
                GadgetsMenu.getPlayerManager(target).addMysteryDust(mysteryDust);
                if (args.length == 4) {
                    if (!args[3].equalsIgnoreCase("msg=false")) {
                        target.sendMessage(MessageType.PLAYER_RECEIVED_MYSTERY_DUST.getFormatMessage().replace("{MYSTERY_DUST}", String.valueOf(mysteryDust)).replace("{PLAYER}", sender.getName()));
                    }
                } else {
                    target.sendMessage(MessageType.PLAYER_RECEIVED_MYSTERY_DUST.getFormatMessage().replace("{MYSTERY_DUST}", String.valueOf(mysteryDust)).replace("{PLAYER}", sender.getName()));
                }
                sender.sendMessage(MessageType.PLAYER_ADDED_MYSTERY_DUST.getFormatMessage().replace("{MYSTERY_DUST}", String.valueOf(mysteryDust)).replace("{PLAYER}", target.getName()));
            }
        }
    }

    private boolean offlinePlayerCommand(CommandSender sender, String[] args) {
        OfflinePlayerManager oPlayerManager = null;
        if (sender.getServer().getPlayer(args[1]) == null) {
            OfflinePlayer oPlayer = Bukkit.getOfflinePlayer((String)args[1]);
            if (!GadgetsMenu.getDatabaseManager().getDatabaseUtils().isExist(oPlayer)) {
                sender.sendMessage(MessageType.PLAYER_NOT_FOUND.getFormatMessage());
                return false;
            }
            oPlayerManager = new OfflinePlayerManager(oPlayer.getUniqueId());
        }
        try {
            Integer.parseInt(args[2]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(MessageType.REQUIRED_NUMBER_FORMAT.getFormatMessage());
            return false;
        }
        int mysteryDust = Integer.parseInt(args[2]);
        if (mysteryDust <= 0) {
            sender.sendMessage(MessageType.REQUIRED_POSITIVE_NUMBER.getFormatMessage());
            return false;
        }
        oPlayerManager.addMysteryDust(mysteryDust);
        sender.sendMessage(MessageType.PLAYER_ADDED_MYSTERY_DUST.getFormatMessage().replace("{MYSTERY_DUST}", String.valueOf(mysteryDust)).replace("{PLAYER}", oPlayerManager.getName()));
        return true;
    }
}

