/*
 * Decompiled with CFR 0.152.
 */
package com.yapzhenyie.GadgetsMenu.command.mysteryboxes.subcommand;

import com.yapzhenyie.GadgetsMenu.GadgetsMenu;
import com.yapzhenyie.GadgetsMenu.command.mysteryboxes.CommandManager;
import com.yapzhenyie.GadgetsMenu.command.mysteryboxes.SubCommand;
import com.yapzhenyie.GadgetsMenu.utils.MessageType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandGift
extends SubCommand {
    public CommandGift() {
        super("/gmysteryboxes gift <player> <pack>", "Give mystery gifts to a player.", "Give mystery gifts to a player.\n&7Each pack contains 5 mystery boxes.\n\n&7End with the command 'msg=false', won't send\n&7message to the player when they receive\n&7mystery gifts.", "gadgetsmenu.mysteryboxes.gift", new String[]{"gift"}, true);
    }

    @Override
    protected void onCommandPlayer(Player sender, String[] args) {
        this.onCommand((CommandSender)sender, args);
    }

    @Override
    protected void onOtherCommandSender(CommandSender sender, String[] args) {
        this.onCommand(sender, args);
    }

    private void onCommand(CommandSender sender, String[] args) {
        int pack;
        if (args.length < 3 || args.length > 4) {
            CommandManager.printMessage(sender, this);
            return;
        }
        Player target = sender.getServer().getPlayer(args[1]);
        if (target == null || !target.isOnline()) {
            sender.sendMessage(MessageType.PLAYER_NOT_FOUND.getFormatMessage());
            return;
        }
        try {
            pack = Integer.parseInt(args[2]);
        }
        catch (NumberFormatException ex) {
            sender.sendMessage(MessageType.REQUIRED_NUMBER_FORMAT.getFormatMessage());
            return;
        }
        if (pack <= 0) {
            sender.sendMessage(MessageType.REQUIRED_POSITIVE_NUMBER.getFormatMessage());
            return;
        }
        boolean msg = true;
        if (args.length == 4 && args[3].startsWith("msg=") && args[3].equalsIgnoreCase("msg=false")) {
            msg = false;
        }
        GadgetsMenu.getPlayerManager(target).addGiftPacks(pack);
        sender.sendMessage(MessageType.PLAYER_GAVE_MYSTERY_GIFTS.getFormatMessage().replace("{GIFTS}", String.valueOf(pack)).replace("{PLAYER}", target.getName()));
        if (msg && target != sender) {
            target.sendMessage(MessageType.PLAYER_RECEIVED_MYSTERY_GIFTS.getFormatMessage().replace("{GIFTS}", String.valueOf(pack)).replace("{PLAYER}", sender.getName()));
        }
    }
}

