/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.papi.expansion.player;

import com.google.common.primitives.Ints;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public final class VersionHelper {
    private static final int VERSION = VersionHelper.getCurrentVersion();
    public static final boolean HAS_ABSORPTION_METHODS = VERSION >= 1150;
    public static final boolean IS_1_17_OR_NEWER = VERSION >= 1170;

    private VersionHelper() {
    }

    private static int getCurrentVersion() {
        Integer version;
        Matcher matcher = Pattern.compile("(?<version>\\d+\\.\\d+)(?<patch>\\.\\d+)?").matcher(Bukkit.getBukkitVersion());
        StringBuilder stringBuilder = new StringBuilder();
        if (matcher.find()) {
            String patch = matcher.group("patch");
            stringBuilder.append(matcher.group("version").replace(".", "")).append(patch == null ? "0" : patch.replace(".", ""));
        }
        if ((version = Ints.tryParse((String)stringBuilder.toString())) == null) {
            throw new IllegalArgumentException("Could not retrieve server version!");
        }
        return version;
    }
}

