/*
 * Decompiled with CFR 0.152.
 */
package clib.net.kyori.adventure.text.minimessage.tag.standard;

import clib.net.kyori.adventure.key.InvalidKeyException;
import clib.net.kyori.adventure.key.Key;
import clib.net.kyori.adventure.text.format.Style;
import clib.net.kyori.adventure.text.minimessage.Context;
import clib.net.kyori.adventure.text.minimessage.ParsingException;
import clib.net.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import clib.net.kyori.adventure.text.minimessage.internal.serializer.StyleClaim;
import clib.net.kyori.adventure.text.minimessage.internal.serializer.TokenEmitter;
import clib.net.kyori.adventure.text.minimessage.tag.Tag;
import clib.net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import clib.net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

final class FontTag {
    static final String FONT = "font";
    static final TagResolver RESOLVER = SerializableResolver.claimingStyle("font", FontTag::create, StyleClaim.claim("font", Style::font, FontTag::emit));

    private FontTag() {
    }

    static Tag create(ArgumentQueue args, Context ctx) throws ParsingException {
        Key font;
        String valueOrNamespace = args.popOr("A font tag must have either arguments of either <value> or <namespace:value>").value();
        try {
            if (!args.hasNext()) {
                font = Key.key((String)valueOrNamespace);
            } else {
                String fontKey = args.pop().value();
                font = Key.key((String)valueOrNamespace, (String)fontKey);
            }
        }
        catch (InvalidKeyException ex) {
            throw ctx.newException(ex.getMessage(), args);
        }
        return Tag.styling(builder -> builder.font(font));
    }

    static void emit(Key font, TokenEmitter emitter) {
        emitter.tag(FONT);
        if (font.namespace().equals("minecraft")) {
            emitter.argument(font.value());
        } else {
            emitter.arguments(font.namespace(), font.value());
        }
    }
}

