/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v16hd;

import ch.ethz.globis.phtree.PhDistance;
import ch.ethz.globis.phtree.PhDistanceL;
import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.PhFilterDistance;
import ch.ethz.globis.phtree.PhFilterWindow;
import ch.ethz.globis.phtree.PhRangeQuery;
import ch.ethz.globis.phtree.PhTree;
import ch.ethz.globis.phtree.PhTreeConfig;
import ch.ethz.globis.phtree.PhTreeHelper;
import ch.ethz.globis.phtree.PhTreeHelperHD;
import ch.ethz.globis.phtree.util.PhMapper;
import ch.ethz.globis.phtree.util.PhTreeStats;
import ch.ethz.globis.phtree.util.StringBuilderLn;
import ch.ethz.globis.phtree.util.unsynced.LongArrayPool;
import ch.ethz.globis.phtree.util.unsynced.ObjectPool;
import ch.ethz.globis.phtree.v16hd.Bits;
import ch.ethz.globis.phtree.v16hd.BitsHD;
import ch.ethz.globis.phtree.v16hd.Node;
import ch.ethz.globis.phtree.v16hd.NodeIteratorListReuse;
import ch.ethz.globis.phtree.v16hd.PhIteratorFullNoGC;
import ch.ethz.globis.phtree.v16hd.PhIteratorNoGC;
import ch.ethz.globis.phtree.v16hd.PhQueryKnnHS;
import ch.ethz.globis.phtree.v16hd.PhResultList;
import ch.ethz.globis.phtree.v16hd.bst.BSTIteratorAll;
import ch.ethz.globis.phtree.v16hd.bst.BSTPool;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PhTree16HD<T>
implements PhTree<T> {
    public static final boolean HCI_ENABLED = true;
    static final int DEPTH_64 = 64;
    private static final int NO_INSERT_REQUIRED = Integer.MAX_VALUE;
    private final int maxLeafN;
    private final int maxInnerN;
    private final int dims;
    private int nEntries;
    private Node root = null;
    private final ObjectPool<Node> nodePool;
    private final ObjectPool<UpdateInfo> uiPool;
    private final LongArrayPool bitPool;
    private final BSTPool bstPool;

    Node getRoot() {
        return this.root;
    }

    public PhTree16HD(int dim) {
        this.dims = dim;
        this.nodePool = ObjectPool.create(Node::new);
        this.uiPool = ObjectPool.create(UpdateInfo::new);
        this.bitPool = LongArrayPool.create();
        this.bstPool = BSTPool.create();
        PhTreeHelper.debugCheck();
        switch (this.dims) {
            case 1: {
                this.maxLeafN = 2;
                this.maxInnerN = 2;
                break;
            }
            case 2: {
                this.maxLeafN = 4;
                this.maxInnerN = 2;
                break;
            }
            case 3: {
                this.maxLeafN = 8;
                this.maxInnerN = 2;
                break;
            }
            case 4: {
                this.maxLeafN = 16;
                this.maxInnerN = 2;
                break;
            }
            case 5: {
                this.maxLeafN = 16;
                this.maxInnerN = 3;
                break;
            }
            case 6: {
                this.maxLeafN = 16;
                this.maxInnerN = 5;
                break;
            }
            case 7: {
                this.maxLeafN = 16;
                this.maxInnerN = 9;
                break;
            }
            case 8: {
                this.maxLeafN = 16;
                this.maxInnerN = 17;
                break;
            }
            case 9: {
                this.maxLeafN = 32;
                this.maxInnerN = 17;
                break;
            }
            case 10: {
                this.maxLeafN = 32;
                this.maxInnerN = 33;
                break;
            }
            case 11: {
                this.maxLeafN = 32;
                this.maxInnerN = 65;
                break;
            }
            case 12: {
                this.maxLeafN = 64;
                this.maxInnerN = 65;
                break;
            }
            default: {
                this.maxLeafN = 100;
                this.maxInnerN = 100;
            }
        }
    }

    public PhTree16HD(PhTreeConfig cnf) {
        this(cnf.getDimActual());
        if (cnf.getConcurrencyType() != 0) {
            throw new UnsupportedOperationException("type= " + cnf.getConcurrencyType());
        }
    }

    void increaseNrEntries() {
        ++this.nEntries;
    }

    void decreaseNrEntries() {
        --this.nEntries;
    }

    @Override
    public int size() {
        return this.nEntries;
    }

    @Override
    public PhTreeStats getStats() {
        return this.getStats(0, this.getRoot(), new PhTreeStats(64));
    }

    private PhTreeStats getStats(int currentDepth, Node node, PhTreeStats stats) {
        ++stats.nNodes;
        int n = node.getInfixLen();
        stats.infixHist[n] = stats.infixHist[n] + 1;
        int n2 = currentDepth;
        stats.nodeDepthHist[n2] = stats.nodeDepthHist[n2] + 1;
        int size = node.getEntryCount();
        int n3 = 32 - Integer.numberOfLeadingZeros(size);
        stats.nodeSizeLogHist[n3] = stats.nodeSizeLogHist[n3] + 1;
        stats.q_totalDepth += (currentDepth += node.getInfixLen());
        ArrayList<Node.BSTEntry> entries = new ArrayList<Node.BSTEntry>();
        node.getStats(stats, entries);
        for (Node.BSTEntry child : entries) {
            if (child.getValue() instanceof Node) {
                Node sub = (Node)child.getValue();
                if (sub.getInfixLen() + 1 + sub.getPostLen() != node.getPostLen()) {
                    throw new IllegalStateException();
                }
                this.getStats(currentDepth + 1, sub, stats);
                continue;
            }
            int n4 = currentDepth;
            stats.q_nPostFixN[n4] = stats.q_nPostFixN[n4] + 1;
        }
        if (entries.size() != node.getEntryCount()) {
            System.err.println("WARNING: entry count mismatch: a-found/ec=" + entries.size() + "/" + node.getEntryCount());
        }
        int REF = 4;
        stats.size += (long)PhTreeHelper.align8(31);
        int nChildren = node.getEntryCount();
        stats.size += 16L;
        if (nChildren == 1 && node != this.getRoot() && this.nEntries > 1) {
            System.err.println("WARNING: found lonely node...");
        }
        if (nChildren == 0 && node != this.getRoot()) {
            System.err.println("WARNING: found ZOMBIE node...");
        }
        if (this.dims <= 31 && (long)node.getEntryCount() > 1L << this.dims) {
            System.err.println("WARNING: Over-populated node found: ec=" + node.getEntryCount());
        }
        stats.nTotalChildren += nChildren;
        return stats;
    }

    @Override
    public T put(long[] key, T value) {
        Object nonNullValue;
        long[] hcBuf = BitsHD.newArray(this.dims);
        Object object = nonNullValue = value == null ? PhTreeHelper.NULL : value;
        if (this.getRoot() == null) {
            this.insertRoot(key, nonNullValue, hcBuf);
            return null;
        }
        Object o = this.getRoot();
        while (o instanceof Node) {
            Node currentNode = o;
            o = currentNode.doInsertIfMatching(key, nonNullValue, this, hcBuf);
        }
        return (T)o;
    }

    private void insertRoot(long[] key, Object value, long[] hcBuf) {
        this.root = Node.createNode(this.dims, 0, 63, this);
        PhTreeHelperHD.posInArrayHD(key, this.root.getPostLen(), hcBuf);
        this.root.addEntry(hcBuf, key, value, this);
        this.increaseNrEntries();
    }

    @Override
    public boolean contains(long ... key) {
        long[] hcBuf = BitsHD.newArray(this.dims);
        Object o = this.getRoot();
        while (o instanceof Node) {
            Node currentNode = o;
            o = currentNode.doIfMatching(key, true, null, null, this, hcBuf);
        }
        return o != null;
    }

    @Override
    public T get(long ... key) {
        long[] hcBuf = BitsHD.newArray(this.dims);
        Object o = this.getRoot();
        while (o instanceof Node) {
            Node currentNode = o;
            o = currentNode.doIfMatching(key, true, null, null, this, hcBuf);
        }
        return (T)(o == PhTreeHelper.NULL ? null : o);
    }

    @Override
    public T remove(long ... key) {
        long[] hcBuf = BitsHD.newArray(this.dims);
        Object o = this.getRoot();
        Node parentNode = null;
        while (o instanceof Node) {
            Node currentNode = o;
            o = currentNode.doIfMatching(key, false, parentNode, null, this, hcBuf);
            parentNode = currentNode;
        }
        return (T)o;
    }

    @Override
    public T update(long[] oldKey, long[] newKey) {
        Node value;
        long[] hcBuf = BitsHD.newArray(this.dims);
        Node[] stack = new Node[64];
        int stackSize = 0;
        Object o = this.getRoot();
        Node parentNode = null;
        UpdateInfo ui = this.uiPool.get().init(newKey);
        while (o instanceof Node) {
            Node currentNode = o;
            stack[stackSize++] = currentNode;
            o = currentNode.doIfMatching(oldKey, false, parentNode, ui, this, hcBuf);
            parentNode = currentNode;
        }
        Node node = value = o == PhTreeHelper.NULL ? null : o;
        if (ui.insertRequired != Integer.MAX_VALUE) {
            if (stack[stackSize - 1].getEntryCount() == 0 && stackSize > 1) {
                --stackSize;
            }
            while (stackSize > 0) {
                if (stack[--stackSize].getPostLen() + 1 < ui.insertRequired) continue;
                o = stack[stackSize];
                while (o instanceof Node) {
                    Node currentNode = (Node)o;
                    o = currentNode.doInsertIfMatching(newKey, value, this, hcBuf);
                }
                ui.insertRequired = Integer.MAX_VALUE;
                break;
            }
        }
        this.uiPool.offer(ui);
        return (T)value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " HCI-on=" + true + " BstSize=" + this.maxInnerN + "/" + this.maxLeafN + " DEBUG=" + false;
    }

    @Override
    public String toStringPlain() {
        StringBuilderLn sb = new StringBuilderLn();
        if (this.getRoot() != null) {
            this.toStringPlain(sb, this.getRoot());
        }
        return sb.toString();
    }

    private void toStringPlain(StringBuilderLn sb, Node node) {
        BSTIteratorAll iter = node.iterator();
        while (iter.hasNextEntry()) {
            Node.BSTEntry o = iter.nextEntry();
            if (o.getValue() instanceof Node) {
                this.toStringPlain(sb, (Node)o.getValue());
                continue;
            }
            sb.append(Bits.toBinary(o.getKdKey(), 64));
            sb.appendLn("  v=" + o.getValue());
        }
    }

    @Override
    public String toStringTree() {
        StringBuilderLn sb = new StringBuilderLn();
        if (this.getRoot() != null) {
            this.toStringTree(sb, 0, this.getRoot(), new long[this.dims], true);
        }
        return sb.toString();
    }

    private void toStringTree(StringBuilderLn sb, int currentDepth, Node node, long[] prefix, boolean printValue) {
        String ind = "*";
        for (int i = 0; i < currentDepth; ++i) {
            ind = ind + "-";
        }
        sb.append(ind + "il=" + node.getInfixLen() + " pl=" + node.getPostLen() + " ec=" + node.getEntryCount() + " inf=[");
        if (node.getInfixLen() > 0) {
            long mask = -1L << node.getInfixLen();
            mask ^= 0xFFFFFFFFFFFFFFFFL;
            mask <<= node.getPostLen() + 1;
            for (int i = 0; i < this.dims; ++i) {
                sb.append(Bits.toBinary(prefix[i] & mask) + ",");
            }
        }
        currentDepth += node.getInfixLen();
        sb.appendLn("]  " + node);
        BSTIteratorAll iter = node.iterator();
        while (iter.hasNextEntry()) {
            Node.BSTEntry o = iter.nextEntry();
            if (o.getValue() instanceof Node) {
                sb.appendLn(ind + "# " + Arrays.toString(o.getKey()) + "  +");
                this.toStringTree(sb, currentDepth + 1, (Node)o.getValue(), o.getKdKey(), printValue);
                continue;
            }
            sb.append(ind + Bits.toBinary(o.getKdKey(), 64));
            sb.append("  hcPos=" + Arrays.toString(o.getKey()));
            if (printValue) {
                sb.append("  v=" + o.getValue());
            }
            sb.appendLn("");
        }
    }

    @Override
    public PhTree.PhExtent<T> queryExtent() {
        return new PhIteratorFullNoGC(this, null).reset();
    }

    @Override
    public PhTree.PhQuery<T> query(long[] min, long[] max) {
        if (min.length != this.dims || max.length != this.dims) {
            throw new IllegalArgumentException("Invalid number of arguments: " + min.length + " / " + max.length + "  DIM=" + this.dims);
        }
        PhIteratorNoGC q = new PhIteratorNoGC(this, null);
        q.reset(min, max);
        return q;
    }

    @Override
    public PhTree.PhQuery<T> query(long[] min, long[] max, PhFilter filter) {
        if (min.length != this.dims || max.length != this.dims) {
            throw new IllegalArgumentException("Invalid number of arguments: " + min.length + " / " + max.length + "  DIM=" + this.dims);
        }
        PhIteratorNoGC q = new PhIteratorNoGC(this, filter);
        q.reset(min, max);
        return q;
    }

    @Override
    public List<PhEntry<T>> queryAll(long[] min, long[] max) {
        return this.queryAll(min, max, Integer.MAX_VALUE, null, PhMapper.PVENTRY());
    }

    @Override
    public <R> List<R> queryAll(long[] min, long[] max, int maxResults, PhFilter filter, PhMapper<T, R> mapper) {
        if (min.length != this.dims || max.length != this.dims) {
            throw new IllegalArgumentException("Invalid number of arguments: " + min.length + " / " + max.length + "  DIM=" + this.dims);
        }
        if (this.getRoot() == null) {
            return new ArrayList();
        }
        if (filter == null) {
            PhFilterWindow wf = new PhFilterWindow();
            wf.set(min, max);
            filter = wf;
        }
        PhResultList.MappingResultList<T, R> list = new PhResultList.MappingResultList<T, R>(filter, mapper, () -> new PhEntry<Object>(new long[this.dims], null));
        NodeIteratorListReuse<T, R> it = new NodeIteratorListReuse<T, R>(this.dims, list);
        return it.resetAndRun(this.getRoot(), min, max, maxResults);
    }

    @Override
    public int getDim() {
        return this.dims;
    }

    @Override
    public int getBitDepth() {
        return 64;
    }

    @Override
    public PhTree.PhKnnQuery<T> nearestNeighbour(int nMin, long ... v) {
        return new PhQueryKnnHS(this).reset(nMin, PhDistanceL.THIS, v);
    }

    @Override
    public PhTree.PhKnnQuery<T> nearestNeighbour(int nMin, PhDistance dist, PhFilter dimsFilter, long ... center) {
        return new PhQueryKnnHS(this).reset(nMin, dist, center);
    }

    @Override
    public PhRangeQuery<T> rangeQuery(double dist, long ... center) {
        return this.rangeQuery(dist, null, center);
    }

    @Override
    public PhRangeQuery<T> rangeQuery(double dist, PhDistance optionalDist, long ... center) {
        PhFilterDistance filter = new PhFilterDistance();
        if (optionalDist == null) {
            optionalDist = PhDistanceL.THIS;
        }
        filter.set(center, optionalDist, dist);
        PhIteratorNoGC q = new PhIteratorNoGC(this, filter);
        PhRangeQuery qr = new PhRangeQuery(q, this, optionalDist, filter);
        qr.reset(dist, center);
        return qr;
    }

    @Override
    public void clear() {
        this.root = null;
        this.nEntries = 0;
    }

    ObjectPool<Node> nodePool() {
        return this.nodePool;
    }

    LongArrayPool longPool() {
        return this.bitPool;
    }

    public BSTPool bstPool() {
        return this.bstPool;
    }

    public static class UpdateInfo {
        long[] newKey;
        int insertRequired = Integer.MAX_VALUE;

        UpdateInfo init(long[] newKey) {
            this.newKey = newKey;
            return this;
        }
    }
}

