/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v16hd;

import ch.ethz.globis.phtree.PhDistance;
import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhEntryDist;
import ch.ethz.globis.phtree.PhTree;
import ch.ethz.globis.phtree.PhTreeHelperHD;
import ch.ethz.globis.phtree.v16hd.BitsHD;
import ch.ethz.globis.phtree.v16hd.Node;
import ch.ethz.globis.phtree.v16hd.PhTree16HD;
import ch.ethz.globis.phtree.v16hd.bst.BSTIteratorAll;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;

public class PhQueryKnnHSZ<T>
implements PhTree.PhKnnQuery<T> {
    private static final PhDEComp COMP = new PhDEComp();
    private final int dims;
    private PhTree16HD<T> pht;
    private PhDistance distance;
    private long[] center;
    private final ArrayList<PhEntryDist<T>> results = new ArrayList();
    private final ArrayList<PhEntryDist<Object>> pool = new ArrayList();
    private final PriorityQueue<PhEntryDist<Object>> queueEst = new PriorityQueue(COMP);
    private final PriorityQueue<PhEntryDist<Object>> queueLx = new PriorityQueue(COMP);
    private final BSTIteratorAll iterNode = new BSTIteratorAll();
    private Iterator<PhEntryDist<T>> iterResult;
    private final long[] relativeQuadrantOfCenter;
    private static final double EPS = 0.999999999;

    public PhQueryKnnHSZ(PhTree16HD<T> pht) {
        this.dims = pht.getDim();
        this.pht = pht;
        this.relativeQuadrantOfCenter = BitsHD.newArray(this.dims);
    }

    @Override
    public long[] nextKey() {
        return ((PhEntry)this.nextEntryReuse()).getKey();
    }

    @Override
    public T nextValue() {
        return ((PhEntry)this.nextEntryReuse()).getValue();
    }

    @Override
    public PhEntryDist<T> nextEntry() {
        return this.iterResult.next();
    }

    @Override
    public PhEntryDist<T> nextEntryReuse() {
        return this.iterResult.next();
    }

    @Override
    public boolean hasNext() {
        return this.iterResult.hasNext();
    }

    @Override
    public T next() {
        return this.nextValue();
    }

    @Override
    public PhTree.PhKnnQuery<T> reset(int nMin, PhDistance dist, long ... center) {
        this.distance = dist == null ? this.distance : dist;
        this.center = center;
        this.queueEst.clear();
        this.queueLx.clear();
        this.results.clear();
        if (nMin <= 0 || this.pht.size() == 0) {
            this.iterResult = Collections.emptyList().iterator();
            return this;
        }
        PhEntryDist<Object> rootE = this.createEntry(new long[this.dims], this.pht.getRoot(), 0.0);
        this.queueLx.add(rootE);
        this.search(nMin);
        this.iterResult = this.results.iterator();
        return this;
    }

    private void validateLxQueue(int k) {
        while (!this.queueEst.isEmpty() && (this.queueLx.isEmpty() || this.queueEst.peek().dist() <= this.queueLx.peek().dist())) {
            PhEntryDist<Object> entry = this.queueEst.poll();
            entry.setDist(this.calcLxDistance(entry));
            this.queueLx.add(entry);
        }
    }

    private void search(int k) {
        while (!this.queueLx.isEmpty() || !this.queueEst.isEmpty()) {
            this.validateLxQueue(k);
            PhEntryDist<Object> candidate = this.queueLx.poll();
            Object val = candidate.getValue();
            if (!(val instanceof Node)) {
                this.results.add(candidate);
                if (this.results.size() < k) continue;
                return;
            }
            Node node = (Node)val;
            this.iterNode.reset(node.getRoot());
            if (node.getEntryCount() > 4) {
                double currentMin = this.queueLx.isEmpty() ? Double.POSITIVE_INFINITY : this.queueLx.peek().dist();
                double[] distances = new double[this.dims];
                this.distance.knnCalcDistances(this.center, candidate.getKey(), node.getPostLen() + 1, distances);
                if (candidate.dist() <= 0.0) {
                    PhTreeHelperHD.posInArrayHD(this.center, node.getPostLen(), this.relativeQuadrantOfCenter);
                } else {
                    this.calcRelativeQuadrants(node, candidate.getKey(), this.relativeQuadrantOfCenter);
                }
                while (this.iterNode.hasNextEntry()) {
                    Node.BSTEntry e2 = this.iterNode.nextEntry();
                    double d = this.estimateDist(e2, this.relativeQuadrantOfCenter, distances);
                    if (d <= currentMin) {
                        PhEntryDist<Object> newLx = this.createLxEntry(e2);
                        this.queueLx.add(newLx);
                        currentMin = currentMin < newLx.dist() ? currentMin : newLx.dist();
                        continue;
                    }
                    this.queueEst.add(this.createEntry(e2.getKdKey(), e2.getValue(), d));
                }
            } else {
                while (this.iterNode.hasNextEntry()) {
                    Node.BSTEntry e2 = this.iterNode.nextEntry();
                    PhEntryDist<Object> subE = this.createLxEntry(e2);
                    this.queueLx.add(subE);
                }
            }
            this.pool.add(candidate);
        }
    }

    private double calcLxDistance(PhEntryDist<Object> e) {
        double d;
        if (e.getValue() instanceof Node) {
            Node sub = (Node)e.getValue();
            d = this.distToNode(e.getKey(), sub.getPostLen() + 1);
        } else {
            d = this.distance.dist(this.center, e.getKey());
        }
        return d;
    }

    private PhEntryDist<Object> createLxEntry(Node.BSTEntry e) {
        double d;
        if (e.getValue() instanceof Node) {
            Node sub = (Node)e.getValue();
            d = this.distToNode(e.getKdKey(), sub.getPostLen() + 1);
        } else {
            d = this.distance.dist(this.center, e.getKdKey());
        }
        return this.createEntry(e.getKdKey(), e.getValue(), d);
    }

    private PhEntryDist<Object> createEntry(long[] key, Object val, double dist) {
        if (this.pool.isEmpty()) {
            return new PhEntryDist<Object>(key, val, dist);
        }
        PhEntryDist<Object> e = this.pool.remove(this.pool.size() - 1);
        e.setKeyInternal(key);
        e.set(val, dist);
        return e;
    }

    private double estimateDist(Node.BSTEntry e2, long[] centerQuadrant, double[] distances) {
        int permCount = BitsHD.xorBitCount(centerQuadrant, e2.getKey());
        return permCount == 0 ? 0.0 : distances[permCount - 1] * 0.999999999;
    }

    private void calcRelativeQuadrants(Node node, long[] prefix, long[] relativeKNNpos) {
        long[] kNNCenter = this.center;
        long prefixMask = -1L << node.getPostLen() + 1;
        long prefixBit = 1L << node.getPostLen();
        int bitsPerSlot = BitsHD.mod65x(this.dims);
        int valsetPos = 0;
        for (int rs = 0; rs < relativeKNNpos.length; ++rs) {
            long pos = 0L;
            for (int i = 0; i < bitsPerSlot; ++i) {
                pos <<= 1;
                long nodeCenter = prefix[valsetPos] & prefixMask | prefixBit;
                pos |= kNNCenter[valsetPos] > nodeCenter ? 1L : 0L;
                ++valsetPos;
            }
            relativeKNNpos[rs] = pos;
            bitsPerSlot = 64;
        }
    }

    private double distToNode(long[] prefix, int bitsToIgnore) {
        long maskMin = -1L << bitsToIgnore;
        long maskMax = maskMin ^ 0xFFFFFFFFFFFFFFFFL;
        long[] buf = new long[prefix.length];
        for (int i = 0; i < buf.length; ++i) {
            long min = prefix[i] & maskMin;
            long max = prefix[i] | maskMax;
            buf[i] = min > this.center[i] ? min : (max < this.center[i] ? max : this.center[i]);
        }
        return this.distance.dist(this.center, buf);
    }

    private static class PhDEComp
    implements Comparator<PhEntryDist<?>> {
        private PhDEComp() {
        }

        @Override
        public int compare(PhEntryDist<?> a, PhEntryDist<?> b) {
            double d2;
            double d1 = a.dist();
            return d1 < (d2 = b.dist()) ? -1 : (d1 > d2 ? 1 : 0);
        }
    }
}

