/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v16.bst;

import ch.ethz.globis.phtree.v16.Node;
import ch.ethz.globis.phtree.v16.bst.BSTreePage;

public class BSTIteratorToArray {
    private Node.BSTEntry[] entries;
    private int nEntries;

    public BSTIteratorToArray reset(BSTreePage root, Node.BSTEntry[] entries) {
        this.entries = entries;
        this.nEntries = 0;
        BSTreePage page = this.findFirstLeafPage(root);
        this.readLeafPages(page);
        return this;
    }

    private BSTreePage findFirstLeafPage(BSTreePage currentPage) {
        while (!currentPage.isLeaf()) {
            if (currentPage.getNKeys() == -1) {
                return null;
            }
            currentPage = currentPage.getPageByPos(0);
        }
        return currentPage;
    }

    private void readLeafPages(BSTreePage currentPage) {
        while (currentPage != null) {
            Node.BSTEntry[] values = currentPage.getValues();
            System.arraycopy(values, 0, this.entries, this.nEntries, currentPage.getNKeys());
            this.nEntries += currentPage.getNKeys();
            currentPage = currentPage.getNextLeaf();
        }
    }

    public int getNEntries() {
        return this.nEntries;
    }
}

