/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree;

import ch.ethz.globis.phtree.PhDistance;
import ch.ethz.globis.phtree.PhDistanceMMF;
import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhEntryDist;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.PhRangeQuery;
import ch.ethz.globis.phtree.PhTree;
import ch.ethz.globis.phtree.pre.PreProcessorPointF;
import ch.ethz.globis.phtree.util.PhIteratorBase;
import ch.ethz.globis.phtree.util.PhMapper;
import ch.ethz.globis.phtree.util.PhMapperK;
import ch.ethz.globis.phtree.util.PhTreeStats;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class PhTreeMultiMapF<T> {
    private final PhTree<T> pht;
    private final PreProcessorPointF pre;

    protected PhTreeMultiMapF(int dim, PreProcessorPointF pre) {
        this.pht = PhTree.create(dim + 1);
        this.pre = pre;
    }

    protected PhTreeMultiMapF(PhTree<T> tree) {
        this.pht = tree;
        this.pre = new PreProcessorPointF.IEEE();
    }

    public static <T> PhTreeMultiMapF<T> create(int dim) {
        return new PhTreeMultiMapF<T>(dim, new PreProcessorPointF.IEEE());
    }

    public static <T> PhTreeMultiMapF<T> create(int dim, PreProcessorPointF pre) {
        return new PhTreeMultiMapF<T>(dim, pre);
    }

    public static <T> PhTreeMultiMapF<T> wrap(PhTree<T> tree) {
        return new PhTreeMultiMapF<T>(tree);
    }

    public int size() {
        return this.pht.size();
    }

    public T put(double[] key, long id, T value) {
        return this.pht.put(this.pre(key, id), value);
    }

    public boolean contains(double[] key, long id) {
        return this.pht.contains(this.pre(key, id));
    }

    public T get(double[] key, long id) {
        return this.pht.get(this.pre(key, id));
    }

    public T remove(double[] key, long id) {
        return this.pht.remove(this.pre(key, id));
    }

    public PhExtentMMF<T> queryExtent() {
        return new PhExtentMMF<T>(this.pht.queryExtent(), this.pht.getDim() - 1, this.pre);
    }

    public PhQueryMMF<T> query(double[] min, double[] max) {
        long[] lMin = new long[min.length + 1];
        long[] lMax = new long[max.length + 1];
        this.pre.pre(min, lMin);
        this.pre.pre(max, lMax);
        lMin[lMin.length - 1] = Long.MIN_VALUE;
        lMax[lMax.length - 1] = Long.MAX_VALUE;
        return new PhQueryMMF<T>(this.pht.query(lMin, lMax), this.pht.getDim() - 1, this.pre);
    }

    public PhRangeQueryMMF<T> rangeQuery(double dist, double ... center) {
        return this.rangeQuery(dist, PhDistanceMMF.THIS, center);
    }

    public PhRangeQueryMMF<T> rangeQuery(double dist, PhDistance optionalDist, double ... center) {
        if (optionalDist == null) {
            optionalDist = PhDistanceMMF.THIS;
        }
        long[] lKey = new long[center.length + 1];
        this.pre.pre(center, lKey);
        PhRangeQuery<T> iter = this.pht.rangeQuery(dist, optionalDist, lKey);
        return new PhRangeQueryMMF<T>(iter, this.pht, this.pre);
    }

    public int getDim() {
        return this.pht.getDim();
    }

    public PhKnnQueryMMF<T> nearestNeighbour(int nMin, double ... key) {
        long[] lKey = new long[key.length + 1];
        this.pre.pre(key, lKey);
        PhTree.PhKnnQuery<T> iter = this.pht.nearestNeighbour(nMin, PhDistanceMMF.THIS, null, lKey);
        return new PhKnnQueryMMF<T>(iter, this.pht.getDim() - 1, this.pre);
    }

    public PhKnnQueryMMF<T> nearestNeighbour(int nMin, PhDistance dist, double ... key) {
        long[] lKey = new long[key.length + 1];
        this.pre.pre(key, lKey);
        PhTree.PhKnnQuery<T> iter = this.pht.nearestNeighbour(nMin, dist, null, lKey);
        return new PhKnnQueryMMF<T>(iter, this.pht.getDim() - 1, this.pre);
    }

    public T update(double[] oldKey, long id, double[] newKey) {
        return this.pht.update(this.pre(oldKey, id), this.pre(newKey, id));
    }

    public List<PhEntryMMF<T>> queryAll(double[] min, double[] max) {
        return this.queryAll(min, max, Integer.MAX_VALUE, null, e -> new PhEntryMMF(PhMapperK.toDouble(e.getKey()), e.getKey()[min.length], e.getValue()));
    }

    public <R> List<R> queryAll(double[] min, double[] max, int maxResults, PhFilter filter, PhMapper<T, R> mapper) {
        long[] lUpp = new long[min.length];
        long[] lLow = new long[max.length];
        this.pre.pre(min, lLow);
        this.pre.pre(max, lUpp);
        return this.pht.queryAll(lLow, lUpp, maxResults, filter, mapper);
    }

    public void clear() {
        this.pht.clear();
    }

    public PhTree<T> getInternalTree() {
        return this.pht;
    }

    public PreProcessorPointF getPreprocessor() {
        return this.pre;
    }

    public String toStringTree() {
        return this.pht.toStringTree();
    }

    public String toString() {
        return this.pht.toString();
    }

    public PhTreeStats getStats() {
        return this.pht.getStats();
    }

    public T getOrDefault(double[] key, long id, T defaultValue) {
        T t = this.get(key, id);
        return t == null ? defaultValue : t;
    }

    public T putIfAbsent(double[] key, long id, T value) {
        return this.pht.putIfAbsent(this.pre(key, id), value);
    }

    public boolean remove(double[] key, long id, T value) {
        return this.pht.remove(this.pre(key, id), value);
    }

    public boolean replace(double[] key, long id, T oldValue, T newValue) {
        return this.pht.replace(this.pre(key, id), oldValue, newValue);
    }

    public T replace(double[] key, long id, T value) {
        return this.pht.replace(this.pre(key, id), value);
    }

    public T computeIfAbsent(double[] key, long id, Function<double[], ? extends T> mappingFunction) {
        return (T)this.pht.computeIfAbsent(this.pre(key, id), longs -> mappingFunction.apply(key));
    }

    public T computeIfPresent(double[] key, long id, BiFunction<double[], ? super T, ? extends T> remappingFunction) {
        return (T)this.pht.computeIfPresent(this.pre(key, id), (longs, t) -> remappingFunction.apply(key, (Object)t));
    }

    public T compute(double[] key, long id, BiFunction<double[], ? super T, ? extends T> remappingFunction) {
        return (T)this.pht.compute(this.pre(key, id), (longs, t) -> remappingFunction.apply(key, (Object)t));
    }

    private long[] pre(double[] key, long id) {
        long[] lKey = new long[key.length + 1];
        this.pre.pre(key, lKey);
        lKey[key.length] = id;
        return lKey;
    }

    public static class PhEntryDistMMF<T>
    extends PhEntryMMF<T> {
        private double dist;

        public PhEntryDistMMF(double[] key, long id, T value, double dist) {
            super(key, id, value);
            this.dist = dist;
        }

        public void set(long id, T value, double dist) {
            this.id = id;
            this.value = value;
            this.dist = dist;
        }

        public double dist() {
            return this.dist;
        }
    }

    public static class PhEntryMMF<T> {
        protected double[] key;
        protected long id;
        protected T value;

        public PhEntryMMF(double[] key, long id, T value) {
            this.key = key;
            this.id = id;
            this.value = value;
        }

        public double[] getKey() {
            return this.key;
        }

        public long getId() {
            return this.id;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }
    }

    public static class PhRangeQueryMMF<T>
    extends PhIteratorMMF<T> {
        private final long[] lCenter;
        private final PhRangeQuery<T> q;

        protected PhRangeQueryMMF(PhRangeQuery<T> iter, PhTree<T> tree, PreProcessorPointF pre) {
            super(iter, tree.getDim() - 1, pre);
            this.q = iter;
            this.lCenter = new long[this.dims + 1];
        }

        public PhRangeQueryMMF<T> reset(double range, double ... center) {
            this.pre.pre(center, this.lCenter);
            this.q.reset(range, this.lCenter);
            return this;
        }
    }

    public static class PhKnnQueryMMF<T>
    extends PhIteratorMMF<T> {
        private final long[] lCenter;
        private final PhTree.PhKnnQuery<T> q;
        private final PhEntryDistMMF<T> buffer;
        private final int dims;

        protected PhKnnQueryMMF(PhTree.PhKnnQuery<T> iter, int dims, PreProcessorPointF pre) {
            super(iter, dims, pre);
            this.dims = dims;
            this.q = iter;
            this.lCenter = new long[dims + 1];
            this.buffer = new PhEntryDistMMF<Object>(new double[dims], -1L, null, Double.NaN);
        }

        @Override
        public PhEntryDistMMF<T> nextEntry() {
            double[] d = new double[this.dims];
            PhEntryDist e = (PhEntryDist)this.q.nextEntryReuse();
            this.pre.post(e.getKey(), d);
            return new PhEntryDistMMF(d, e.getKey()[this.dims], e.getValue(), e.dist());
        }

        @Override
        public PhEntryDistMMF<T> nextEntryReuse() {
            PhEntryDist e = (PhEntryDist)this.q.nextEntryReuse();
            this.pre.post(e.getKey(), this.buffer.getKey());
            this.buffer.set(e.getKey()[this.dims], e.getValue(), e.dist());
            return this.buffer;
        }

        public PhKnnQueryMMF<T> reset(int nMin, PhDistance dist, double ... center) {
            this.pre.pre(center, this.lCenter);
            this.q.reset(nMin, dist, this.lCenter);
            return this;
        }
    }

    public static class PhQueryMMF<T>
    extends PhIteratorMMF<T> {
        private final long[] lMin;
        private final long[] lMax;
        private final PhTree.PhQuery<T> q;

        protected PhQueryMMF(PhTree.PhQuery<T> iter, int dims, PreProcessorPointF pre) {
            super(iter, dims, pre);
            this.q = iter;
            this.lMin = new long[dims + 1];
            this.lMax = new long[dims + 1];
        }

        public void reset(double[] lower, double[] upper) {
            this.pre.pre(lower, this.lMin);
            this.pre.pre(upper, this.lMax);
            this.lMin[this.dims] = Long.MIN_VALUE;
            this.lMax[this.dims] = Long.MAX_VALUE;
            this.q.reset(this.lMin, this.lMax);
        }
    }

    public static class PhExtentMMF<T>
    extends PhIteratorMMF<T> {
        private final PhTree.PhExtent<T> iter;

        protected PhExtentMMF(PhTree.PhExtent<T> iter, int dims, PreProcessorPointF pre) {
            super(iter, dims, pre);
            this.iter = iter;
        }

        public PhExtentMMF<T> reset() {
            this.iter.reset();
            return this;
        }
    }

    public static class PhIteratorMMF<T>
    implements PhIteratorBase<T, PhEntryMMF<T>> {
        private final PhIteratorBase<T, ? extends PhEntry<T>> iter;
        protected final PreProcessorPointF pre;
        protected final int dims;
        private final PhEntryMMF<T> buffer;

        protected PhIteratorMMF(PhIteratorBase<T, ? extends PhEntry<T>> iter, int dims, PreProcessorPointF pre) {
            this.iter = iter;
            this.pre = pre;
            this.dims = dims;
            this.buffer = new PhEntryMMF<Object>(new double[dims], -1L, null);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public T next() {
            return this.nextValue();
        }

        @Override
        public PhEntryMMF<T> nextEntry() {
            double[] d = new double[this.dims];
            PhEntry<T> e = this.iter.nextEntryReuse();
            this.pre.post(e.getKey(), d);
            return new PhEntryMMF<T>(d, e.getKey()[this.dims], e.getValue());
        }

        @Override
        public PhEntryMMF<T> nextEntryReuse() {
            PhEntry<T> e = this.iter.nextEntryReuse();
            this.pre.post(e.getKey(), this.buffer.getKey());
            this.buffer.setValue(e.getValue());
            return this.buffer;
        }

        public double[] nextKey() {
            double[] d = new double[this.dims];
            this.pre.post(this.iter.nextEntryReuse().getKey(), d);
            return d;
        }

        @Override
        public T nextValue() {
            return this.iter.nextValue();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

