/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.mastercooldowns.libs.commands.base;

import java.util.HashMap;
import java.util.Map;
import me.gabytm.mastercooldowns.libs.commands.base.components.MessageResolver;
import me.gabytm.mastercooldowns.libs.commands.base.components.MfUtil;
import me.gabytm.mastercooldowns.libs.commands.exceptions.MfException;
import org.bukkit.command.CommandSender;

public final class MessageHandler {
    private final Map<String, MessageResolver> messages = new HashMap<String, MessageResolver>();

    MessageHandler() {
        this.register("cmd.no.permission", sender -> sender.sendMessage(MfUtil.color("&cYou don't have permission to execute this command!")));
        this.register("cmd.no.console", sender -> sender.sendMessage(MfUtil.color("&cCommand can't be executed through the console!")));
        this.register("cmd.no.player", sender -> sender.sendMessage(MfUtil.color("&cCommand can only be executed through the console!")));
        this.register("cmd.no.exists", sender -> sender.sendMessage(MfUtil.color("&cThe command you're trying to use doesn't exist!")));
        this.register("cmd.wrong.usage", sender -> sender.sendMessage(MfUtil.color("&cWrong usage for the command!")));
    }

    public void register(String messageId, MessageResolver messageResolver) {
        this.messages.put(messageId, messageResolver);
    }

    boolean hasId(String messageId) {
        return this.messages.get(messageId) != null;
    }

    void sendMessage(String messageId, CommandSender sender) {
        MessageResolver messageResolver = this.messages.get(messageId);
        if (messageResolver == null) {
            throw new MfException("The message ID \"" + messageId + "\" does not exist!");
        }
        messageResolver.resolve(sender);
    }
}

