/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.mastercooldowns.database;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.gabytm.mastercooldowns.MasterCooldowns;
import me.gabytm.mastercooldowns.cooldown.Cooldown;
import me.gabytm.mastercooldowns.database.Query;
import me.gabytm.mastercooldowns.utils.StringUtil;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class DatabaseManager {
    private MasterCooldowns plugin;
    private String uri;

    public DatabaseManager(MasterCooldowns plugin) {
        this.plugin = plugin;
    }

    private void createDatabase() {
        File file;
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        if (!(file = new File(this.plugin.getDataFolder(), "database.db")).exists()) {
            try {
                file.createNewFile();
                StringUtil.infoLog(this.plugin, "&cNo database found, creating one...");
            }
            catch (IOException e) {
                e.printStackTrace();
                StringUtil.severLog(this.plugin, "&cAn error occurred while creating the database.");
            }
        }
        this.uri = "jdbc:sqlite:" + file.toPath().toString();
    }

    public void connect() {
        this.createDatabase();
        try {
            Class.forName("org.sqlite.JDBC");
            Connection connection = DriverManager.getConnection(this.uri);
            if (connection != null) {
                this.createTable(connection);
                this.plugin.getCooldownManager().loadCooldowns(this.loadCooldowns());
                long savingInterval = this.plugin.getConfig().getLong("storage.savingInterval", 600L) * 20L;
                new BukkitRunnable(){

                    public void run() {
                        DatabaseManager.this.saveCooldowns(DatabaseManager.this.plugin.getCooldownManager().getLoadedCooldowns());
                    }
                }.runTaskTimerAsynchronously((Plugin)this.plugin, savingInterval, savingInterval);
            }
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
        }
    }

    private void createTable(Connection connection) {
        try {
            PreparedStatement statement = connection.prepareStatement(Query.CREATE_TABLE.value());
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private Table<UUID, String, Cooldown> loadCooldowns() {
        HashBasedTable table = HashBasedTable.create();
        try {
            Connection connection = DriverManager.getConnection(this.uri);
            if (connection != null) {
                PreparedStatement select = connection.prepareStatement(Query.LOAD_SELECT.value());
                select.execute();
                ResultSet resultSet = select.getResultSet();
                while (resultSet.next()) {
                    String uuidString = resultSet.getString("uuid");
                    String name = resultSet.getString("name");
                    long start = resultSet.getLong("start");
                    long expiration = resultSet.getLong("expiration");
                    if (expiration <= TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())) {
                        PreparedStatement delete = connection.prepareStatement(Query.LOAD_DELETE.value());
                        delete.setString(1, uuidString);
                        delete.setString(2, name);
                        delete.executeUpdate();
                        delete.close();
                        continue;
                    }
                    UUID uuid = UUID.fromString(uuidString);
                    table.put((Object)uuid, (Object)name, (Object)new Cooldown(uuid, name, start, expiration));
                }
                if (table.isEmpty()) {
                    StringUtil.infoLog(this.plugin, "&cNo cooldowns found.");
                } else {
                    StringUtil.infoLog(this.plugin, table.values().size() + " &acooldown(s) have been loaded.");
                }
                select.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            StringUtil.severLog(this.plugin, "&cAn error occurred while loading the cooldowns.");
        }
        return table;
    }

    public void saveCooldowns(@NotNull Table<UUID, String, Cooldown> table) {
        Collection cooldowns = table.values();
        if (cooldowns.size() == 0) {
            return;
        }
        try {
            Connection connection = DriverManager.getConnection(this.uri);
            LinkedList<Cooldown> expiredCooldowns = new LinkedList<Cooldown>();
            for (Cooldown cd : cooldowns) {
                if (connection == null) continue;
                if (cd.isExpired()) {
                    PreparedStatement delete = connection.prepareStatement(Query.SAVE_DELETE.value());
                    delete.setString(1, cd.getPlayerUuid().toString());
                    delete.setString(2, cd.getName());
                    delete.executeUpdate();
                    delete.close();
                    expiredCooldowns.add(cd);
                    continue;
                }
                PreparedStatement check = connection.prepareStatement(Query.SAVE_CHECK.value());
                check.setString(1, cd.getPlayerUuid().toString());
                check.setString(2, cd.getName());
                check.execute();
                ResultSet checkResult = check.getResultSet();
                if (!checkResult.next()) {
                    PreparedStatement insert = connection.prepareStatement(Query.SAVE_INSERT.value());
                    insert.setString(1, cd.getPlayerUuid().toString());
                    insert.setString(2, cd.getName());
                    insert.setLong(3, cd.getStart());
                    insert.setLong(4, cd.getExpiration());
                    insert.executeUpdate();
                    insert.close();
                    continue;
                }
                PreparedStatement update = connection.prepareStatement(Query.SAVE_UPDATE.value());
                update.setLong(1, cd.getStart());
                update.setLong(2, cd.getExpiration());
                update.setString(3, cd.getPlayerUuid().toString());
                update.setString(4, cd.getName());
                update.executeUpdate();
                update.close();
                check.close();
            }
            expiredCooldowns.forEach(cooldown -> table.remove((Object)cooldown.getPlayerUuid(), (Object)cooldown.getName()));
            if (!this.plugin.getConfig().getBoolean("storage.sendSavingMessage", true)) {
                return;
            }
            if (cooldowns.size() > 0) {
                StringUtil.infoLog(this.plugin, "&aSaved &f" + cooldowns.size() + " &acooldown(s) to database.");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

