/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.mastercooldowns.commands;

import java.util.List;
import me.gabytm.mastercooldowns.MasterCooldowns;
import me.gabytm.mastercooldowns.cooldown.Cooldown;
import me.gabytm.mastercooldowns.cooldown.CooldownManager;
import me.gabytm.mastercooldowns.libs.commands.annotations.Alias;
import me.gabytm.mastercooldowns.libs.commands.annotations.Command;
import me.gabytm.mastercooldowns.libs.commands.annotations.Completion;
import me.gabytm.mastercooldowns.libs.commands.annotations.Permission;
import me.gabytm.mastercooldowns.libs.commands.annotations.SubCommand;
import me.gabytm.mastercooldowns.libs.commands.base.CommandBase;
import me.gabytm.mastercooldowns.utils.Messages;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@Command(value="mastercooldowns")
@Alias(value={"cd", "mcd", "mcooldowns", "mcooldown"})
public class RemoveCooldownCommand
extends CommandBase {
    private MasterCooldowns plugin;

    public RemoveCooldownCommand(MasterCooldowns plugin) {
        this.plugin = plugin;
    }

    @SubCommand(value="remove")
    @Completion(value={"#players"})
    @Permission(value={"mastercooldowns.access"})
    public void onCommand(CommandSender sender, String from, String cdName) {
        CooldownManager cooldownManager = this.plugin.getCooldownManager();
        boolean onlineSendMessages = this.plugin.getConfig().getBoolean("settings.remove.all.onlineSendMessages", true);
        boolean offlineSendMessages = this.plugin.getConfig().getBoolean("settings.remove.all.offlineSendMessages", true);
        if (from.equals("*")) {
            if (sender.getServer().getOnlinePlayers().size() == 0) {
                sender.sendMessage(Messages.NO_ONLINE_PLAYERS.value());
                return;
            }
            if (cdName.equalsIgnoreCase("all")) {
                for (Player p : sender.getServer().getOnlinePlayers()) {
                    this.removeAllCooldowns(cooldownManager, (OfflinePlayer)p, sender, onlineSendMessages);
                }
                return;
            }
            for (Player p : sender.getServer().getOnlinePlayers()) {
                this.removeCooldown(cooldownManager, (OfflinePlayer)p, sender, cdName, onlineSendMessages);
            }
            return;
        }
        if (from.equals("**")) {
            if (sender.getServer().getOfflinePlayers().length == 0) {
                sender.sendMessage(Messages.NO_OFFLINE_PLAYERS.value());
                return;
            }
            if (cdName.equalsIgnoreCase("all")) {
                for (OfflinePlayer p : sender.getServer().getOfflinePlayers()) {
                    this.removeAllCooldowns(cooldownManager, p, sender, offlineSendMessages);
                }
                return;
            }
            for (OfflinePlayer p : sender.getServer().getOfflinePlayers()) {
                this.removeCooldown(cooldownManager, p, sender, cdName, offlineSendMessages);
            }
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)from);
        if (cdName.equalsIgnoreCase("all")) {
            this.removeAllCooldowns(cooldownManager, target, sender, true);
            return;
        }
        this.removeCooldown(cooldownManager, target, sender, cdName, true);
    }

    private void removeCooldown(CooldownManager cooldownManager, OfflinePlayer p, CommandSender s, String name, boolean sendMessages) {
        Cooldown cooldown = cooldownManager.getCooldownByName(p.getUniqueId(), name);
        if (cooldown == null || cooldown.isExpired()) {
            if (sendMessages) {
                s.sendMessage(Messages.COOLDOWN_NOT_FOUND.format(name, p));
            }
            return;
        }
        cooldownManager.removeCooldown(cooldown);
        if (sendMessages) {
            s.sendMessage(Messages.REMOVE.format(cooldown));
        }
    }

    private void removeAllCooldowns(CooldownManager cooldownManager, OfflinePlayer p, CommandSender s, boolean sendMessages) {
        List<Cooldown> cooldowns = cooldownManager.getPlayerActiveCooldowns(p.getUniqueId());
        if (cooldowns.size() == 0) {
            if (sendMessages) {
                s.sendMessage(Messages.LIST_EMPTY.format(p));
            }
            return;
        }
        for (Cooldown cd : cooldowns) {
            cooldownManager.removeCooldown(cd);
        }
        if (sendMessages) {
            s.sendMessage(Messages.REMOVE_ALL.format(cooldowns.size(), p));
        }
    }
}

