/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.mastercooldowns.commands;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.logging.Level;
import me.gabytm.mastercooldowns.MasterCooldowns;
import me.gabytm.mastercooldowns.libs.commands.annotations.Alias;
import me.gabytm.mastercooldowns.libs.commands.annotations.Command;
import me.gabytm.mastercooldowns.libs.commands.annotations.Default;
import me.gabytm.mastercooldowns.libs.commands.annotations.Permission;
import me.gabytm.mastercooldowns.libs.commands.annotations.SubCommand;
import me.gabytm.mastercooldowns.libs.commands.base.CommandBase;
import me.gabytm.mastercooldowns.libs.kyori.adventure.text.Component;
import me.gabytm.mastercooldowns.libs.kyori.adventure.text.TextComponent;
import me.gabytm.mastercooldowns.libs.kyori.adventure.text.event.ClickEvent;
import me.gabytm.mastercooldowns.libs.kyori.adventure.text.event.HoverEventSource;
import me.gabytm.mastercooldowns.libs.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.PluginDescriptionFile;

@Command(value="mastercooldowns")
@Alias(value={"cd", "mcd", "mcooldowns", "mcooldown"})
public class MasterCooldownsCommand
extends CommandBase {
    private MasterCooldowns plugin;
    private Component helpMessage;

    public MasterCooldownsCommand(MasterCooldowns plugin) {
        this.plugin = plugin;
        try (InputStreamReader reader = new InputStreamReader(plugin.getResource("commands.yml"));){
            PluginDescriptionFile description = plugin.getDescription();
            YamlConfiguration yaml = YamlConfiguration.loadConfiguration((Reader)reader);
            Object header = MiniMessage.miniMessage().deserialize(String.format(yaml.getString("header"), description.getVersion(), String.join((CharSequence)", ", description.getAuthors())));
            ArrayList<Component> commands = new ArrayList<Component>();
            for (String section : yaml.getConfigurationSection("commands").getKeys(false)) {
                String commandDescription = yaml.getString("commands." + section + ".description");
                String hover = String.join((CharSequence)"<br>", yaml.getStringList("commands." + section + ".hover"));
                String command = yaml.getString("commands." + section + ".command");
                commands.add(MiniMessage.miniMessage().deserialize(commandDescription).hoverEvent((HoverEventSource)MiniMessage.miniMessage().deserialize(hover)).clickEvent(ClickEvent.runCommand(command)));
            }
            this.helpMessage = ((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)header)).append(commands)).build();
        }
        catch (IOException e) {
            plugin.getLogger().log(Level.SEVERE, "Could not load the help message from commands.yml", e);
            this.helpMessage = Component.text("Could not load the help message from commands.yml");
        }
    }

    @Default
    @Permission(value={"mastercooldowns.access"})
    public void onDefaultCommand(CommandSender sender) {
        this.plugin.getAudiences().sender(sender).sendMessage(this.helpMessage);
    }

    @SubCommand(value="help")
    @Alias(value={"?"})
    @Permission(value={"mastercooldowns.access"})
    public void onHelpCommand(CommandSender sender) {
        this.plugin.getAudiences().sender(sender).sendMessage(this.helpMessage);
    }
}

