/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.mastercooldowns.commands;

import java.util.List;
import me.gabytm.mastercooldowns.MasterCooldowns;
import me.gabytm.mastercooldowns.cooldown.Cooldown;
import me.gabytm.mastercooldowns.cooldown.CooldownManager;
import me.gabytm.mastercooldowns.libs.commands.annotations.Alias;
import me.gabytm.mastercooldowns.libs.commands.annotations.Command;
import me.gabytm.mastercooldowns.libs.commands.annotations.Completion;
import me.gabytm.mastercooldowns.libs.commands.annotations.Permission;
import me.gabytm.mastercooldowns.libs.commands.annotations.SubCommand;
import me.gabytm.mastercooldowns.libs.commands.base.CommandBase;
import me.gabytm.mastercooldowns.utils.Messages;
import me.gabytm.mastercooldowns.utils.StringUtil;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

@Command(value="mastercooldowns")
@Alias(value={"cd", "mcd", "mcooldowns", "mcooldown"})
public class ListCooldownsCommand
extends CommandBase {
    private MasterCooldowns plugin;

    public ListCooldownsCommand(MasterCooldowns plugin) {
        this.plugin = plugin;
    }

    @SubCommand(value="list")
    @Completion(value={"#players"})
    @Permission(value={"mastercooldowns.access"})
    public void onCommand(CommandSender sender, String playerName) {
        CooldownManager cooldownManager = this.plugin.getCooldownManager();
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)playerName);
        List<Cooldown> cooldowns = cooldownManager.getPlayerActiveCooldowns(target.getUniqueId());
        StringBuilder message = new StringBuilder();
        if (cooldowns.size() == 0) {
            sender.sendMessage(Messages.LIST_EMPTY.format(target));
            return;
        }
        for (Cooldown cd : cooldowns) {
            if (message.length() < 1) {
                message.append(Messages.LIST.format(cd));
                continue;
            }
            message.append(StringUtil.colorize("&7, ")).append(Messages.LIST.format(cd));
        }
        if (cooldowns.size() > 0) {
            sender.sendMessage(Messages.LIST_HEADER.format(target));
            sender.sendMessage(message.toString());
        } else {
            sender.sendMessage(Messages.LIST_EMPTY.format(target));
        }
    }
}

