/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.mastercooldowns.commands;

import me.gabytm.mastercooldowns.MasterCooldowns;
import me.gabytm.mastercooldowns.cooldown.Cooldown;
import me.gabytm.mastercooldowns.cooldown.CooldownManager;
import me.gabytm.mastercooldowns.libs.commands.annotations.Alias;
import me.gabytm.mastercooldowns.libs.commands.annotations.Command;
import me.gabytm.mastercooldowns.libs.commands.annotations.Completion;
import me.gabytm.mastercooldowns.libs.commands.annotations.Permission;
import me.gabytm.mastercooldowns.libs.commands.annotations.SubCommand;
import me.gabytm.mastercooldowns.libs.commands.base.CommandBase;
import me.gabytm.mastercooldowns.utils.Messages;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

@Command(value="mastercooldowns")
@Alias(value={"cd", "mcd", "mcooldowns", "mcooldown"})
public class CheckCooldownCommand
extends CommandBase {
    private MasterCooldowns plugin;

    public CheckCooldownCommand(MasterCooldowns plugin) {
        this.plugin = plugin;
    }

    @SubCommand(value="check")
    @Completion(value={"#players"})
    @Permission(value={"mastercooldowns.access"})
    public void onCommand(CommandSender sender, String playerName, String cdName) {
        CooldownManager cooldownManager = this.plugin.getCooldownManager();
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)playerName);
        String name = cdName.toUpperCase();
        Cooldown cooldown = cooldownManager.getCooldownByName(target.getUniqueId(), name);
        if (cooldown == null || cooldown.getTimeLeft() == 0L) {
            sender.sendMessage(Messages.COOLDOWN_NOT_FOUND.format(cdName, target));
            return;
        }
        sender.sendMessage(Messages.CHECK_INFO.format(cooldown));
    }
}

