/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.slimjar.resolver.enquirer;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import us.ajg0702.leaderboards.libs.slimjar.logging.LogDispatcher;
import us.ajg0702.leaderboards.libs.slimjar.logging.ProcessLogger;
import us.ajg0702.leaderboards.libs.slimjar.resolver.ResolutionResult;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.Dependency;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.Repository;
import us.ajg0702.leaderboards.libs.slimjar.resolver.enquirer.RepositoryEnquirer;
import us.ajg0702.leaderboards.libs.slimjar.resolver.pinger.URLPinger;
import us.ajg0702.leaderboards.libs.slimjar.resolver.strategy.PathResolutionStrategy;

public final class PingingRepositoryEnquirer
implements RepositoryEnquirer {
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();
    private final Repository repository;
    private final PathResolutionStrategy dependencyURLCreationStrategy;
    private final PathResolutionStrategy checksumURLCreationStrategy;
    private final PathResolutionStrategy pomURLCreationStrategy;
    private final URLPinger urlPinger;

    public PingingRepositoryEnquirer(Repository repository, PathResolutionStrategy urlCreationStrategy, PathResolutionStrategy checksumURLCreationStrategy, PathResolutionStrategy pomURLCreationStrategy, URLPinger urlPinger) {
        this.repository = repository;
        this.dependencyURLCreationStrategy = urlCreationStrategy;
        this.checksumURLCreationStrategy = checksumURLCreationStrategy;
        this.pomURLCreationStrategy = pomURLCreationStrategy;
        this.urlPinger = urlPinger;
    }

    @Override
    public ResolutionResult enquire(Dependency dependency) {
        LOGGER.debug("Enquiring repositories to find {0}", dependency.getArtifactId());
        Optional<URL> resolvedDependency = this.dependencyURLCreationStrategy.pathTo(this.repository, dependency).stream().map(path -> {
            try {
                return new URL((String)path);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }).filter(this.urlPinger::ping).findFirst();
        if (!resolvedDependency.isPresent()) {
            return this.pomURLCreationStrategy.pathTo(this.repository, dependency).stream().map(path -> {
                try {
                    return new URL((String)path);
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }).filter(this.urlPinger::ping).findFirst().map(url -> new ResolutionResult(this.repository, null, null, true)).orElse(null);
        }
        Optional<URL> resolvedChecksum = this.checksumURLCreationStrategy.pathTo(this.repository, dependency).stream().map(path -> {
            try {
                return new URL((String)path);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }).filter(this.urlPinger::ping).findFirst();
        return new ResolutionResult(this.repository, resolvedDependency.get(), resolvedChecksum.orElse(null), false);
    }
}

