/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.slimjar.downloader.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.ajg0702.leaderboards.libs.slimjar.downloader.output.OutputWriter;

public final class ChanneledFileOutputWriter
implements OutputWriter {
    private static final Logger LOGGER = Logger.getLogger(ChanneledFileOutputWriter.class.getName());
    private final File outputFile;

    public ChanneledFileOutputWriter(File outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public File writeFrom(InputStream inputStream, long length) throws IOException {
        LOGGER.log(Level.FINE, "Attempting to write from inputStream...");
        if (!this.outputFile.exists()) {
            LOGGER.log(Level.FINE, "Writing {0} bytes...", length);
            try (ReadableByteChannel channel = Channels.newChannel(inputStream);
                 FileOutputStream output = new FileOutputStream(this.outputFile);){
                output.getChannel().transferFrom(channel, 0L, length);
            }
        }
        inputStream.close();
        return this.outputFile;
    }
}

