/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.formatting.formats;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.ajg0702.leaderboards.Debug;
import us.ajg0702.leaderboards.formatting.Format;

public class ColonTime
extends Format {
    private final Pattern pattern = Pattern.compile("([0-9]*)?:([0-9]*):([0-9]*)(:|.)?([0-9]*)?");

    @Override
    public boolean matches(String output, String placeholder) {
        if (output == null) {
            return false;
        }
        boolean matches = this.pattern.matcher(output).matches();
        Debug.info("[Format: ColonTime] '" + output + "' matches: " + matches);
        return matches;
    }

    @Override
    public double toDouble(String input) throws NumberFormatException {
        Matcher matcher = this.pattern.matcher(input);
        if (!matcher.matches()) {
            Debug.info("[Format: ColonTime] Matcher in toDouble does not match!");
            throw new NumberFormatException("For input: " + input);
        }
        int hours = Integer.parseInt(matcher.group(1));
        int minutes = Integer.parseInt(matcher.group(2));
        int seconds = Integer.parseInt(matcher.group(3));
        String secondSeperator = matcher.group(4);
        int miliSeconds = matcher.group(5) != null ? Integer.parseInt(matcher.group(5)) : -1;
        double result = 0.0;
        result += (double)seconds;
        result += (double)(minutes * 60);
        result += (double)(hours * 60 * 60);
        if (secondSeperator != null && miliSeconds != -1) {
            if (secondSeperator.equals(":")) {
                result += (double)miliSeconds / 1000.0;
            } else if (secondSeperator.equals(".")) {
                result += (double)Integer.parseInt("0." + miliSeconds);
            }
        }
        return result;
    }

    @Override
    public String toFormat(double input) {
        int hours = (int)(input / 3600.0);
        int minutes = (int)(input % 3600.0 / 60.0);
        double seconds = input % 60.0;
        return (hours == 0 ? "00" : Integer.valueOf(hours)) + ":" + (minutes == 0 ? "00" : Integer.valueOf(minutes)) + ":" + (seconds == 0.0 ? "00" : Double.valueOf(seconds));
    }

    @Override
    public String getName() {
        return "ColonTime";
    }
}

