/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.formatting;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;
import us.ajg0702.leaderboards.Debug;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.formatting.Format;
import us.ajg0702.leaderboards.formatting.formats.ColonTime;
import us.ajg0702.leaderboards.formatting.formats.Default;
import us.ajg0702.leaderboards.formatting.formats.Time;

public class PlaceholderFormatter {
    private final Format defaultFormat = new Default();
    private final List<Format> formats = Arrays.asList(new Time(), new ColonTime(), this.defaultFormat);
    private final LeaderboardPlugin plugin;
    Map<String, Format> formatCache = new ConcurrentHashMap<String, Format>();

    public PlaceholderFormatter(LeaderboardPlugin plugin) {
        this.plugin = plugin;
    }

    public Format getFormatFor(@Nullable String output, String board) {
        if (output != null && output.equals("%" + board + "%")) {
            return this.formatCache.getOrDefault(board, this.defaultFormat);
        }
        if (output == null) {
            Format possibleMatch = this.formatCache.get(board);
            if (possibleMatch == null) {
                for (Format format : this.formats) {
                    if (format.equals(this.defaultFormat) || !format.matches(null, board)) continue;
                    Debug.info("[Formatter] Putting " + format.getName() + " in formatCache for " + board);
                    possibleMatch = format;
                }
            }
            if (possibleMatch == null) {
                Debug.info("[Formatter] No possible match for " + board + ". Using default");
                return this.defaultFormat;
            }
            return possibleMatch;
        }
        return this.formatCache.computeIfAbsent(board, b -> {
            for (Format format : this.formats) {
                if (!format.matches(output, board)) continue;
                Debug.info("[Formatter] Putting " + format.getName() + " in formatCache for " + board + " with '" + output + "'");
                return format;
            }
            Debug.info("[Formatter] No possible match for " + board + " with '" + output + "'. Using default");
            return this.defaultFormat;
        });
    }

    public double toDouble(String input, String board) throws NumberFormatException {
        return this.getFormatFor(input, board).toDouble(input);
    }

    public String toFormat(double input, String board) {
        return this.getFormatFor(null, board).toFormat(input);
    }
}

