/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.displays.signs;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.plugin.Plugin;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.boards.TimedType;
import us.ajg0702.leaderboards.libs.utils.spigot.LocUtils;

public class BoardSign {
    private final Location location;
    private final String board;
    private final int position;
    private final TimedType type;
    private Sign sign;
    private final int x;
    private final int z;
    private final World world;
    private boolean removed;
    private final LeaderboardPlugin plugin;

    public BoardSign(Location location, String board, int position, TimedType type) {
        this.location = location;
        this.board = board;
        this.position = position;
        this.x = location.getChunk().getX();
        this.z = location.getChunk().getZ();
        this.world = location.getWorld();
        this.type = type;
        Plugin plugin = Bukkit.getPluginManager().getPlugin("ajLeaderboards");
        if (plugin == null) {
            throw new IllegalStateException("Where is ajleaderboards? I'm supposed to be ajLeaderboards, but im not?");
        }
        this.plugin = (LeaderboardPlugin)plugin;
        this.setSign();
    }

    private Future<Sign> setSign() {
        CompletableFuture<Sign> future = new CompletableFuture<Sign>();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            BlockState state = this.location.getBlock().getState();
            this.sign = !(state instanceof Sign) ? null : (Sign)state;
            future.complete(this.sign);
        });
        return future;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public World getWorld() {
        return this.world;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getBoard() {
        return this.board;
    }

    public int getPosition() {
        return this.position;
    }

    public TimedType getType() {
        return this.type;
    }

    public Sign getSign() {
        return this.sign;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved(boolean removed) {
        this.removed = removed;
    }

    public boolean isPlaced() throws ExecutionException, InterruptedException, TimeoutException {
        boolean placed = this.getBlockType(this.location).get(10L, TimeUnit.SECONDS).contains("SIGN");
        if (placed && this.sign == null) {
            try {
                this.setSign().get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (this.plugin.isShuttingDown()) {
                    return false;
                }
                this.plugin.getLogger().log(Level.SEVERE, "Interupted while trying to get sign data", e);
            }
        }
        return placed;
    }

    private Future<String> getBlockType(Location location) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        if (this.plugin.isShuttingDown()) {
            future.completeExceptionally(new InterruptedException());
            return future;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> future.complete(location.getBlock().getType().toString()));
        return future;
    }

    public void setText(String line1, String line2, String line3, String line4) {
        BlockState state = this.location.getBlock().getState();
        if (!(state instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)state;
        sign.setLine(0, line1);
        sign.setLine(1, line2);
        sign.setLine(2, line3);
        sign.setLine(3, line4);
        sign.update();
    }

    public String serialize() {
        return LocUtils.locToString(this.location) + ";" + this.board + ";" + this.position + ";" + (Object)((Object)this.type);
    }

    public static BoardSign deserialize(String s) {
        String[] parts = s.split(";");
        Location loc = LocUtils.stringToLoc(parts[0]);
        String board = parts[1];
        int pos = Integer.parseInt(parts[2]);
        TimedType type = parts.length > 3 ? TimedType.valueOf(parts[3]) : TimedType.ALLTIME;
        return new BoardSign(loc, board, pos, type);
    }
}

