/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.displays.lpcontext;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import net.luckperms.api.context.ContextCalculator;
import net.luckperms.api.context.ContextConsumer;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.context.ImmutableContextSet;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import us.ajg0702.leaderboards.Debug;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.boards.TimedType;
import us.ajg0702.leaderboards.boards.keys.BoardType;
import us.ajg0702.leaderboards.boards.keys.PlayerBoardType;

public class PositionContext
implements ContextCalculator<Player> {
    private final LeaderboardPlugin plugin;
    List<BoardType> contextBoardTypes = new ArrayList<BoardType>();
    LoadingCache<PlayerBoardType, Integer> positionCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).refreshAfterWrite(10L, TimeUnit.SECONDS).maximumSize(10000L).build((CacheLoader)new CacheLoader<PlayerBoardType, Integer>(){

        @NotNull
        public Integer load(@NotNull PlayerBoardType key) {
            return PositionContext.this.plugin.getTopManager().getStatEntry(key.getPlayer(), key.getBoard(), key.getType()).getPosition();
        }

        @NotNull
        public ListenableFuture<Integer> reload(@NotNull PlayerBoardType key, @NotNull Integer oldValue) {
            if (PositionContext.this.plugin.isShuttingDown()) {
                return Futures.immediateFuture((Object)oldValue);
            }
            if (PositionContext.this.plugin.getTopManager().getQueuedTasks() + PositionContext.this.plugin.getTopManager().getActiveFetchers() > 50 || PositionContext.this.plugin.getTopManager().getFetchingAverage() > 75) {
                return Futures.immediateFuture((Object)oldValue);
            }
            ListenableFutureTask task = ListenableFutureTask.create(() -> PositionContext.this.plugin.getTopManager().getStatEntry(key.getPlayer(), key.getBoard(), key.getType()).getPosition());
            if (PositionContext.this.plugin.isShuttingDown()) {
                return Futures.immediateFuture((Object)oldValue);
            }
            PositionContext.this.plugin.getTopManager().submit((Runnable)task);
            return task;
        }
    });
    private ContextSet potentialContexts;

    public PositionContext(LeaderboardPlugin leaderboardPlugin) {
        this.plugin = leaderboardPlugin;
        this.calculatePotentialContexts();
    }

    public void calculate(@NonNull Player target, @NonNull ContextConsumer consumer) {
        for (BoardType contextBoardType : this.contextBoardTypes) {
            consumer.accept("ajlb_pos_" + contextBoardType.getBoard() + "_" + contextBoardType.getType().lowerName(), this.positionCache.getUnchecked((Object)new PlayerBoardType((OfflinePlayer)target, contextBoardType.getBoard(), contextBoardType.getType())) + "");
        }
    }

    public @NonNull ContextSet estimatePotentialContexts() {
        return this.potentialContexts;
    }

    public void calculatePotentialContexts() {
        ImmutableContextSet.Builder builder = ImmutableContextSet.builder();
        for (BoardType contextBoardType : this.contextBoardTypes) {
            for (int i = 1; i <= 10; ++i) {
                builder.add("ajlb_pos_" + contextBoardType.getBoard() + "_" + contextBoardType.getType().lowerName(), i + "");
            }
        }
        this.potentialContexts = builder.build();
    }

    public void reloadConfig() {
        this.contextBoardTypes.clear();
        if (this.plugin.getAConfig().getStringList("only-register-lpc-for").isEmpty()) {
            this.plugin.getLogger().warning("Luckperms Contexts are enabled, but only-register-lpc-for has not been configured! Configuring only-register-lpc-for is strongly recommended to improve performance!");
            for (String board : this.plugin.getTopManager().getBoards()) {
                this.contextBoardTypes.addAll(this.allBoardTypes(board));
            }
        } else {
            List<String> btRaws = this.plugin.getAConfig().getStringList("only-register-lpc-for");
            for (String btRaw : btRaws) {
                String board = btRaw;
                if (board.contains(":")) {
                    int colonPosition = board.lastIndexOf(":");
                    board = board.substring(0, colonPosition);
                    String typeRaw = btRaw.substring(colonPosition + 1).toUpperCase(Locale.ROOT);
                    try {
                        TimedType type = TimedType.valueOf(typeRaw);
                        this.contextBoardTypes.add(new BoardType(board, type));
                    }
                    catch (IllegalArgumentException e) {
                        Debug.info("[Context filter] Assuming" + btRaw + " is a board name! (the stuff after colon is not a timed type: '" + typeRaw + "'");
                        this.contextBoardTypes.addAll(this.allBoardTypes(btRaw));
                    }
                    continue;
                }
                this.contextBoardTypes.addAll(this.allBoardTypes(board));
            }
        }
        this.calculatePotentialContexts();
    }

    private List<BoardType> allBoardTypes(String board) {
        ArrayList<BoardType> r = new ArrayList<BoardType>();
        for (TimedType type : TimedType.values()) {
            r.add(new BoardType(board, type));
        }
        return r;
    }
}

