/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.displays.armorstands;

import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import us.ajg0702.leaderboards.Debug;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.displays.armorstands.ArmorStandCache;
import us.ajg0702.leaderboards.displays.signs.BoardSign;
import us.ajg0702.leaderboards.libs.utils.spigot.VersionSupport;

public class ArmorStandManager {
    private final LeaderboardPlugin plugin;
    private final HashMap<Location, ArmorStandCache> armorStandCache = new HashMap();

    public ArmorStandManager(LeaderboardPlugin plugin) {
        this.plugin = plugin;
    }

    private void checkArmorstand(BoardSign sign, Location loc, String name, UUID id) throws ExecutionException, InterruptedException, TimeoutException {
        ArmorStand cacheEntity;
        ArmorStandCache cache = this.armorStandCache.get(sign.getLocation());
        if (cache != null && (cacheEntity = cache.getEntity()) != null && !cacheEntity.isDead()) {
            if (id != null && id.equals(cache.getId())) {
                return;
            }
            cache.setId(id);
            this.setArmorstandHead(cacheEntity, name, id);
            return;
        }
        if (this.plugin.isShuttingDown()) {
            return;
        }
        for (Entity entity : this.getNearbyEntities(loc).get(2L, TimeUnit.SECONDS)) {
            Location entityLoc;
            if (!(entity instanceof ArmorStand) || (entityLoc = entity.getLocation()).getBlockX() != loc.getBlockX() || entityLoc.getBlockZ() != loc.getBlockZ()) continue;
            ArmorStand armorStand = (ArmorStand)entity;
            this.armorStandCache.put(sign.getLocation(), new ArmorStandCache(armorStand));
            break;
        }
    }

    private void setArmorstandHead(ArmorStand stand, String name, UUID uuid) {
        Debug.info("Updating armorstand");
        if (VersionSupport.getMinorVersion() >= 10) {
            stand.setSilent(true);
        }
        ItemStack item = this.plugin.getHeadUtils().getVersionedHeadUtils() != null ? this.plugin.getHeadUtils().getVersionedHeadUtils().getHeadItem(uuid, name) : this.plugin.getHeadUtils().getHeadItem(uuid, name);
        stand.setHelmet(item);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void search(BoardSign sign, String name, UUID id) {
        BlockFace face;
        if (!sign.getLocation().getBlock().getType().toString().contains("SIGN")) {
            return;
        }
        if (!this.plugin.getTopManager().getBoards().contains(sign.getBoard())) {
            return;
        }
        if (id == null) {
            return;
        }
        Sign ss = sign.getSign();
        if (ss == null) {
            return;
        }
        if (VersionSupport.getMinorVersion() > 12) {
            org.bukkit.block.data.type.Sign bs;
            BlockData bd = ss.getBlockData();
            if (bd instanceof org.bukkit.block.data.type.Sign) {
                bs = (org.bukkit.block.data.type.Sign)bd;
                face = bs.getRotation();
            } else {
                if (!(bd instanceof WallSign)) {
                    this.plugin.getLogger().warning("nope");
                    return;
                }
                bs = (WallSign)bd;
                face = bs.getFacing();
            }
        } else {
            org.bukkit.material.Sign bs = (org.bukkit.material.Sign)ss.getData();
            face = bs.getFacing();
        }
        Location sl = sign.getLocation();
        try {
            switch (face) {
                case NORTH: 
                case NORTH_EAST: 
                case NORTH_NORTH_EAST: 
                case NORTH_NORTH_WEST: 
                case NORTH_WEST: {
                    int z = sl.getBlockZ() + 1;
                    while (z > sl.getBlockZ() - 1) {
                        for (int y = sl.getBlockY() + 1; y > sl.getBlockY() - 1; --y) {
                            Location curloc = new Location(sl.getWorld(), sl.getX(), (double)y, (double)z);
                            this.checkArmorstand(sign, curloc, name, id);
                            ArmorStandManager.debugParticles(curloc);
                        }
                        --z;
                    }
                    return;
                }
                case SOUTH: 
                case SOUTH_EAST: 
                case SOUTH_SOUTH_EAST: 
                case SOUTH_SOUTH_WEST: 
                case SOUTH_WEST: {
                    int z = sl.getBlockZ();
                    while (z > sl.getBlockZ() - 2) {
                        for (int y = sl.getBlockY() + 1; y > sl.getBlockY() - 1; --y) {
                            Location curloc = new Location(sl.getWorld(), sl.getX(), (double)y, (double)z);
                            this.checkArmorstand(sign, curloc, name, id);
                            ArmorStandManager.debugParticles(curloc);
                        }
                        --z;
                    }
                    return;
                }
                case EAST: 
                case EAST_NORTH_EAST: 
                case EAST_SOUTH_EAST: {
                    int x = sl.getBlockX();
                    while (x > sl.getBlockX() - 2) {
                        for (int y = sl.getBlockY() + 1; y > sl.getBlockY() - 1; --y) {
                            Location curloc = new Location(sl.getWorld(), (double)x, (double)y, sl.getZ());
                            this.checkArmorstand(sign, curloc, name, id);
                            ArmorStandManager.debugParticles(curloc);
                        }
                        --x;
                    }
                    return;
                }
                case WEST: 
                case WEST_NORTH_WEST: 
                case WEST_SOUTH_WEST: {
                    int x = sl.getBlockX() + 1;
                    while (x > sl.getBlockX() - 1) {
                        for (int y = sl.getBlockY() + 1; y > sl.getBlockY() - 1; --y) {
                            Location curloc = new Location(sl.getWorld(), (double)x, (double)y, sl.getZ());
                            this.checkArmorstand(sign, curloc, name, id);
                            ArmorStandManager.debugParticles(curloc);
                        }
                        --x;
                    }
                    return;
                }
            }
            return;
        }
        catch (InterruptedException | ExecutionException e) {
            if (this.plugin.isShuttingDown()) {
                return;
            }
            this.plugin.getLogger().log(Level.WARNING, "Interupted while scanning for armorstand:", e);
            return;
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    private Future<Collection<Entity>> getNearbyEntities(Location loc) {
        CompletableFuture<Collection<Entity>> future = new CompletableFuture<Collection<Entity>>();
        World world = loc.getWorld();
        if (world == null) {
            throw new IllegalArgumentException("Invalid world");
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> future.complete(world.getNearbyEntities(loc, 1.0, 1.0, 1.0)));
        return future;
    }

    public static void debugParticles(Location curloc) {
        if (!Debug.particles()) {
            return;
        }
        World world = curloc.getWorld();
        if (world == null) {
            return;
        }
        world.spawnParticle(Particle.FLAME, curloc.add(0.5, 0.5, 0.5).toVector().toLocation(curloc.getWorld()), 20, 0.25, 0.25, 0.25, 0.0);
    }
}

