/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.commands.main.subcommands.signs;

import java.util.Collections;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.commands.base.CommandSender;
import us.ajg0702.leaderboards.commands.base.SubCommand;
import us.ajg0702.leaderboards.displays.signs.BoardSign;

public class Teleport
extends SubCommand {
    private final LeaderboardPlugin plugin;

    public Teleport(LeaderboardPlugin plugin) {
        super("teleport", Collections.singletonList("tp"), null, "Teleport to a signs");
        this.plugin = plugin;
    }

    @Override
    public List<String> autoComplete(CommandSender commandSender, String[] strings) {
        return Collections.emptyList();
    }

    @Override
    public void execute(CommandSender sender, String[] args, String label) {
        int signNumber;
        if (args.length < 1) {
            sender.sendMessage(LeaderboardPlugin.message("<red>This command is meant to be used by clicking on signs in <gold><hover:show_text:Click to run this command><click:RUN_COMMAND:/" + label + " signs list>/" + label + " signs list</click></hover>"));
            return;
        }
        if (!sender.isPlayer()) {
            sender.sendMessage(LeaderboardPlugin.message("<red>You must do this in game!"));
            return;
        }
        List<BoardSign> signs = this.plugin.getSignManager().getSigns();
        Player player = (Player)sender.getHandle();
        try {
            signNumber = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(LeaderboardPlugin.message("<red>Invalid sign number!"));
            return;
        }
        if (signNumber >= signs.size()) {
            sender.sendMessage(LeaderboardPlugin.message("<red>Sign number outside of sign range!"));
            return;
        }
        BoardSign sign = signs.get(signNumber);
        Location loc = sign.getLocation().clone();
        loc.setYaw(player.getLocation().getYaw());
        loc.setPitch(90.0f);
        loc.setX((double)loc.getBlockX() + 0.5);
        loc.setZ((double)loc.getBlockZ() + 0.5);
        player.teleport(loc);
    }
}

