/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.commands.main.subcommands;

import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.boards.StatEntry;
import us.ajg0702.leaderboards.boards.TimedType;
import us.ajg0702.leaderboards.commands.base.CommandSender;
import us.ajg0702.leaderboards.commands.base.SubCommand;

public class ListBoards
extends SubCommand {
    private final LeaderboardPlugin plugin;

    public ListBoards(LeaderboardPlugin plugin) {
        super("list", Collections.emptyList(), "ajleaderboards.use", "List all boards in ajleaderboards, or list the top 10 players in a certain board.");
        this.plugin = plugin;
    }

    @Override
    public List<String> autoComplete(CommandSender commandSender, String[] args) {
        return this.plugin.getTopManager().getBoards();
    }

    @Override
    public void execute(CommandSender sender, String[] args, String label) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (args.length < 1) {
                StringBuilder list = new StringBuilder("&6Boards");
                for (String boardn : this.plugin.getTopManager().getBoards()) {
                    list.append("\n&7- &e").append(boardn);
                }
                sender.sendMessage(LeaderboardPlugin.message(list.toString()));
                return;
            }
            String boardn = args[0];
            if (!this.plugin.getCache().boardExists(boardn)) {
                sender.sendMessage(LeaderboardPlugin.message("&cThe board '" + boardn + "' does not exist."));
                return;
            }
            StringBuilder list = new StringBuilder("&6Top for " + boardn);
            for (int i = 1; i <= 10; ++i) {
                StatEntry e = this.plugin.getCache().getStat(i, boardn, TimedType.ALLTIME);
                list.append("\n&6").append(i).append(". &e").append(e.getPlayerName()).append(" &7- &e").append(e.getScorePretty());
            }
            sender.sendMessage(LeaderboardPlugin.message(list.toString()));
        });
    }
}

