/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.commands.main.subcommands;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import us.ajg0702.leaderboards.Debug;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.cache.helpers.DbRow;
import us.ajg0702.leaderboards.commands.base.CommandSender;
import us.ajg0702.leaderboards.commands.base.SubCommand;

public class Import
extends SubCommand {
    private final LeaderboardPlugin plugin;

    public Import(LeaderboardPlugin plugin) {
        super("import", Collections.emptyList(), null, "Import cache data from a file");
        this.plugin = plugin;
    }

    @Override
    public List<String> autoComplete(CommandSender sender, String[] args) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        File[] files = this.plugin.getDataFolder().listFiles((dir, name) -> name.endsWith(".json"));
        if (files == null) {
            return Collections.emptyList();
        }
        for (File file : files) {
            fileNames.add(file.getName());
        }
        return fileNames;
    }

    @Override
    public void execute(CommandSender sender, String[] args, String label) {
        if (args.length < 1) {
            sender.sendMessage(LeaderboardPlugin.message("&cPlease provide a file name.\n&7Usage: /" + label + " import <file>"));
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            File file = new File(this.plugin.getDataFolder(), args[0]);
            if (!file.exists()) {
                sender.sendMessage(this.plugin.getMessages().getComponent("commands.import.nofile", "FILE:" + file.getName()));
                return;
            }
            this.plugin.getLogger().info("Starting import from " + args[0]);
            sender.sendMessage(this.plugin.getMessages().getComponent("commands.import.starting", "FILE:" + file.getName()));
            try {
                HashSet<String> boards;
                Gson gson = new Gson();
                FileReader fileReader = new FileReader(file);
                JsonObject object = (JsonObject)gson.fromJson((Reader)fileReader, JsonObject.class);
                try {
                    boards = object.keySet();
                }
                catch (NoSuchMethodError e) {
                    boards = new HashSet<String>();
                    for (Map.Entry entry : object.entrySet()) {
                        boards.add((String)entry.getKey());
                    }
                }
                boards.remove("meta");
                int i = 0;
                for (String board : boards) {
                    if (!this.plugin.getCache().boardExists(board)) {
                        this.plugin.getCache().createBoard(board);
                    }
                    Debug.info("Importing " + board);
                    ArrayList<DbRow> rows = new ArrayList<DbRow>();
                    JsonArray jsonRowList = object.getAsJsonArray(board);
                    for (JsonElement element : jsonRowList) {
                        Debug.info(gson.toJson(element));
                        rows.add(DbRow.fromJsonObject(element.getAsJsonObject()));
                    }
                    this.plugin.getCache().insertRows(board, rows);
                    sender.sendMessage(this.plugin.getMessages().getComponent("commands.import.insertprogress", "DONE:" + ++i, "TOTAL:" + boards.size()));
                    this.plugin.getLogger().info(String.format("Import progress: %d/%d fetched", i, boards.size()));
                }
                ((Reader)fileReader).close();
                sender.sendMessage(this.plugin.getMessages().getComponent("commands.import.success", "FILE:" + file.getName()));
                this.plugin.getLogger().info("Import from " + args[0] + " finished");
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Error while importing cache:", e);
                sender.sendMessage(this.plugin.getMessages().getComponent("commands.import.fail", new String[0]));
            }
        });
    }
}

