/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.commands.main.subcommands;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.commands.base.CommandSender;
import us.ajg0702.leaderboards.commands.base.SubCommand;

public class Add
extends SubCommand {
    private final LeaderboardPlugin plugin;

    public Add(LeaderboardPlugin plugin) {
        super("add", Collections.emptyList(), "ajleaderboards.use", "Add a placeholder to ajLeaderboards");
        this.plugin = plugin;
    }

    @Override
    public List<String> autoComplete(CommandSender commandSender, String[] strings) {
        return this.plugin.getCache().getNonExistantBoards();
    }

    @Override
    public void execute(CommandSender sender, String[] args, String label) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (args.length < 1) {
                sender.sendMessage(LeaderboardPlugin.message("&cPlease provide a placeholder to track.\n&7Usage: /" + label + " add <placeholder>"));
                return;
            }
            String placeholder = args[0];
            if ((placeholder = placeholder.replaceAll(Matcher.quoteReplacement("%"), "")).startsWith("ajlb")) {
                sender.sendMessage(LeaderboardPlugin.message("&cYou cannot create a leaderboard out of an ajLeaderboards placeholder!\n&7See how to set up the plugin &r<underlined><click:open_url:https://wiki.ajg0702.us/ajleaderboards/setup/setup>here</click></underlined>"));
                return;
            }
            if (!this.plugin.validatePlaceholder(placeholder, sender)) {
                sender.sendMessage(LeaderboardPlugin.message("&cThe placeholder '" + placeholder + "' does not give a numerical value. Make sure that the placeholder returns a number that is not formatted."));
                return;
            }
            boolean r = this.plugin.getCache().createBoard(placeholder);
            if (r) {
                sender.sendMessage(LeaderboardPlugin.message("&aBoard '" + placeholder + "' successfully created!"));
            } else {
                sender.sendMessage(LeaderboardPlugin.message("&cBoard '" + placeholder + "' creation failed! See console for more info."));
            }
        });
    }
}

