/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.cache;

import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import us.ajg0702.leaderboards.Debug;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.boards.StatEntry;
import us.ajg0702.leaderboards.boards.TimedType;
import us.ajg0702.leaderboards.boards.keys.BoardType;
import us.ajg0702.leaderboards.cache.CacheMethod;
import us.ajg0702.leaderboards.cache.helpers.DbRow;
import us.ajg0702.leaderboards.cache.methods.H2Method;
import us.ajg0702.leaderboards.cache.methods.MysqlMethod;
import us.ajg0702.leaderboards.cache.methods.SqliteMethod;
import us.ajg0702.leaderboards.libs.configurate.ConfigurateException;
import us.ajg0702.leaderboards.libs.utils.common.ConfigFile;
import us.ajg0702.leaderboards.utils.BoardPlayer;
import us.ajg0702.leaderboards.utils.Partition;

public class Cache {
    private String q = "'";
    private final String SELECT_POSITION = "select 'id','value','namecache','prefixcache','suffixcache','displaynamecache'," + this.deltaBuilder() + " from '%s' order by '%s' %s, namecache desc limit 1 offset %d";
    private final String SELECT_PLAYER = "select 'id','value','namecache','prefixcache','suffixcache','displaynamecache'," + this.deltaBuilder() + " from '%s' order by '%s' %s, namecache desc";
    private final String GET_POSITION = "/*%s*/with N as (select *,ROW_NUMBER() OVER (order by '%s' %s) as position from '%s') select 'id','value','namecache','prefixcache','suffixcache','displaynamecache',position," + this.deltaBuilder() + " from N where 'id'=?";
    private final Map<String, String> CREATE_TABLE = ImmutableMap.of((Object)"sqlite", (Object)("create table if not exists '%s' (id TEXT PRIMARY KEY, value DECIMAL(20, 2)" + this.columnBuilder("NUMERIC") + ", namecache TEXT, prefixcache TEXT, suffixcache TEXT, displaynamecache TEXT)"), (Object)"h2", (Object)("create table if not exists '%s' ('id' VARCHAR(36) PRIMARY KEY, 'value' DECIMAL(20, 2)" + this.columnBuilder("BIGINT") + ", 'namecache' VARCHAR(16), 'prefixcache' VARCHAR(255), 'suffixcache' VARCHAR(255), 'displaynamecache' VARCHAR(512))"), (Object)"mysql", (Object)("create table if not exists '%s' ('id' VARCHAR(36) PRIMARY KEY, 'value' DECIMAL(20, 2)" + this.columnBuilder("BIGINT") + ", 'namecache' VARCHAR(16), 'prefixcache' TINYTEXT, 'suffixcache' TINYTEXT, 'displaynamecache' VARCHAR(512))"));
    private final String REMOVE_PLAYER = "delete from '%s' where 'namecache'=?";
    private final Map<String, String> LIST_TABLES = ImmutableMap.of((Object)"sqlite", (Object)"SELECT name FROM sqlite_master WHERE type='table' AND name NOT LIKE 'sqlite_%';");
    private final String DROP_TABLE = "drop table '%s';";
    private final String INSERT_PLAYER = "insert into '%s' ('id', 'value', 'namecache', 'prefixcache', 'suffixcache', 'displaynamecache'" + this.tableBuilder() + ") values (?, ?, ?, ?, ?, ?" + this.qBuilder() + ")";
    private final String UPDATE_PLAYER = "update '%s' set 'value'=?, 'namecache'=?, 'prefixcache'=?, 'suffixcache'=?, 'displaynamecache'=?" + this.updateBuilder() + " where id=?";
    private final String QUERY_LASTTOTAL = "select '%s' from '%s' where id=?";
    private final String QUERY_LASTRESET = "select '%s' from '%s' limit 1";
    private final String QUERY_IDVALUE = "select id,'value' from '%s'";
    private final String UPDATE_RESET = "update '%s' set '%s'=?, '%s'=?, '%s'=? where id=?";
    private final String QUERY_ALL = "select * from '%s'";
    private final String CREATE_TIMESTAMP_INDEX = "create index %s_timestamp on '%s' (%s_timestamp)";
    ConfigFile storageConfig;
    final LeaderboardPlugin plugin;
    final CacheMethod method;
    final String tablePrefix;
    List<String> nonExistantBoards = new ArrayList<String>();
    public List<Integer> rolling = new CopyOnWriteArrayList<Integer>();
    private final Map<String, Integer> sortByIndexes = new ConcurrentHashMap<String, Integer>();
    List<BoardPlayer> zeroPlayers = new CopyOnWriteArrayList<BoardPlayer>();
    private static final HashMap<String, String> altPlaceholders = new HashMap<String, String>(){
        {
            this.put("ajpk_stats_highscore", "ajpk_stats_highscore_nocache");
            this.put("ajtr_stats_wins", "ajtr_stats_wins_nocache");
            this.put("ajtr_stats_losses", "ajtr_stats_losses_nocache");
            this.put("ajtr_stats_gamesplayed", "ajtr_stats_gamesplayer_nocache");
        }
    };
    Map<String, Integer> dataSortByIndexes = new ConcurrentHashMap<String, Integer>();

    public LeaderboardPlugin getPlugin() {
        return this.plugin;
    }

    public Cache(LeaderboardPlugin plugin) {
        this.plugin = plugin;
        if (plugin.getDataFolder().mkdirs()) {
            plugin.getLogger().info("Directory created");
        }
        try {
            this.storageConfig = new ConfigFile(plugin.getDataFolder(), plugin.getLogger(), "cache_storage.yml");
        }
        catch (ConfigurateException e) {
            plugin.getLogger().log(Level.SEVERE, "Error when loading cache storage config! The plugin may not work properly!", e);
        }
        String methodStr = this.storageConfig.getString("method");
        if (methodStr.equalsIgnoreCase("mysql")) {
            plugin.getLogger().info("Using MySQL for board cache. (" + methodStr + ")");
            this.method = new MysqlMethod();
            this.tablePrefix = this.storageConfig.getString("table_prefix");
            this.q = "`";
        } else if (methodStr.equalsIgnoreCase("sqlite")) {
            plugin.getLogger().info("Using SQLite for board cache. (" + methodStr + ")");
            this.method = new SqliteMethod();
            this.tablePrefix = "";
            this.q = "'";
        } else {
            plugin.getLogger().info("Using H2 flatfile for board cache. (" + methodStr + ")");
            this.method = new H2Method();
            this.tablePrefix = "";
            this.q = "`";
        }
        this.method.init(plugin, this.storageConfig, this);
    }

    public StatEntry getStat(int position, String board, TimedType type) {
        if (!this.plugin.getTopManager().boardExists(board)) {
            if (!this.nonExistantBoards.contains(board)) {
                this.nonExistantBoards.add(board);
            }
            return StatEntry.boardNotFound(this.plugin, position, board, type);
        }
        boolean reverse = this.plugin.getAConfig().getStringList("reverse-sort").contains(board);
        try {
            Connection conn = this.method.getConnection();
            String sortBy = type == TimedType.ALLTIME ? "value" : type.lowerName() + "_delta";
            PreparedStatement ps = conn.prepareStatement(String.format(this.method.formatStatement(this.SELECT_POSITION), this.tablePrefix + board, sortBy, reverse ? "asc" : "desc", position - 1));
            ResultSet r = ps.executeQuery();
            StatEntry se = this.processData(r, sortBy, position, board, type);
            ps.close();
            this.method.close(conn);
            return se;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Unable to get stat of player:", e);
            return StatEntry.error(this.plugin, position, board, type);
        }
    }

    public StatEntry getStatEntry(OfflinePlayer player, String board, TimedType type) {
        long start = System.currentTimeMillis();
        if (!this.plugin.getTopManager().boardExists(board)) {
            if (!this.nonExistantBoards.contains(board)) {
                this.nonExistantBoards.add(board);
            }
            return StatEntry.boardNotFound(this.plugin, -3, board, type);
        }
        boolean reverse = this.plugin.getAConfig().getStringList("reverse-sort").contains(board);
        StatEntry r = null;
        try {
            int position;
            String suffix;
            String prefix;
            String displayName;
            String name;
            double value;
            String uuidraw;
            ResultSet rs;
            PreparedStatement ps;
            Connection conn;
            block9: {
                conn = this.method.getConnection();
                String sortBy = type == TimedType.ALLTIME ? "value" : type.lowerName() + "_delta";
                ps = conn.prepareStatement(String.format(this.method.formatStatement(this.GET_POSITION), board, sortBy, reverse ? "asc" : "desc", this.tablePrefix + board));
                ps.setString(1, player.getUniqueId().toString());
                rs = ps.executeQuery();
                rs.next();
                uuidraw = null;
                value = -1.0;
                displayName = name = "-Unknown-";
                prefix = "";
                suffix = "";
                position = -1;
                try {
                    uuidraw = rs.getString(1);
                    name = rs.getString(3);
                    prefix = rs.getString(4);
                    suffix = rs.getString(5);
                    displayName = rs.getString(6);
                    position = rs.getInt(7);
                    value = rs.getDouble(this.sortByIndexes.computeIfAbsent(sortBy, k -> {
                        try {
                            Debug.info("Calculating (statentry) column for " + sortBy);
                            return rs.findColumn(sortBy);
                        }
                        catch (SQLException e) {
                            this.plugin.getLogger().log(Level.SEVERE, "Error while finding a column for " + sortBy, e);
                            return -1;
                        }
                    }));
                }
                catch (SQLException e) {
                    if (e.getMessage().contains("ResultSet closed") || e.getMessage().contains("empty result set") || e.getMessage().contains("[2000-")) break block9;
                    throw e;
                }
            }
            if (uuidraw != null) {
                r = new StatEntry(position, board, prefix, name, displayName, UUID.fromString(uuidraw), suffix, value, type);
            }
            rs.close();
            ps.close();
            this.method.close(conn);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Unable to get position/value of player:", e);
            return StatEntry.error(this.plugin, -1, board, type);
        }
        this.rolling.add((int)(System.currentTimeMillis() - start));
        if (this.rolling.size() > 50) {
            this.rolling.remove(0);
        }
        if (r == null) {
            return StatEntry.noData(this.plugin, -1, board, type);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBoardSize(String board) {
        int size;
        if (!this.plugin.getTopManager().boardExists(board)) {
            if (!this.nonExistantBoards.contains(board)) {
                this.nonExistantBoards.add(board);
            }
            return -3;
        }
        Connection connection = null;
        ResultSet rs = null;
        try {
            connection = this.method.getConnection();
            PreparedStatement ps = connection.prepareStatement(String.format(this.method.formatStatement("select COUNT(1) from '%s'"), this.tablePrefix + board));
            rs = ps.executeQuery();
            rs.next();
            size = rs.getInt(1);
        }
        catch (SQLException e) {
            if (!(e.getMessage().contains("ResultSet closed") || e.getMessage().contains("empty result set") || e.getMessage().contains("[2000-"))) {
                this.plugin.getLogger().log(Level.WARNING, "Unable to get size of board:", e);
                int n = -1;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            try {
                if (connection != null) {
                    this.method.close(connection);
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.WARNING, "Error while closing resources from board size fetch:", e);
            }
        }
        return size;
    }

    public boolean createBoard(String name) {
        try {
            Connection conn = this.method.getConnection();
            PreparedStatement ps = conn.prepareStatement(this.method.formatStatement(String.format(this.CREATE_TABLE.get(this.method.getName()), this.tablePrefix + name)));
            ps.executeUpdate();
            ps.close();
            for (TimedType type : TimedType.values()) {
                block7: {
                    if (type == TimedType.ALLTIME) continue;
                    try {
                        ps = conn.prepareStatement(this.method.formatStatement(String.format("create index %s_timestamp on '%s' (%s_timestamp)", type.lowerName(), this.tablePrefix + name, type.lowerName())));
                        ps.executeUpdate();
                    }
                    catch (SQLException e) {
                        if (e.getMessage().contains("already exists") || e.getMessage().contains("Duplicate key")) break block7;
                        throw e;
                    }
                }
                ps.close();
            }
            this.method.close(conn);
            this.plugin.getTopManager().fetchBoards();
            this.plugin.getContextLoader().calculatePotentialContexts();
            this.nonExistantBoards.remove(name);
            if (!this.plugin.getTopManager().boardExists(name)) {
                this.plugin.getLogger().warning("Failed to create board: It wasnt created, but there was no error!");
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Unable to create board:", e);
            if (e.getCause() != null) {
                this.plugin.getLogger().log(Level.WARNING, "Cause:", e);
            }
            return false;
        }
    }

    public boolean removePlayer(String board, String playerName) {
        try {
            Connection conn = this.method.getConnection();
            PreparedStatement ps = conn.prepareStatement(String.format(this.method.formatStatement("delete from '%s' where 'namecache'=?"), this.tablePrefix + board));
            ps.setString(1, playerName);
            ps.executeUpdate();
            ps.close();
            this.method.close(conn);
            return true;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Unable to remove player from board:", e);
            return false;
        }
    }

    public boolean boardExists(String board) {
        return this.getBoards().contains(board);
    }

    public List<String> getBoards() {
        ArrayList<String> o = new ArrayList<String>();
        for (String table : this.getDbTableList()) {
            String name;
            if (table.indexOf(this.tablePrefix) != 0 || (name = table.substring(this.tablePrefix.length())).equals("extras")) continue;
            o.add(name);
        }
        return o;
    }

    public List<String> getDbTableList() {
        ArrayList<String> b = new ArrayList<String>();
        try {
            Connection conn = this.method.getConnection();
            Statement statement = conn.createStatement();
            ResultSet r = statement.executeQuery(this.method.formatStatement(this.LIST_TABLES.getOrDefault(this.method.getName(), "show tables;")));
            while (r.next()) {
                String name;
                String e = r.getString(1);
                if (e.indexOf(this.tablePrefix) != 0 || (name = e.substring(this.tablePrefix.length())).equals("extras")) continue;
                b.add(e);
            }
            statement.close();
            r.close();
            this.method.close(conn);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "Unable to get list of tables:", e);
        }
        return b;
    }

    public boolean removeBoard(String board) {
        if (!this.plugin.getTopManager().boardExists(board)) {
            this.plugin.getLogger().warning("Attempted to remove board that doesnt exist!");
            return false;
        }
        try {
            if (this.method instanceof SqliteMethod) {
                ((SqliteMethod)this.method).newConnection();
            }
            Connection conn = this.method.getConnection();
            PreparedStatement ps = conn.prepareStatement(String.format(this.method.formatStatement("drop table '%s';"), this.tablePrefix + board));
            ps.executeUpdate();
            ps.close();
            this.method.close(conn);
            this.plugin.getTopManager().fetchBoards();
            this.plugin.getContextLoader().calculatePotentialContexts();
            if (this.plugin.getTopManager().boardExists(board)) {
                this.plugin.getLogger().warning("Attempted to remove a board, but it didnt get removed!");
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "An error occurred while trying to remove a board:", e);
            return false;
        }
    }

    public void updatePlayerStats(OfflinePlayer player) {
        List<String> updatableBoards = this.plugin.getAConfig().getStringList("only-update");
        for (String b : this.plugin.getTopManager().getBoards()) {
            if (!updatableBoards.isEmpty() && !updatableBoards.contains(b)) continue;
            if (this.plugin.isShuttingDown()) {
                return;
            }
            if (player.isOnline() && player.getPlayer() != null && this.plugin.getAConfig().getBoolean("enable-dontupdate-permission") && player.getPlayer().hasPermission("ajleaderboards.dontupdate." + b)) continue;
            this.updateStat(b, player);
        }
        boolean updateDebug = this.plugin.getAConfig().getBoolean("update-de-bug");
        for (String extra : this.plugin.getExtraManager().getExtras()) {
            String value;
            try {
                value = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)("%" + extra + "%"));
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Placeholder %" + extra + "% threw an error for " + player.getName() + ":", e);
                continue;
            }
            if (updateDebug) {
                Debug.info("Got '" + value + "' from extra " + extra + " for " + player.getName());
            }
            if (value.equals("%" + extra + "%")) {
                this.plugin.getLogger().warning("Extra " + extra + " returned itself! (for " + player.getName() + ") Skipping.");
                continue;
            }
            String cached = this.plugin.getTopManager().getCachedExtra(player.getUniqueId(), extra);
            if (cached != null && cached.equals(value)) {
                if (!updateDebug) continue;
                Debug.info("Skipping updating extra of " + player.getName() + " for " + extra + " because their cached score is the same as their current score");
                continue;
            }
            this.plugin.getExtraManager().setExtra(player.getUniqueId(), extra, value);
        }
    }

    public void updateStat(String board, OfflinePlayer player) {
        StatEntry cached;
        double output;
        if (!this.plugin.getTopManager().boardExists(board)) {
            return;
        }
        boolean debug = this.plugin.getAConfig().getBoolean("update-de-bug");
        if (this.plugin.isShuttingDown()) {
            return;
        }
        try {
            String outputraw = PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)("%" + Cache.alternatePlaceholders(board) + "%")).replaceAll(",", "");
            output = this.plugin.getPlaceholderFormatter().toDouble(outputraw, board);
        }
        catch (NumberFormatException e) {
            if (debug) {
                Debug.info("Placeholder %" + board + "% for " + player.getName() + " returned a non-number! Ignoring it. Message: " + e);
            }
            return;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Placeholder %" + board + "% for player " + player.getName() + " threw an error:", e);
            return;
        }
        if (debug) {
            Debug.info("Placeholder " + board + " for " + player.getName() + " returned " + output);
        }
        BoardPlayer boardPlayer = new BoardPlayer(board, player);
        String displayName = player.getName();
        if (player.isOnline() && player.getPlayer() != null) {
            displayName = player.getPlayer().getDisplayName();
        }
        String prefix = "";
        String suffix = "";
        if (this.plugin.hasVault() && player instanceof Player && this.plugin.getAConfig().getBoolean("fetch-prefix-suffix-from-vault")) {
            prefix = this.plugin.getVaultChat().getPlayerPrefix((Player)player);
            suffix = this.plugin.getVaultChat().getPlayerSuffix((Player)player);
        }
        if ((cached = this.plugin.getTopManager().getCachedStatEntry(player, board, TimedType.ALLTIME)) != null && cached.hasPlayer() && cached.getScore() == output && cached.getPlayerDisplayName().equals(displayName) && cached.getPrefix().equals(prefix) && cached.getSuffix().equals(suffix)) {
            if (debug) {
                Debug.info("Skipping updating of " + player.getName() + " for " + board + " because their cached score is the same as their current score");
            }
            return;
        }
        if (this.plugin.getAConfig().getStringList("dont-add-zero").contains(board) && output == 0.0) {
            Debug.info("Skipping " + player.getName() + " because they returned 0 for " + board + "(dont-add-zero)");
            return;
        }
        if (this.plugin.getAConfig().getBoolean("require-zero-validation")) {
            if (output == 0.0 && !this.zeroPlayers.contains(boardPlayer)) {
                this.zeroPlayers.add(boardPlayer);
                Debug.info("Skipping " + player.getName() + " because they returned 0 for " + board);
                return;
            }
            if (output == 0.0 && this.zeroPlayers.contains(boardPlayer)) {
                Debug.info("Not skipping " + player.getName() + " because they still returned 0 for " + board);
            } else if (output != 0.0) {
                this.zeroPlayers.remove(boardPlayer);
            }
        }
        HashMap<TimedType, Double> lastTotals = new HashMap<TimedType, Double>();
        for (TimedType timedType : TimedType.values()) {
            if (timedType == TimedType.ALLTIME) continue;
            lastTotals.put(timedType, this.getLastTotal(board, player, timedType));
        }
        if (debug) {
            Debug.info("Updating " + player.getName() + " on board " + board + " with values v: " + output + " suffix: " + suffix + " prefix: " + prefix);
        }
        try (Connection conn = this.method.getConnection();){
            try {
                PreparedStatement statement = conn.prepareStatement(String.format(this.method.formatStatement(this.INSERT_PLAYER), this.tablePrefix + board));
                if (debug) {
                    Debug.info("in try");
                }
                statement.setString(1, player.getUniqueId().toString());
                statement.setDouble(2, output);
                statement.setString(3, player.getName());
                statement.setString(4, prefix);
                statement.setString(5, suffix);
                statement.setString(6, displayName);
                int i = 6;
                for (TimedType timedType : TimedType.values()) {
                    if (timedType == TimedType.ALLTIME) continue;
                    long lastReset = this.plugin.getTopManager().getLastReset(board, timedType) * 1000L;
                    if (this.plugin.isShuttingDown()) {
                        this.method.close(conn);
                    }
                    statement.setDouble(++i, 0.0);
                    statement.setDouble(++i, output);
                    statement.setLong(++i, lastReset == 0L ? System.currentTimeMillis() : lastReset);
                }
                statement.executeUpdate();
                statement.close();
                this.method.close(conn);
            }
            catch (SQLException e) {
                if (debug) {
                    Debug.info("in catch: " + e.getMessage());
                }
                try (PreparedStatement statement = conn.prepareStatement(String.format(this.method.formatStatement(this.UPDATE_PLAYER), this.tablePrefix + board));){
                    statement.setDouble(1, output);
                    statement.setString(2, player.getName());
                    statement.setString(3, prefix);
                    statement.setString(4, suffix);
                    statement.setString(5, displayName);
                    HashMap<TimedType, Double> hashMap = new HashMap<TimedType, Double>();
                    hashMap.put(TimedType.ALLTIME, output);
                    int i = 6;
                    for (TimedType type : TimedType.values()) {
                        if (type == TimedType.ALLTIME) continue;
                        double timedOut = output - (Double)lastTotals.get((Object)type);
                        hashMap.put(type, timedOut);
                        statement.setDouble(i++, timedOut);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        StatEntry stat;
                        Integer position;
                        TimedType type = (TimedType)((Object)entry.getKey());
                        double timedOut = (Double)entry.getValue();
                        StatEntry statEntry = this.plugin.getTopManager().getCachedStatEntry(player, board, type, false);
                        if (statEntry != null && player.getUniqueId().equals(statEntry.getPlayerID())) {
                            statEntry.changeScore(timedOut, prefix, suffix);
                        }
                        if ((position = (Integer)((Map)this.plugin.getTopManager().positionPlayerCache.getOrDefault(player.getUniqueId(), new HashMap())).get(new BoardType(board, type))) == null || (stat = this.plugin.getTopManager().getCachedStat(position, board, type)) == null || !player.getUniqueId().equals(stat.getPlayerID())) continue;
                        stat.changeScore(timedOut, prefix, suffix);
                    }
                    statement.setString(i, player.getUniqueId().toString());
                    statement.executeUpdate();
                }
            }
        }
        catch (SQLException e) {
            if (this.plugin.isShuttingDown()) {
                return;
            }
            this.plugin.getLogger().log(Level.WARNING, "Unable to update stat for player:", e);
        }
    }

    public double getLastTotal(String board, OfflinePlayer player, TimedType type) {
        double last = 0.0;
        try {
            Connection conn = this.method.getConnection();
            try {
                PreparedStatement ps = conn.prepareStatement(String.format(this.method.formatStatement("select '%s' from '%s' where id=?"), type.lowerName() + "_lasttotal", this.tablePrefix + board));
                ps.setString(1, player.getUniqueId().toString());
                ResultSet rs = ps.executeQuery();
                if (this.method instanceof MysqlMethod || this.method instanceof H2Method) {
                    rs.next();
                }
                last = rs.getDouble(1);
                rs.close();
                ps.close();
                this.method.close(conn);
            }
            catch (SQLException e) {
                this.method.close(conn);
                String m = e.getMessage();
                if (m.contains("empty result set") || m.contains("ResultSet closed") || m.contains("[2000-")) {
                    return last;
                }
                this.plugin.getLogger().log(Level.WARNING, "Unable to get last total for " + player.getName() + " on " + (Object)((Object)type) + " of " + board, e);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return last;
    }

    public long getLastReset(String board, TimedType type) {
        long last = 0L;
        try {
            Connection conn = this.method.getConnection();
            try {
                PreparedStatement ps = conn.prepareStatement(String.format(this.method.formatStatement("select '%s' from '%s' limit 1"), type.lowerName() + "_timestamp", this.tablePrefix + board));
                ResultSet rs = ps.executeQuery();
                if (this.method instanceof MysqlMethod || this.method instanceof H2Method) {
                    rs.next();
                }
                last = rs.getLong(1);
                ps.close();
                this.method.close(conn);
            }
            catch (SQLException e) {
                this.method.close(conn);
                String m = e.getMessage();
                if (m.contains("empty result set") || m.contains("ResultSet closed") || m.contains("[2000-")) {
                    return last;
                }
                this.plugin.getLogger().log(Level.WARNING, "Unable to get last reset for " + (Object)((Object)type) + " of " + board, e);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return last;
    }

    public void reset(String board, TimedType type) throws ExecutionException, InterruptedException {
        if (!this.plugin.getTopManager().boardExists(board)) {
            return;
        }
        if (!this.plugin.getAConfig().getBoolean("update-stats")) {
            return;
        }
        List<String> updatableBoards = this.plugin.getAConfig().getStringList("only-update");
        if (!updatableBoards.isEmpty() && !updatableBoards.contains(board)) {
            return;
        }
        long startTime = System.currentTimeMillis();
        LocalDateTime startDateTime = LocalDateTime.now();
        long newTime = startDateTime.atOffset(ZoneOffset.UTC).toEpochSecond() * 1000L;
        Debug.info(board + " " + (Object)((Object)type) + " " + startDateTime.atOffset(ZoneOffset.UTC).format(DateTimeFormatter.RFC_1123_DATE_TIME) + " " + newTime);
        if (type.equals((Object)TimedType.ALLTIME)) {
            throw new IllegalArgumentException("Cannot reset ALLTIME!");
        }
        Debug.info("Resetting " + board + " " + type.lowerName() + " leaderboard");
        long lastReset = this.plugin.getTopManager().getLastReset(board, type) * 1000L;
        if (this.plugin.isShuttingDown()) {
            return;
        }
        Debug.info("last: " + lastReset + " gap: " + (startTime - lastReset));
        String t = type.lowerName();
        try {
            Connection conn = this.method.getConnection();
            PreparedStatement ps = conn.prepareStatement(String.format(this.method.formatStatement("select id,'value' from '%s'"), this.tablePrefix + board));
            ResultSet rs = ps.executeQuery();
            HashMap<String, Double> uuids = new HashMap<String, Double>();
            while (rs.next()) {
                uuids.put(rs.getString(1), rs.getDouble(2));
            }
            rs.close();
            ps.close();
            this.method.close(conn);
            Partition partition = Partition.ofSize(new ArrayList(uuids.keySet()), Math.max(uuids.size() / (int)Math.ceil((double)this.method.getMaxConnections() / 2.0), 1));
            Debug.info("Partition length: " + partition.size() + " uuids size: " + uuids.size() + " partition chunk size: " + partition.getChunkSize());
            for (List list : partition) {
                if (this.plugin.isShuttingDown()) {
                    this.method.close(conn);
                    return;
                }
                try {
                    Connection con = this.method.getConnection();
                    for (String idRaw : list) {
                        if (this.plugin.isShuttingDown()) {
                            this.method.close(con);
                            return;
                        }
                        PreparedStatement p = con.prepareStatement(String.format(this.method.formatStatement("update '%s' set '%s'=?, '%s'=?, '%s'=? where id=?"), this.tablePrefix + board, t + "_lasttotal", t + "_delta", t + "_timestamp"));
                        p.setDouble(1, (Double)uuids.get(idRaw));
                        p.setDouble(2, 0.0);
                        p.setLong(3, newTime);
                        p.setString(4, idRaw);
                        p.executeUpdate();
                        p.close();
                    }
                    this.method.close(con);
                }
                catch (SQLException e) {
                    this.plugin.getLogger().log(Level.WARNING, "An error occurred while resetting " + (Object)((Object)type) + " of " + board + ":", e);
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "An error occurred while resetting " + (Object)((Object)type) + " of " + board + ":", e);
        }
        Debug.info("Reset of " + board + " " + type.lowerName() + " took " + (System.currentTimeMillis() - startTime) + "ms");
    }

    public void insertRows(String board, List<DbRow> rows) throws SQLException {
        Connection conn = this.method.getConnection();
        for (DbRow row : rows) {
            PreparedStatement statement = conn.prepareStatement(String.format(this.method.formatStatement(this.INSERT_PLAYER), this.tablePrefix + board));
            statement.setString(1, row.getId().toString());
            statement.setDouble(2, row.getValue());
            statement.setString(3, row.getNamecache());
            statement.setString(4, row.getPrefixcache());
            statement.setString(5, row.getSuffixcache());
            statement.setString(6, row.getDisplaynamecache());
            int i = 6;
            for (TimedType type : TimedType.values()) {
                if (type == TimedType.ALLTIME) continue;
                if (this.plugin.isShuttingDown()) {
                    this.method.close(conn);
                }
                statement.setDouble(++i, row.getDeltas().get((Object)type));
                statement.setDouble(++i, row.getLastTotals().get((Object)type));
                statement.setLong(++i, row.getTimestamps().get((Object)type));
            }
            try {
                statement.executeUpdate();
            }
            catch (SQLException e) {
                if (e.getMessage().contains("23505") || e.getMessage().contains("Duplicate entry") || e.getMessage().contains("PRIMARY KEY constraint failed")) {
                    statement.close();
                    continue;
                }
                throw e;
            }
            statement.close();
        }
        this.method.close(conn);
    }

    public List<DbRow> getRows(String board) throws SQLException {
        Connection conn = this.method.getConnection();
        PreparedStatement ps = conn.prepareStatement(String.format(this.method.formatStatement("select * from '%s'"), this.tablePrefix + board));
        ResultSet resultSet = ps.executeQuery();
        ArrayList<DbRow> out = new ArrayList<DbRow>();
        while (resultSet.next()) {
            out.add(new DbRow(resultSet));
        }
        ps.close();
        resultSet.close();
        this.method.close(conn);
        return out;
    }

    public CacheMethod getMethod() {
        return this.method;
    }

    public static String alternatePlaceholders(String board) {
        return altPlaceholders.getOrDefault(board, board);
    }

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    private String deltaBuilder() {
        StringBuilder deltaBuilder = new StringBuilder();
        for (TimedType t : TimedType.values()) {
            if (t == TimedType.ALLTIME) continue;
            deltaBuilder.append(this.q).append(t.lowerName()).append("_delta").append(this.q).append(",");
        }
        return deltaBuilder.deleteCharAt(deltaBuilder.length() - 1).toString();
    }

    private String columnBuilder(String t) {
        String q = "'";
        StringBuilder columns = new StringBuilder();
        for (TimedType type : TimedType.values()) {
            if (type == TimedType.ALLTIME) continue;
            columns.append(",\n").append(q).append(type.lowerName()).append("_delta").append(q).append(" ").append(t).append(",\n").append(q).append(type.lowerName()).append("_lasttotal").append(q).append(" ").append(t).append(",\n").append(q).append(type.lowerName()).append("_timestamp").append(q).append(" ").append(t);
        }
        return columns.toString();
    }

    private String qBuilder() {
        StringBuilder addQs = new StringBuilder();
        for (TimedType type : TimedType.values()) {
            if (type == TimedType.ALLTIME) continue;
            addQs.append(", ?").append(", ?").append(", ?");
        }
        return addQs.toString();
    }

    private String tableBuilder() {
        StringBuilder addTables = new StringBuilder();
        for (TimedType type : TimedType.values()) {
            if (type == TimedType.ALLTIME) continue;
            String name = type.lowerName();
            addTables.append(", ").append(name).append("_delta").append(", ").append(name).append("_lasttotal").append(", ").append(name).append("_timestamp");
        }
        return addTables.toString();
    }

    private String updateBuilder() {
        StringBuilder addUpdates = new StringBuilder();
        for (TimedType type : TimedType.values()) {
            if (type == TimedType.ALLTIME) continue;
            String name = type.lowerName();
            addUpdates.append(", ").append(name).append("_delta").append("=?");
        }
        return addUpdates.toString();
    }

    private StatEntry processData(ResultSet r, String sortBy, int position, String board, TimedType type) throws SQLException {
        String suffix;
        String prefix;
        String displayName;
        String name;
        double value;
        String uuidRaw;
        block5: {
            uuidRaw = null;
            value = -1.0;
            displayName = name = "-Unknown-";
            prefix = "";
            suffix = "";
            if (this.method instanceof MysqlMethod || this.method instanceof H2Method) {
                r.next();
            }
            try {
                uuidRaw = r.getString(1);
                name = r.getString(3);
                prefix = r.getString(4);
                suffix = r.getString(5);
                displayName = r.getString(6);
                value = r.getDouble(this.dataSortByIndexes.computeIfAbsent(sortBy, k -> {
                    try {
                        Debug.info("Calculating (process) column for " + sortBy);
                        return r.findColumn(sortBy);
                    }
                    catch (SQLException e) {
                        this.plugin.getLogger().log(Level.SEVERE, "Error while finding a column for " + sortBy, e);
                        return -1;
                    }
                }));
            }
            catch (SQLException e) {
                if (e.getMessage().contains("ResultSet closed") || e.getMessage().contains("empty result set") || e.getMessage().contains("[2000-")) break block5;
                throw e;
            }
        }
        if (name == null) {
            name = "-Unknown";
        }
        r.close();
        if (uuidRaw == null) {
            return StatEntry.noData(this.plugin, position, board, type);
        }
        return new StatEntry(position, board, prefix, name, displayName, UUID.fromString(uuidRaw), suffix, value, type);
    }

    public void cleanPlayer(Player player) {
        this.zeroPlayers.removeIf(boardPlayer -> boardPlayer.getPlayer().equals(player));
    }

    public List<String> getNonExistantBoards() {
        return this.nonExistantBoards;
    }
}

