/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.h2.expression.condition;

import java.util.AbstractList;
import us.ajg0702.leaderboards.libs.h2.engine.SessionLocal;
import us.ajg0702.leaderboards.libs.h2.expression.Expression;
import us.ajg0702.leaderboards.libs.h2.expression.ExpressionColumn;
import us.ajg0702.leaderboards.libs.h2.expression.ExpressionVisitor;
import us.ajg0702.leaderboards.libs.h2.expression.Parameter;
import us.ajg0702.leaderboards.libs.h2.expression.TypedValueExpression;
import us.ajg0702.leaderboards.libs.h2.expression.ValueExpression;
import us.ajg0702.leaderboards.libs.h2.expression.condition.Comparison;
import us.ajg0702.leaderboards.libs.h2.expression.condition.Condition;
import us.ajg0702.leaderboards.libs.h2.index.IndexCondition;
import us.ajg0702.leaderboards.libs.h2.table.ColumnResolver;
import us.ajg0702.leaderboards.libs.h2.table.TableFilter;
import us.ajg0702.leaderboards.libs.h2.value.Value;
import us.ajg0702.leaderboards.libs.h2.value.ValueArray;
import us.ajg0702.leaderboards.libs.h2.value.ValueBoolean;
import us.ajg0702.leaderboards.libs.h2.value.ValueNull;

public final class ConditionInParameter
extends Condition {
    private Expression left;
    private boolean not;
    private boolean whenOperand;
    private final Parameter parameter;

    static Value getValue(SessionLocal sessionLocal, Value value, boolean bl, Value value2) {
        boolean bl2 = false;
        if (value2.containsNull()) {
            bl2 = true;
        } else {
            for (Value value3 : value2.convertToAnyArray(sessionLocal).getList()) {
                Value value4 = Comparison.compare(sessionLocal, value, value3, 0);
                if (value4 == ValueNull.INSTANCE) {
                    bl2 = true;
                    continue;
                }
                if (value4 != ValueBoolean.TRUE) continue;
                return ValueBoolean.get(!bl);
            }
        }
        if (bl2) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(bl);
    }

    public ConditionInParameter(Expression expression, boolean bl, boolean bl2, Parameter parameter) {
        this.left = expression;
        this.not = bl;
        this.whenOperand = bl2;
        this.parameter = parameter;
    }

    @Override
    public Value getValue(SessionLocal sessionLocal) {
        Value value = this.left.getValue(sessionLocal);
        if (value == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        return ConditionInParameter.getValue(sessionLocal, value, this.not, this.parameter.getValue(sessionLocal));
    }

    @Override
    public boolean getWhenValue(SessionLocal sessionLocal, Value value) {
        if (!this.whenOperand) {
            return super.getWhenValue(sessionLocal, value);
        }
        if (value == ValueNull.INSTANCE) {
            return false;
        }
        return ConditionInParameter.getValue(sessionLocal, value, this.not, this.parameter.getValue(sessionLocal)).isTrue();
    }

    @Override
    public boolean isWhenConditionOperand() {
        return this.whenOperand;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.left.mapColumns(columnResolver, n, n2);
    }

    @Override
    public Expression optimize(SessionLocal sessionLocal) {
        this.left = this.left.optimize(sessionLocal);
        if (!this.whenOperand && this.left.isNullConstant()) {
            return TypedValueExpression.UNKNOWN;
        }
        return this;
    }

    @Override
    public Expression getNotIfPossible(SessionLocal sessionLocal) {
        if (this.whenOperand) {
            return null;
        }
        return new ConditionInParameter(this.left, !this.not, false, this.parameter);
    }

    @Override
    public void createIndexConditions(SessionLocal sessionLocal, TableFilter tableFilter) {
        if (this.not || this.whenOperand || !(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        tableFilter.addIndexCondition(IndexCondition.getInList(expressionColumn, new ParameterList(this.parameter)));
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
    }

    @Override
    public boolean needParentheses() {
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder stringBuilder, int n) {
        if (this.not) {
            stringBuilder.append("NOT (");
        }
        this.left.getSQL(stringBuilder, n, 0);
        this.parameter.getSQL(stringBuilder.append(" = ANY("), n, 0).append(')');
        if (this.not) {
            stringBuilder.append(')');
        }
        return stringBuilder;
    }

    @Override
    public StringBuilder getWhenSQL(StringBuilder stringBuilder, int n) {
        if (this.not) {
            stringBuilder.append(" NOT IN(UNNEST(");
            this.parameter.getSQL(stringBuilder, n, 0).append("))");
        } else {
            stringBuilder.append(" = ANY(");
            this.parameter.getSQL(stringBuilder, n, 0).append(')');
        }
        return stringBuilder;
    }

    @Override
    public void updateAggregate(SessionLocal sessionLocal, int n) {
        this.left.updateAggregate(sessionLocal, n);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.parameter.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost();
    }

    private static final class ParameterList
    extends AbstractList<Expression> {
        private final Parameter parameter;

        ParameterList(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public Expression get(int n) {
            Value value = this.parameter.getParamValue();
            if (value instanceof ValueArray) {
                return ValueExpression.get(((ValueArray)value).getList()[n]);
            }
            if (n != 0) {
                throw new IndexOutOfBoundsException();
            }
            return ValueExpression.get(value);
        }

        @Override
        public int size() {
            if (!this.parameter.isValueSet()) {
                return 0;
            }
            Value value = this.parameter.getParamValue();
            if (value instanceof ValueArray) {
                return ((ValueArray)value).getList().length;
            }
            return 1;
        }
    }
}

