/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.h2.command.dml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import us.ajg0702.leaderboards.libs.h2.command.Prepared;
import us.ajg0702.leaderboards.libs.h2.engine.Database;
import us.ajg0702.leaderboards.libs.h2.engine.SessionLocal;
import us.ajg0702.leaderboards.libs.h2.expression.Expression;
import us.ajg0702.leaderboards.libs.h2.message.DbException;
import us.ajg0702.leaderboards.libs.h2.mvstore.MVStore;
import us.ajg0702.leaderboards.libs.h2.mvstore.db.Store;
import us.ajg0702.leaderboards.libs.h2.result.ResultInterface;
import us.ajg0702.leaderboards.libs.h2.store.FileLister;
import us.ajg0702.leaderboards.libs.h2.store.fs.FileUtils;
import us.ajg0702.leaderboards.libs.h2.util.IOUtils;

public class BackupCommand
extends Prepared {
    private Expression fileNameExpr;

    public BackupCommand(SessionLocal sessionLocal) {
        super(sessionLocal);
    }

    public void setFileName(Expression expression) {
        this.fileNameExpr = expression;
    }

    @Override
    public long update() {
        String string = this.fileNameExpr.getValue(this.session).getString();
        this.session.getUser().checkAdmin();
        this.backupTo(string);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupTo(String string) {
        Database database = this.session.getDatabase();
        if (!database.isPersistent()) {
            throw DbException.get(90126);
        }
        try {
            Store store = database.getStore();
            store.flush();
            String string2 = database.getName();
            string2 = FileUtils.getName(string2);
            try (OutputStream outputStream = FileUtils.newOutputStream(string, false);){
                ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
                database.flush();
                String string3 = FileUtils.getParent(database.getName());
                Object object = database.getLobSyncObject();
                synchronized (object) {
                    String string4 = database.getDatabasePath();
                    String string5 = FileUtils.getParent(string4);
                    string5 = FileLister.getDir(string5);
                    ArrayList<String> arrayList = FileLister.getDatabaseFiles(string5, string2, true);
                    for (String string6 : arrayList) {
                        if (!string6.endsWith(".mv.db")) continue;
                        MVStore mVStore = store.getMvStore();
                        boolean bl = mVStore.getReuseSpace();
                        mVStore.setReuseSpace(false);
                        try {
                            InputStream inputStream = store.getInputStream();
                            BackupCommand.backupFile(zipOutputStream, string3, string6, inputStream);
                        }
                        finally {
                            mVStore.setReuseSpace(bl);
                        }
                    }
                }
                zipOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, string);
        }
    }

    private static void backupFile(ZipOutputStream zipOutputStream, String string, String string2, InputStream inputStream) throws IOException {
        String string3 = FileUtils.toRealPath(string2);
        if (!string3.startsWith(string = FileUtils.toRealPath(string))) {
            throw DbException.getInternalError(string3 + " does not start with " + string);
        }
        string3 = string3.substring(string.length());
        string3 = BackupCommand.correctFileName(string3);
        zipOutputStream.putNextEntry(new ZipEntry(string3));
        IOUtils.copyAndCloseInput(inputStream, zipOutputStream);
        zipOutputStream.closeEntry();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public static String correctFileName(String string) {
        if ((string = string.replace('\\', '/')).startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 56;
    }
}

